/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import java.math.BigInteger;
import lombok.Generated;

public class ServerIostatAverageServiceTimeCounter {
    private long previousReadsPerSec;
    private long previousWritesPerSec;
    private long previousAverageServiceTime;
    private BigInteger previousTimestamp;
    private long lastComputedResult;

    public long calculate(long currentReadsPerSec, long currentWritesPerSec, long currentAverageServiceTime, BigInteger currentTimestamp) {
        if (this.previousTimestamp != null) {
            if (currentTimestamp.equals(this.previousTimestamp)) {
                return this.lastComputedResult;
            }
            BigInteger currentReadWrites = currentTimestamp.multiply(BigInteger.valueOf(currentReadsPerSec + currentWritesPerSec));
            BigInteger previousReadWrites = this.previousTimestamp.multiply(BigInteger.valueOf(this.previousReadsPerSec + this.previousWritesPerSec));
            BigInteger totalServiceTimePrevious = previousReadWrites.multiply(BigInteger.valueOf(this.previousAverageServiceTime));
            BigInteger totalServiceTimeCurrent = currentReadWrites.multiply(BigInteger.valueOf(currentAverageServiceTime));
            long numberOfDeltaReadsWrites = currentReadWrites.subtract(previousReadWrites).longValue();
            if (numberOfDeltaReadsWrites != 0L) {
                this.lastComputedResult = totalServiceTimeCurrent.subtract(totalServiceTimePrevious).longValue() / numberOfDeltaReadsWrites;
            }
        }
        this.previousReadsPerSec = currentReadsPerSec;
        this.previousWritesPerSec = currentWritesPerSec;
        this.previousAverageServiceTime = currentAverageServiceTime;
        this.previousTimestamp = currentTimestamp;
        return this.lastComputedResult;
    }

    @Generated
    public String toString() {
        return "ServerIostatAverageServiceTimeCounter(previousReadsPerSec=" + this.previousReadsPerSec + ", previousWritesPerSec=" + this.previousWritesPerSec + ", previousAverageServiceTime=" + this.previousAverageServiceTime + ", previousTimestamp=" + String.valueOf(this.previousTimestamp) + ", lastComputedResult=" + this.getLastComputedResult() + ")";
    }

    @Generated
    public long getLastComputedResult() {
        return this.lastComputedResult;
    }
}

