/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.google.common.collect.ImmutableMap;
import java.util.Set;
import lombok.Generated;

public class NixProcessClassCpuUsageCalculator {
    private ImmutableMap<Integer, Long> previousPidToCpuTime;
    private long previousEpochTime;
    private long lastCookedResult;

    public long calculate(ImmutableMap<Integer, Long> inputMap, long currentEpochTime, Set<Integer> filteredProcessIdSet) {
        if (this.previousPidToCpuTime != null && currentEpochTime > this.previousEpochTime) {
            long currentCpuTime = 0L;
            long previousCpuTime = 0L;
            for (int pid : filteredProcessIdSet) {
                if (!inputMap.containsKey((Object)pid)) continue;
                currentCpuTime += ((Long)inputMap.get((Object)pid)).longValue();
                if (!this.previousPidToCpuTime.containsKey((Object)pid)) continue;
                previousCpuTime += ((Long)this.previousPidToCpuTime.get((Object)pid)).longValue();
            }
            long cpuTimeDifference = currentCpuTime - previousCpuTime;
            long epochTimeDifference = currentEpochTime - this.previousEpochTime;
            this.lastCookedResult = Math.round(100.0 * (double)cpuTimeDifference / (double)epochTimeDifference);
        }
        this.previousEpochTime = currentEpochTime;
        this.previousPidToCpuTime = inputMap;
        return this.lastCookedResult;
    }

    @Generated
    public String toString() {
        return "NixProcessClassCpuUsageCalculator(previousPidToCpuTime=" + String.valueOf(this.previousPidToCpuTime) + ", previousEpochTime=" + this.previousEpochTime + ", lastCookedResult=" + this.getLastCookedResult() + ")";
    }

    @Generated
    public NixProcessClassCpuUsageCalculator() {
    }

    @Generated
    public long getLastCookedResult() {
        return this.lastCookedResult;
    }
}

