/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Singleton;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MachineAgentHomeFinder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MachineAgentHomeFinder.class);
    private static final String FILE = "file:";
    private static final String FORWARD_SLASH = "/";

    public String getMachineAgentHomePath(String scriptName) {
        Path machineAgentHomePath;
        String processedPath;
        String rawPath = "";
        try {
            rawPath = this.getRawScriptPath(scriptName);
            processedPath = new URI(rawPath).getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to convert raw collector script path to URI with script name: " + scriptName + " and path: " + rawPath);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Unable to find the path to the script: " + scriptName);
        }
        try {
            Path collectorScriptPath = Paths.get(processedPath, new String[0]);
            machineAgentHomePath = collectorScriptPath.getParent().getParent().getParent().getParent().getParent();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Unable to get the Machine Agent Home from the collector script path given: " + processedPath);
        }
        return machineAgentHomePath.toAbsolutePath().toString();
    }

    @VisibleForTesting
    public String getRawScriptPath(String scriptName) {
        String scriptUrl = this.getScriptUrl(scriptName).getPath();
        if (scriptUrl.startsWith(FILE)) {
            scriptUrl = scriptUrl.substring(FILE.length());
        }
        if (SystemUtils.IS_OS_WINDOWS && scriptUrl.startsWith(FORWARD_SLASH)) {
            scriptUrl = scriptUrl.substring(FORWARD_SLASH.length());
        }
        return scriptUrl;
    }

    @VisibleForTesting
    URL getScriptUrl(String scriptName) {
        return this.getClass().getResource(scriptName);
    }

    @Generated
    public MachineAgentHomeFinder() {
    }
}

