/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.util;

import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import io.dropwizard.util.SizeUnit;
import java.math.BigInteger;

public class CalculationUtils {
    private static final double PERCENT = 100.0;

    public static long bytesToBits(long bytes) {
        return UnknownValueUtil.calculatedValueOrUnknown(bytes, bytes * 8L);
    }

    public static long hzToMhz(long hz) {
        return UnknownValueUtil.calculatedValueOrUnknown(hz, hz / 1000000L);
    }

    public static long calculatePercentage(long value, long total) {
        long calculatedValue = total == 0L ? 0L : Math.round((double)value * 100.0 / (double)total);
        return UnknownValueUtil.calculatedValueOrUnknown(value, total, calculatedValue);
    }

    public static RawDataLong calculatePercentage(RawDataLong value, RawDataLong total, RawDataFactory rawDataFactory) {
        long calculatedPercentage;
        if (value.isPresent() && total.isPresent() && !UnknownValueUtil.isUnknownValue(calculatedPercentage = CalculationUtils.calculatePercentage(value.get(), total.get()))) {
            return rawDataFactory.createLong(Long.valueOf(calculatedPercentage));
        }
        return rawDataFactory.createLong(String.format("Could not calculate percentage from %s and %s", value, total));
    }

    public static long subtract(long value1, long value2) {
        long calculatedValue = value1 - value2;
        return UnknownValueUtil.calculatedValueOrUnknown(value1, value2, Math.max(0L, calculatedValue));
    }

    public static RawDataLong subtract(RawDataLong value1, RawDataLong value2, RawDataFactory rawDataFactory) {
        long returnValue;
        if (value1.isPresent() && value2.isPresent() && !UnknownValueUtil.isUnknownValue(returnValue = CalculationUtils.subtract(value1.get(), value2.get()))) {
            return rawDataFactory.createLong(Long.valueOf(returnValue));
        }
        return rawDataFactory.createLong(String.format("Could not calculate value from %s and %s", value1, value2));
    }

    public static long divide(long value1, long value2) {
        long calculatedValue = value2 == 0L ? 0L : value1 / value2;
        return UnknownValueUtil.calculatedValueOrUnknown(value1, value2, calculatedValue);
    }

    public static long kilobytesToMegabytes(long value) {
        return UnknownValueUtil.calculatedValueOrUnknown(value, SizeUnit.KILOBYTES.toMegabytes(value));
    }

    public static long kilobytesToBytes(long value) {
        return UnknownValueUtil.calculatedValueOrUnknown(value, SizeUnit.KILOBYTES.toBytes(value));
    }

    public static long bytesToMegabytes(long value) {
        return UnknownValueUtil.calculatedValueOrUnknown(value, SizeUnit.BYTES.toMegabytes(value));
    }

    public static long bytesToKilobytes(long value) {
        return UnknownValueUtil.calculatedValueOrUnknown(value, SizeUnit.BYTES.toKilobytes(value));
    }

    public static long megabytesToKilobytes(long value) {
        return UnknownValueUtil.calculatedValueOrUnknown(value, SizeUnit.MEGABYTES.toKilobytes(value));
    }

    public static long aggregateComponentValue(long total, long valueToAdd) {
        if (!UnknownValueUtil.isUnknownValue(valueToAdd)) {
            if (UnknownValueUtil.isUnknownValue(total)) {
                total = 0L;
            }
            total += valueToAdd;
        }
        return total;
    }

    public static BigInteger aggregateComponentValue(BigInteger total, BigInteger valueToAdd) {
        if (!UnknownValueUtil.isUnknownValue(valueToAdd)) {
            if (UnknownValueUtil.isUnknownValue(total)) {
                total = BigInteger.ZERO;
            }
            total = total.add(valueToAdd);
        }
        return total;
    }
}

