/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.utils.BashPathProvider;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringConfigsDecider;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlMonitoringSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlMonitoringSupplier.class);
    private final UrlMonitoringConfigsDecider urlMonitoringConfigsDecider;
    private final MetricsService metricsService;
    private final String PING_COUNT = "3";
    private final String PING_URL = "ping -c 3 ";
    private final String PIPE = " | ";
    private final String GREP_RTT = "grep -B 1 rtt";
    private final String AWK_VALUES = "awk -F ' ' '{print $4}'";

    @Inject
    public UrlMonitoringSupplier(UrlMonitoringConfigsDecider urlMonitoringConfigsDecider, MetricsService metricsService) {
        this.urlMonitoringConfigsDecider = urlMonitoringConfigsDecider;
        this.metricsService = metricsService;
    }

    public void monitorAndReportUrlMetrics() {
        List<String> urlList = this.urlMonitoringConfigsDecider.getUrlMonitoringUrlsList();
        try {
            block19: for (String url : urlList) {
                if (url.contains(":")) {
                    String[] urlPort = url.split(":");
                    if (urlPort.length == 2) {
                        String host = urlPort[0];
                        String port = urlPort[1];
                        int attempts = 3;
                        log.info("URL Monitoring for url {} and port {}", (Object)host, (Object)port);
                        long rtt = this.measurePortRTT(host, Integer.parseInt(port), attempts);
                        this.reportMetric(rtt, "Hardware Resources|URL Monitoring|PORT MONITORING|Port RTT (ms)");
                        continue;
                    }
                    throw new Exception("Unable to monitor invalid URL {}" + url);
                }
                log.info("URL Monitoring for url: {}, using ping command", (Object)url);
                try {
                    InputStream inputStream = new ProcessBuilder(BashPathProvider.getBashPath(), "-c", "ping -c 3 " + url + " | grep -B 1 rtt").start().getInputStream();
                    try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                         BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                        String line;
                        int lineNumber = 1;
                        while ((line = bufferedReader.readLine()) != null) {
                            if (lineNumber == 1) {
                                String packetsReceived = line.split(",")[1].trim().split(" ")[0];
                                Long packetsReceivedPct = Double.valueOf(Double.valueOf(packetsReceived) / Double.valueOf("3") * 100.0).longValue();
                                this.reportMetric(packetsReceivedPct, "Hardware Resources|URL Monitoring|PING|PACKETS RECEIVED (%)");
                            } else {
                                if (lineNumber != 2) continue block19;
                                String[] tokens = line.split(" ")[3].split("/");
                                Long min = Double.valueOf(tokens[0]).longValue();
                                Long avg = Double.valueOf(tokens[1]).longValue();
                                Long max = Double.valueOf(tokens[2]).longValue();
                                Long mdev = Double.valueOf(tokens[3]).longValue();
                                this.reportMetric(min, "Hardware Resources|URL Monitoring|PING|MIN RTT (ms)");
                                this.reportMetric(avg, "Hardware Resources|URL Monitoring|PING|AVG RTT (ms)");
                                this.reportMetric(max, "Hardware Resources|URL Monitoring|PING|MAX RTT (ms)");
                                this.reportMetric(mdev, "Hardware Resources|URL Monitoring|PING|MDEV (ms)");
                            }
                            ++lineNumber;
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    log.debug("Error while reporting URL Monitoring metrics using ProcessBuilder, {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.info("Skip URL Monitoring.");
            log.trace("Error URL Monitoring: ", (Throwable)e);
        }
    }

    private long measurePortRTT(String host, int port, int attempts) throws Exception {
        long totalRTT = 0L;
        int successfulAttempts = 0;
        for (int i = 0; i < attempts; ++i) {
            try {
                long startTime = System.nanoTime();
                try (Socket socket = new Socket();){
                    socket.connect(new InetSocketAddress(host, port), 3000);
                }
                long endTime = System.nanoTime();
                long rtt = (endTime - startTime) / 1000000L;
                log.debug("RTT to port " + port + ": " + rtt + " ms");
                totalRTT += rtt;
                ++successfulAttempts;
                continue;
            }
            catch (IOException e) {
                log.debug("Connection to " + host + ":" + port + " failed: " + e.getMessage());
            }
        }
        if (successfulAttempts > 0) {
            return totalRTT / (long)successfulAttempts;
        }
        throw new Exception("URL Monitoring, host: " + host + ", port: " + port + " not reachable");
    }

    private void reportMetric(Long value, String metricName) {
        this.metricsService.reportMetric(metricName, ExtensionMetricAggregatorType.AVERAGE, value.longValue());
    }
}

