/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.UrlMonitoringSupplier;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlMonitoringScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UrlMonitoringScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Scheduler scheduler;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final UrlMonitoringConfigsDecider urlMonitoringConfigsDecider;
    private final UrlMonitoringSupplier urlMonitoringSupplier;
    private Optional<Long> currentPollingInterval = Optional.absent();
    private volatile ScheduledFuture<?> future;

    @Inject
    public UrlMonitoringScheduledRunner(Scheduler scheduler, UrlMonitoringConfigsDecider urlMonitoringConfigsDecider, UrlMonitoringSupplier urlMonitoringSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.urlMonitoringConfigsDecider = urlMonitoringConfigsDecider;
        this.urlMonitoringSupplier = urlMonitoringSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart():Started URL monitoring scheduled runner");
            if (this.urlMonitoringConfigsDecider.isTagEnabled()) {
                long scheduledInterval = this.getUrlMonitoringPollingInterval();
                if (this.future == null) {
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.info("Started URL monitoring scheduled runner");
                } else if (this.currentPollingInterval.isPresent() && scheduledInterval != (Long)this.currentPollingInterval.get()) {
                    this.future.cancel(true);
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.info("Restarted URL monitoring scheduled runner with new polling interval");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.urlMonitoringConfigsDecider.isTagEnabled() && this.future != null) {
                this.future.cancel(true);
                this.future = null;
                log.info("Stopped URL Monitoring scheduled runner");
            }
        }
    }

    @Override
    public void run() {
        if (this.urlMonitoringConfigsDecider.isTagEnabled()) {
            this.urlMonitoringSupplier.monitorAndReportUrlMetrics();
        } else {
            this.repetitiveLogger.debug(log, "URL Monitoring disabled. Skipping polling.", new Object[0]);
        }
    }

    private long getUrlMonitoringPollingInterval() {
        long urlMonitoringPollingInterval = this.urlMonitoringConfigsDecider.getUrlMonitoringPollingInterval();
        log.debug("Setting the URL Monitoring polling interval to {}", (Object)urlMonitoringPollingInterval);
        return urlMonitoringPollingInterval;
    }
}

