/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;

public class SmartAgentTagsConfigsDecider
implements TagsConfigsDecider {
    private static final long DEFAULT_SMART_AGENT_TAGS_POLLING_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    @Inject
    public SmartAgentTagsConfigsDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, ServersMonitorConfigResolver serversMonitorConfigResolver, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    public boolean isTagEnabled() {
        return this.globalTagsConfigsDecider.isTagEnabled() && this.serversMonitorConfigResolver.isSmartAgentTagsEnabled();
    }

    public long getSmartAgentPollingInterval() {
        Optional controllerServerMonitoringConfig = Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()));
        if (!controllerServerMonitoringConfig.isPresent()) {
            return this.getDefaultSmartAgentTagsPollingInterval();
        }
        return this.getDefaultSmartAgentTagsPollingInterval();
    }

    long getDefaultSmartAgentTagsPollingInterval() {
        return DEFAULT_SMART_AGENT_TAGS_POLLING_INTERVAL;
    }
}

