/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsCollector;
import com.appdynamics.sim.agent.extensions.servers.tags.ServiceNowTagsConfigDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsSupplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceNowTagsSupplier
implements TagsSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceNowTagsSupplier.class);
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private ServiceNowTagsCollector serviceNowTagsCollector = new ServiceNowTagsCollector();
    private String hostId;

    public SetMultimap<String, String> get() {
        return this.get(this.hostId);
    }

    public SetMultimap<String, String> get(String host) {
        log.debug(String.format("ServiceNow query for host '%s'", host));
        try {
            ImmutableSetMultimap.Builder metadataTagMapBuilder = ImmutableSetMultimap.builder();
            metadataTagMapBuilder.putAll(this.serviceNowTagsCollector.getAllCMDBTags(host));
            log.debug("Printing metadataTagMapBuilder", (Object)metadataTagMapBuilder.build());
            return metadataTagMapBuilder.build();
        }
        catch (Exception exception) {
            log.debug("Error accessing SNOW tags. Exception in querying CMDB", (Throwable)exception);
            return EMPTY_TAG_MAP;
        }
    }

    public void setConfig(ServiceNowTagsConfigDecider serviceNowTagsConfigDecider) {
        this.hostId = serviceNowTagsConfigDecider.getHostId();
        this.serviceNowTagsCollector.setConfig(serviceNowTagsConfigDecider);
    }

    public void setConfig(String hostId, String oauthurl, String clientId, String clientSecret, String clientScope, String cmdbUrl) {
        this.hostId = hostId;
        this.serviceNowTagsCollector.setConfig(oauthurl, clientId, clientSecret, clientScope, cmdbUrl);
    }
}

