/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthToken {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OAuthToken.class);
    private String oauthurl;
    private long expirationTimestamp = 0L;
    private String token = null;
    private Map<String, String> authMap = new LinkedHashMap<String, String>();

    public OAuthToken(String url, String client_id, String client_secret, String client_scope) {
        this.oauthurl = url;
        this.authMap.put("client_id", client_id);
        this.authMap.put("client_secret", client_secret);
        this.authMap.put("client_scope", client_scope);
    }

    public String getToken() throws IOException {
        if (this.token == null || this.isExpired()) {
            this.getNewAuthToken();
        }
        return this.token;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.expirationTimestamp;
    }

    private void getNewAuthToken() throws IOException {
        if (this.oauthurl == null) {
            log.debug("Configuration not applied, new auth token not available");
            return;
        }
        try {
            URL url = new URL(this.oauthurl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String postData = "client_id=" + URLEncoder.encode(this.authMap.get("client_id"), "UTF-8") + "&client_secret=" + URLEncoder.encode(this.authMap.get("client_secret"), "UTF-8") + "&grant_type=client_credentials&scope=" + URLEncoder.encode(this.authMap.get("client_scope"), "UTF-8");
            byte[] postDataBytes = postData.getBytes("UTF-8");
            conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
            conn.getOutputStream().write(postDataBytes);
            InputStream content = conn.getInputStream();
            JSONTokener tokener = new JSONTokener(content);
            JSONObject json = new JSONObject(tokener);
            this.checkForAuthError(json);
            this.token = json.getString("access_token");
            String expires_in_String = json.getString("expires_in");
            this.expirationTimestamp = System.currentTimeMillis() + Long.parseLong(expires_in_String) * 1000L;
            conn.disconnect();
        }
        catch (IOException e) {
            log.debug("IO Exception attempting to retrieve a token", (Throwable)e);
            throw e;
        }
    }

    private void checkForAuthError(JSONObject jsonObject) throws IOException {
        if (!jsonObject.has("errorMessage")) {
            return;
        }
        throw new IOException(String.format("Error getting an auth token: '%s' Message: '%s' Code: '%d'", jsonObject.getString("errorMessage"), jsonObject.getString("errorReason"), jsonObject.getInt("errorStatus")));
    }
}

