/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;

public class K8sTagsConfigsDecider
implements TagsConfigsDecider {
    private static final long DEFAULT_K8S_TAGS_POLLING_INTERVAL = TimeUnit.MINUTES.toMillis(60000L);
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    @Inject
    public K8sTagsConfigsDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, ServersMonitorConfigResolver serversMonitorConfigResolver, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    public boolean isTagEnabled() {
        return this.globalTagsConfigsDecider.isTagEnabled() && this.serversMonitorConfigResolver.isK8sTagsEnabled();
    }

    public long getK8sPollingInterval() {
        Optional controllerServerMonitoringConfig = Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()));
        if (!controllerServerMonitoringConfig.isPresent()) {
            return this.getDefaultK8sTagsPollingInterval();
        }
        Optional k8sPollingInterval = ((AgentMonitorConfig)controllerServerMonitoringConfig.get()).getK8sPollingInterval();
        return (Long)k8sPollingInterval.or((Object)this.getDefaultK8sTagsPollingInterval());
    }

    @VisibleForTesting
    long getDefaultK8sTagsPollingInterval() {
        return DEFAULT_K8S_TAGS_POLLING_INTERVAL;
    }
}

