/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.sim.agent.extensions.servers.tags.AzureTagsCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureTagsSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AzureTagsSupplier.class);
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private static final String AZURE_VM_LOCATION = "location";
    private static final String AZURE_VMID_TAG = "vmId";
    AzureTagsCollector azuremetadata = new AzureTagsCollector();

    public SetMultimap<String, String> get() {
        try {
            SetMultimap<String, String> azureMetadataTag = this.getAzureMetadataTag();
            ImmutableSetMultimap.Builder allAzureTagMapBuilder = ImmutableSetMultimap.builder();
            SetMultimap<String, String> azureCustomTag = this.getCustomAzureTag();
            allAzureTagMapBuilder.putAll(azureMetadataTag);
            allAzureTagMapBuilder.putAll(azureCustomTag);
            return allAzureTagMapBuilder.build();
        }
        catch (Exception e) {
            log.debug("Skip retrieving AZURE tags. Server is either not on AZURE or cannot connect to AZURE services");
            log.trace("Error retrieving tags from AZURE", (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }

    @VisibleForTesting
    SetMultimap<String, String> getAzureMetadataTag() {
        try {
            ImmutableSetMultimap.Builder metadataTagMapBuilder = ImmutableSetMultimap.builder();
            metadataTagMapBuilder.put((Object)AZURE_VM_LOCATION, (Object)this.azuremetadata.getlocation());
            metadataTagMapBuilder.put((Object)AZURE_VMID_TAG, (Object)this.azuremetadata.getvmid());
            log.debug("Printing metadataTagMapBuilder", (Object)metadataTagMapBuilder.build());
            return metadataTagMapBuilder.build();
        }
        catch (Exception e) {
            log.debug("Error accessing Azure client. Skipping retrieving Azure metadata tags", (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }

    @VisibleForTesting
    SetMultimap<String, String> getCustomAzureTag() {
        try {
            String[] Tag_array;
            log.debug("Printing from customeazure tag ");
            ImmutableSetMultimap.Builder customTagMapBuilder = ImmutableSetMultimap.builder();
            String Tags_list = this.azuremetadata.getcustomtags();
            for (String tag : Tag_array = Tags_list.split(";")) {
                String[] tagsData = tag.split(":");
                String key = tagsData[0].trim();
                String value = tagsData[1].trim();
                customTagMapBuilder.put((Object)key, (Object)value);
            }
            return customTagMapBuilder.build();
        }
        catch (Exception e) {
            log.debug("Error accessing Azure client. Skipping retrieving Azure custom tags", (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }
}

