/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.amazonaws.AmazonClientException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.util.EC2MetadataUtils;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsTagsSupplier
implements TagsSupplier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsTagsSupplier.class);
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private static final String RESOURCE_ID_KEY_FOR_TAG_REQUEST = "resource-id";
    private static final String AVAILABILITY_ZONE_TAG_KEY = "availability-zone";
    private static final String REGION_TAG_KEY = "region";
    private static final String AMI_ID_TAG_KEY = "ami-id";
    private static final String INSTANCE_TYPE_TAG_KEY = "instance-type";
    private static final String SECURITY_GROUP_TAG_KEY = "security-group";
    private Optional<AmazonEC2> ec2ClientOptional = Optional.absent();

    public SetMultimap<String, String> get() {
        try {
            EC2MetadataUtils.InstanceInfo currentInstance = this.getEC2Instance();
            SetMultimap<String, String> userDefinedAwsTagMap = this.getUserDefinedAwsTag(currentInstance);
            SetMultimap<String, String> awsMetadataTag = this.getAwsMetadataTag(currentInstance);
            ImmutableSetMultimap.Builder allAwsTagMapBuilder = ImmutableSetMultimap.builder();
            allAwsTagMapBuilder.putAll(userDefinedAwsTagMap);
            allAwsTagMapBuilder.putAll(awsMetadataTag);
            return allAwsTagMapBuilder.build();
        }
        catch (Exception e) {
            log.info("Skip retrieving AWS tags. Server is either not on AWS or cannot connect to AWS services");
            log.trace("Error retrieving tags from AWS", (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }

    @VisibleForTesting
    EC2MetadataUtils.InstanceInfo getEC2Instance() {
        return EC2MetadataUtils.getInstanceInfo();
    }

    @VisibleForTesting
    SetMultimap<String, String> getAwsMetadataTag(EC2MetadataUtils.InstanceInfo currentInstance) {
        try {
            ImmutableSetMultimap.Builder metadataTagMapBuilder = ImmutableSetMultimap.builder();
            metadataTagMapBuilder.put((Object)AVAILABILITY_ZONE_TAG_KEY, (Object)currentInstance.getAvailabilityZone());
            metadataTagMapBuilder.put((Object)REGION_TAG_KEY, (Object)currentInstance.getRegion());
            metadataTagMapBuilder.put((Object)AMI_ID_TAG_KEY, (Object)currentInstance.getImageId());
            metadataTagMapBuilder.put((Object)INSTANCE_TYPE_TAG_KEY, (Object)currentInstance.getInstanceType());
            for (String securityGroup : EC2MetadataUtils.getSecurityGroups()) {
                metadataTagMapBuilder.put((Object)SECURITY_GROUP_TAG_KEY, (Object)securityGroup);
            }
            return metadataTagMapBuilder.build();
        }
        catch (AmazonClientException e) {
            log.debug("Error accessing Amazon Client. Skipping retrieving AWS metadata tags", (Throwable)e);
            return EMPTY_TAG_MAP;
        }
    }

    @VisibleForTesting
    SetMultimap<String, String> getUserDefinedAwsTag(EC2MetadataUtils.InstanceInfo currentInstance) {
        DescribeTagsResult tagResult;
        try {
            if (!this.ec2ClientOptional.isPresent()) {
                this.ec2ClientOptional = this.getAmazonEC2ClientCheckingIAMAndSetRegionEndPoint(currentInstance);
                if (!this.ec2ClientOptional.isPresent()) {
                    return EMPTY_TAG_MAP;
                }
            }
            DescribeTagsRequest tagsRequest = new DescribeTagsRequest();
            ImmutableList instanceIdList = ImmutableList.of((Object)currentInstance.getInstanceId());
            ImmutableSet filters = ImmutableSet.of((Object)new Filter(RESOURCE_ID_KEY_FOR_TAG_REQUEST, (List)instanceIdList));
            tagsRequest.setFilters((Collection)filters);
            tagResult = ((AmazonEC2)this.ec2ClientOptional.get()).describeTags(tagsRequest);
        }
        catch (AmazonClientException e) {
            log.debug("Error accessing Amazon Client. Skipping retrieving AWS User tags", (Throwable)e);
            this.ec2ClientOptional = Optional.absent();
            return EMPTY_TAG_MAP;
        }
        ImmutableSetMultimap.Builder userDefinedAwsTagMapBuilder = ImmutableSetMultimap.builder();
        if (tagResult != null) {
            for (TagDescription tag : tagResult.getTags()) {
                userDefinedAwsTagMapBuilder.put((Object)tag.getKey(), (Object)tag.getValue());
            }
        }
        return userDefinedAwsTagMapBuilder.build();
    }

    @VisibleForTesting
    Optional<AmazonEC2> getAmazonEC2ClientCheckingIAMAndSetRegionEndPoint(EC2MetadataUtils.InstanceInfo currentInstance) {
        AmazonEC2 ec2Client;
        Map credentialMap = EC2MetadataUtils.getIAMSecurityCredentials();
        if (credentialMap.isEmpty()) {
            log.debug("No IAM role set on this instance. Skipping collecting tag from AWS EC2");
            return Optional.absent();
        }
        if (credentialMap.size() > 1) {
            log.debug("IAM roles on this instance is not equal to 1. IAM role use to read tag is nondeterministic.");
            return Optional.absent();
        }
        boolean useProxy = false;
        int proxyPort = -1;
        String proxyHost = System.getProperty("appdynamics.http.proxyHost");
        String proxyPortStr = System.getProperty("appdynamics.http.proxyPort");
        String disableAwsProxy = System.getProperty("appdynamics.disableAwsProxy");
        if (proxyHost != null && proxyPortStr != null && !proxyHost.isEmpty() && !proxyPortStr.isEmpty()) {
            try {
                proxyPort = Integer.parseInt(proxyPortStr);
                log.info("Configuring Proxy host: " + proxyHost + ", Port: " + proxyPort);
                useProxy = true;
            }
            catch (NumberFormatException e) {
                useProxy = false;
            }
        } else {
            log.info("No proxy info found. Continuing.");
        }
        if (disableAwsProxy != null) {
            useProxy = false;
            log.info("Proxy for AWS is disabled.");
        }
        if (useProxy) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setProxyHost(proxyHost);
            clientConfiguration.setProxyPort(proxyPort);
            ec2Client = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)InstanceProfileCredentialsProvider.getInstance())).withRegion(currentInstance.getRegion())).withClientConfiguration(clientConfiguration)).build();
        } else {
            ec2Client = (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials((AWSCredentialsProvider)InstanceProfileCredentialsProvider.getInstance())).withRegion(currentInstance.getRegion())).build();
        }
        return Optional.of((Object)ec2Client);
    }
}

