/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.agent.sim.tags.MachineTagMapName;
import com.appdynamics.agent.sim.tags.MachineTags;
import com.appdynamics.sim.agent.extensions.api.scheduling.Scheduler;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.tags.AwsTagsSupplier;
import com.appdynamics.sim.agent.extensions.servers.tags.TagsScheduledRunner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsTagsScheduledRunner
implements TagsScheduledRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AwsTagsScheduledRunner.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final SetMultimap<String, String> EMPTY_TAG_MAP = HashMultimap.create();
    private final Scheduler scheduler;
    private final MachineTags machineTags;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final AwsTagsConfigsDecider awsTagsConfigsDecider;
    private final AwsTagsSupplier awsTagsSupplier;
    private Optional<Long> currentPollingInterval = Optional.absent();
    private volatile ScheduledFuture<?> future;

    @Inject
    public AwsTagsScheduledRunner(Scheduler scheduler, MachineTags machineTags, AwsTagsConfigsDecider awsTagsConfigsDecider, AwsTagsSupplier awsTagsSupplier, SimAgentRepetitiveLogger repetitiveLogger) {
        this.scheduler = scheduler;
        this.machineTags = machineTags;
        this.awsTagsConfigsDecider = awsTagsConfigsDecider;
        this.awsTagsSupplier = awsTagsSupplier;
        this.repetitiveLogger = repetitiveLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryStart() {
        Object object = this.$lock;
        synchronized (object) {
            log.debug("Inside tryStart():Started AWS tags scheduled runner to poll for tags");
            if (this.awsTagsConfigsDecider.isTagEnabled()) {
                long scheduledInterval = this.getAwsPollingInterval();
                if (this.future == null) {
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.info("Started AWS tags scheduled runner to poll for tags");
                } else if (this.currentPollingInterval.isPresent() && scheduledInterval != (Long)this.currentPollingInterval.get()) {
                    this.future.cancel(true);
                    this.future = this.scheduler.scheduleAtFixedRate((Runnable)this, 0L, scheduledInterval, TimeUnit.MILLISECONDS);
                    this.currentPollingInterval = Optional.of((Object)scheduledInterval);
                    log.info("Restarted AWS tags scheduled runner with new polling interval");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @PreDestroy
    public void tryStop() {
        Object object = this.$lock;
        synchronized (object) {
            if (!this.awsTagsConfigsDecider.isTagEnabled()) {
                if (this.future != null) {
                    this.future.cancel(true);
                    this.future = null;
                    log.info("Stopped AWS tags scheduled runner");
                }
                this.machineTags.updateTagMap(MachineTagMapName.AWS_INTEGRATION_TAG_MAP, EMPTY_TAG_MAP);
            }
        }
    }

    @Override
    public void run() {
        if (this.awsTagsConfigsDecider.isTagEnabled()) {
            SetMultimap<String, String> awsTagsMap = this.awsTagsSupplier.get();
            this.machineTags.updateTagMap(MachineTagMapName.AWS_INTEGRATION_TAG_MAP, awsTagsMap);
        } else {
            this.repetitiveLogger.debug(log, "Polling for AWS tags disabled. Skipping polling.", new Object[0]);
        }
    }

    private long getAwsPollingInterval() {
        long awsPollingInterval = this.awsTagsConfigsDecider.getAwsPollingInterval();
        log.debug("Setting the aws tags polling interval to {}", (Object)awsPollingInterval);
        return awsPollingInterval;
    }
}

