/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.tags;

import com.appdynamics.agent.sim.tags.GlobalTagsConfigsDecider;
import com.appdynamics.agent.sim.tags.TagsConfigsDecider;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfigResolver;
import com.appdynamics.sim.common.biz.shared.machines.AgentMonitorConfig;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.concurrent.TimeUnit;

public class AwsTagsConfigsDecider
implements TagsConfigsDecider {
    private static final long DEFAULT_AWS_TAGS_POLLING_INTERVAL = TimeUnit.HOURS.toMillis(6L);
    private final Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider;
    private final ServersMonitorConfigResolver serversMonitorConfigResolver;
    private final GlobalTagsConfigsDecider globalTagsConfigsDecider;

    @Inject
    public AwsTagsConfigsDecider(GlobalTagsConfigsDecider globalTagsConfigsDecider, ServersMonitorConfigResolver serversMonitorConfigResolver, Provider<AgentMonitorConfig> controllerServerMonitoringConfigProvider) {
        this.globalTagsConfigsDecider = globalTagsConfigsDecider;
        this.serversMonitorConfigResolver = serversMonitorConfigResolver;
        this.controllerServerMonitoringConfigProvider = controllerServerMonitoringConfigProvider;
    }

    public boolean isTagEnabled() {
        return this.globalTagsConfigsDecider.isTagEnabled() && this.serversMonitorConfigResolver.isAwsTagsEnabled();
    }

    public long getAwsPollingInterval() {
        Optional controllerServerMonitoringConfig = Optional.fromNullable((Object)((AgentMonitorConfig)this.controllerServerMonitoringConfigProvider.get()));
        if (!controllerServerMonitoringConfig.isPresent()) {
            return this.getAwsTagsPollingInterval();
        }
        Optional awsPollingInterval = ((AgentMonitorConfig)controllerServerMonitoringConfig.get()).getAwsPollingInterval();
        return (Long)awsPollingInterval.or((Object)this.getAwsTagsPollingInterval());
    }

    @VisibleForTesting
    long getDefaultAwsTagsPollingInterval() {
        return DEFAULT_AWS_TAGS_POLLING_INTERVAL;
    }

    @VisibleForTesting
    long getAwsTagsPollingInterval() {
        if (this.serversMonitorConfigResolver == null || this.serversMonitorConfigResolver.getAwsTagsConfig() == null) {
            return this.getDefaultAwsTagsPollingInterval();
        }
        return (Long)this.serversMonitorConfigResolver.getAwsTagsConfig().getSamplingInterval().get();
    }
}

