/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.servers.collector.RawSimCollectorScriptPath;
import com.appdynamics.sim.agent.extensions.servers.collector.SimCollectorProcessCommand;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawCollector;
import com.google.common.base.Supplier;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.concurrent.TimeUnit;
import oshi.software.os.OSProcess;

public class WindowsRawCollectorModule
extends AbstractModule {
    private static final String SIM_COLLECTOR_SCRIPT_PATH = "/sim-collector.vbs.enc";
    private static final Class<WindowsRawCollector> WINDOWS_RAW_COLLECTOR_CLASS = WindowsRawCollector.class;
    private static final String PROCESS_COMMAND = "cscript";
    private static final String NO_LOGO_PROPERTY = "//NoLogo";
    private static final String TIMEOUT_PROPERTY = "//T:";
    private static final long EXPIRY_TIME_IN_MINUTES = 3L;

    protected void configure() {
        this.bindConstant().annotatedWith(RawSimCollectorScriptPath.class).to(SIM_COLLECTOR_SCRIPT_PATH);
        this.bindConstant().annotatedWith(SimCollectorProcessCommand.class).to(PROCESS_COMMAND);
        this.bind(new TypeLiteral<Class<? extends RawCollector<?>>>(){}).toInstance(WINDOWS_RAW_COLLECTOR_CLASS);
    }

    @Provides
    @SimCollectorProcessCommand
    Supplier<List<String>> provideProcessCommandOptions(final Provider<ServersMonitorConfig> monitorConfig) {
        return new Supplier<List<String>>(){

            public List<String> get() {
                String timeout = WindowsRawCollectorModule.TIMEOUT_PROPERTY + ((ServersMonitorConfig)monitorConfig.get()).getScriptTimeoutSeconds();
                ImmutableList commandList = ImmutableList.of((Object)WindowsRawCollectorModule.NO_LOGO_PROPERTY, (Object)timeout);
                return commandList;
            }
        };
    }

    @Provides
    @Singleton
    Cache<String, OSProcess> getWindowsOsProcessCache() {
        return CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).build();
    }
}

