/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.collector.RawCollectorUtil;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.VirtualMemory;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;
import oshi.util.GlobalConfig;

class WindowsRawCollector
implements RawCollector<WindowsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsRawCollector.class);
    private static final WindowsRawData EMPTY_RAW_DATA = new WindowsRawData();
    private static final long MS_TO_100NS = 10000L;
    private final ObjectMapper objectMapper;
    private final ProcessClassIdCreator processClassIdCreator;
    private final Provider<Optional<RawCollectorUtil.ICollectorProcessBuilder>> processBuilder;
    private final SimAgentRepetitiveLogger repetitiveLogger;
    private final RawCollectorUtil rawCollectorUtil;
    private final Cache<String, OSProcess> oshiOsProcessCache;

    @Inject
    WindowsRawCollector(@Sim ObjectMapper objectMapper, ProcessClassIdCreator processClassIdCreator, Provider<Optional<RawCollectorUtil.ICollectorProcessBuilder>> collectorProcessBuilder, SimAgentRepetitiveLogger repetitiveLogger, RawCollectorUtil rawCollectorUtil, Cache<String, OSProcess> oshiOsProcessCache) {
        this.objectMapper = objectMapper;
        this.processClassIdCreator = processClassIdCreator;
        this.processBuilder = collectorProcessBuilder;
        this.repetitiveLogger = repetitiveLogger;
        this.rawCollectorUtil = rawCollectorUtil;
        this.oshiOsProcessCache = oshiOsProcessCache;
        GlobalConfig.set((String)"oshi.os.windows.commandline.batch", (Object)true);
    }

    @Override
    public WindowsRawData collectRawData(Set<String> componentsToCollect, long maxCollectionTimeMillis) {
        Optional<WindowsRawData> rawDataOpt = Optional.absent();
        if (!((Optional)this.processBuilder.get()).isPresent()) {
            this.repetitiveLogger.error(log, "Process to collect raw data is not present - skipping collection", new Object[0]);
        } else {
            RawCollectorUtil.ICollectorProcessBuilder collectorProcessBuilder = (RawCollectorUtil.ICollectorProcessBuilder)((Optional)this.processBuilder.get()).get();
            rawDataOpt = this.rawCollectorUtil.runCollector(WindowsRawData.class, collectorProcessBuilder, this.objectMapper, maxCollectionTimeMillis);
        }
        WindowsRawData rawData = EMPTY_RAW_DATA;
        if (rawDataOpt.isPresent()) {
            rawData = (WindowsRawData)rawDataOpt.get();
        }
        this.fillOshiData(rawData);
        this.preProcess(rawData);
        if (rawData.getMissingProperties().size() > 0) {
            log.debug("The server is missing these WMI properties: {}", rawData.getMissingProperties());
        }
        if (rawData.getMissingWmiClasses().size() > 0) {
            log.debug("The server is missing these WMI classes. The WMI repository could be corrupted: {}", rawData.getMissingWmiClasses());
        }
        if (rawData.getEmptyProperties().size() > 0) {
            log.debug("The values for these WMI properties were empty. A few empty properties are typical and are not cause for concern: {}", rawData.getEmptyProperties());
        }
        return rawData;
    }

    @VisibleForTesting
    void fillOshiData(WindowsRawData rawData) {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        GlobalMemory memory = hal.getMemory();
        VirtualMemory swap = memory.getVirtualMemory();
        rawData.setMemory(new WindowsRawData.Memory.MemoryBuilder().visibleTotal(memory.getTotal()).physicalFree(memory.getAvailable()).swapTotal(swap.getSwapTotal()).swapFree(swap.getSwapTotal() - swap.getSwapUsed()).build());
        log.debug("OSHI library output (memory): " + String.valueOf(rawData.getMemory()));
        OperatingSystem os = si.getOperatingSystem();
        HashMap procMap = Maps.newHashMap();
        HashMap procPerfMap = Maps.newHashMap();
        log.debug("Starting OSHI process collection");
        long startTime = System.currentTimeMillis();
        long oshiCollectionTimeout = 0L;
        try {
            oshiCollectionTimeout = Long.getLong("appdynamics.machine.agent.oshiCollectionTimeout.in.ms", 10000L);
        }
        catch (Exception e) {
            log.error("Could not read OSHI Timing Properties. Reason: " + String.valueOf(e) + ". Will use default values.");
        }
        log.debug("Default Collection Timeout is 10000 ms");
        log.debug("OSHI Collection Timeout: " + oshiCollectionTimeout);
        List osProcessList = os.getProcesses(null, null, 0);
        log.debug("OSHI collected: " + osProcessList.size() + " processes.");
        int procesedDataCount = 0;
        int processID = 0;
        StringBuilder processKey = new StringBuilder();
        for (OSProcess osProcess : osProcessList) {
            if (System.currentTimeMillis() - startTime >= oshiCollectionTimeout) {
                log.debug("OSHI process collection Time exceeded the timeout of " + oshiCollectionTimeout + "ms. Skipping further OSHI Data Processing.");
                break;
            }
            processID = osProcess.getProcessID();
            processKey.append(processID);
            processKey.append(osProcess.getName());
            String processKeyStr = processKey.toString();
            processKey.setLength(0);
            log.debug("Process key: " + processKeyStr);
            procMap.put(String.valueOf(processID), WindowsRawData.WinProcess.builder().pid(processID).commandLine(osProcess.getCommandLine()).name(osProcess.getName()).ppid(osProcess.getParentProcessID()).owner(osProcess.getUser()).build());
            procPerfMap.put(String.valueOf(processID), WindowsRawData.PerfWinProcess.builder().pid(processID).elapsedTime(osProcess.getUpTime()).workingSet(osProcess.getResidentSetSize()).threadCount(osProcess.getThreadCount()).virtualBytes(osProcess.getVirtualSize()).cpuPercent(osProcess.getProcessCpuLoadBetweenTicks((OSProcess)this.oshiOsProcessCache.getIfPresent((Object)processKeyStr))).build());
            this.oshiOsProcessCache.put((Object)processKeyStr, (Object)osProcess);
            ++procesedDataCount;
        }
        log.debug("OSHI process collection Ended. Processed " + procesedDataCount + " processes. Took " + (System.currentTimeMillis() - startTime) + "ms.");
        boolean shouldDropCompleteOshiDataWhenTimeOut = Boolean.getBoolean("appdynamics.machine.agent.should.drop.complete.process.data.when.timeout");
        if (shouldDropCompleteOshiDataWhenTimeOut && procesedDataCount != osProcessList.size()) {
            log.debug("Dropping oshi process data due to timeout, because appdynamics.machine.agent.is.drop.complete.oshi.data.when.timeout is set to true");
        } else {
            rawData.setProcesses(procMap);
            rawData.setPerfProcesses(procPerfMap);
        }
        if (log.isDebugEnabled()) {
            log.debug("OSHI output (processes): " + String.valueOf(rawData.getProcesses()));
            log.debug("OSHI output (perfProcesses): " + String.valueOf(rawData.getPerfProcesses()));
            String cacheStr = this.oshiOsProcessCache.size() > 0L ? this.oshiOsProcessCache.asMap().keySet().toString() : "empty";
            log.debug("OSHI OSProcess cache: " + cacheStr);
        }
        CentralProcessor cpuInfo = hal.getProcessor();
        int coreCount = cpuInfo.getPhysicalProcessorCount();
        int processorCount = cpuInfo.getLogicalProcessorCount();
        CentralProcessor.ProcessorIdentifier cpuId = cpuInfo.getProcessorIdentifier();
        ImmutableMap cpusMap = ImmutableMap.of((Object)"CPU", (Object)WindowsRawData.Cpu.builder().cpuVendor(cpuId.getVendor()).cpuName(cpuId.getName()).numCores(coreCount).numLogicalProcessors(processorCount).cpuMaxSpeedMhz(cpuId.getVendorFreq() / 1000000L).build());
        long[] loadTicks = cpuInfo.getSystemCpuLoadTicks();
        log.debug("OSHI library output (SystemCpuLoadTicks): " + Arrays.toString(loadTicks));
        long idleTicks = loadTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long stealTicks = loadTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long systemTicks = loadTicks[CentralProcessor.TickType.SYSTEM.getIndex()] + loadTicks[CentralProcessor.TickType.IRQ.getIndex()] + loadTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long userTicks = loadTicks[CentralProcessor.TickType.USER.getIndex()];
        long timeStamp = idleTicks + stealTicks + systemTicks + userTicks;
        ImmutableMap cpusPerfMap = ImmutableMap.of((Object)"_Total", (Object)WindowsRawData.CpuPerf.builder().timestamp(timeStamp).idleTicks(idleTicks).stealTicks(stealTicks).systemTicks(systemTicks).userTicks(userTicks).build());
        rawData.setCpus((Map<String, WindowsRawData.Cpu>)cpusMap);
        rawData.setCpusPerf((Map<String, WindowsRawData.CpuPerf>)cpusPerfMap);
        log.debug("OSHI library output (cpus): " + String.valueOf(rawData.getCpus()));
        log.debug("OSHI library output (cpusPerf): " + String.valueOf(rawData.getCpusPerf()));
    }

    private void preProcess(WindowsRawData rawData) {
        try {
            this.preProcessProcesses(rawData);
            this.preProcessMemory(rawData);
            this.setTotalNumLogicalProcessors(rawData);
            this.preProcessNetworks(rawData);
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception during pre-processing: " + String.valueOf(e), new Object[0]);
        }
    }

    @VisibleForTesting
    void preProcessProcesses(WindowsRawData rawData) {
        for (WindowsRawData.PerfWinProcess perfWinProcess : rawData.getPerfProcesses().values()) {
            long pid = perfWinProcess.getPid();
            try {
                WindowsRawData.WinProcess winProcess;
                if (pid == 0L || (winProcess = rawData.getProcesses().get(String.valueOf(pid))) == null) continue;
                ProcessClassIdCreator.ProcessClass processClass = this.processClassIdCreator.extractClass(winProcess.getCommandLine(), winProcess.getName());
                String commandLine = winProcess.getCommandLine();
                winProcess.setCommandLine(this.replaceUnknownValueWithGivenString(commandLine, ""));
                rawData.getProcData().put((Object)processClass.getProcessClassId(), (Object)new WindowsRawData.WinProcessRawData(processClass, perfWinProcess, winProcess));
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception while pre-processing process with pid {}.This process will be removed from the collected data. " + String.valueOf(e), new Object[]{pid});
            }
        }
    }

    @VisibleForTesting
    void setTotalNumLogicalProcessors(WindowsRawData rawData) {
        long logicalProcessors = UnknownValueUtil.getUnknownValue();
        try {
            for (WindowsRawData.Cpu cpu : rawData.getCpus().values()) {
                logicalProcessors = CalculationUtils.aggregateComponentValue(logicalProcessors, cpu.getNumLogicalProcessors());
            }
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception when trying to set the total number of logical processors. Setting the total number of logical processors to the unknown value. " + String.valueOf(e), new Object[0]);
        }
        rawData.setTotalNumLogicalProcessors((int)logicalProcessors);
    }

    @VisibleForTesting
    void preProcessNetworks(WindowsRawData rawData) {
        HashMap<String, WindowsRawData.NetworkAdapter> updatedMap = new HashMap<String, WindowsRawData.NetworkAdapter>();
        for (String networkName : rawData.getNetworkAdapters().keySet()) {
            try {
                String newNetworkName = this.standardizeNetworkName(networkName);
                WindowsRawData.NetworkAdapter updatedAdapter = rawData.getNetworkAdapters().get(networkName);
                updatedAdapter.setName(newNetworkName);
                updatedMap.put(newNetworkName, updatedAdapter);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Couldn't standardize this network name {}. This network will be removed from the collected data. " + String.valueOf(e), new Object[]{networkName});
            }
        }
        rawData.setNetworkAdapters(updatedMap);
        Map<String, WindowsRawData.NetworkAdapter> networkAdapters = rawData.getNetworkAdapters();
        Map<String, WindowsRawData.NetworkAdapterConfig> networkAdapterConfigs = rawData.getNetworkAdapterConfigs();
        Map<String, WindowsRawData.TcpipInterface> tcpipInterfaces = rawData.getTcpipInterfaces();
        for (WindowsRawData.NetworkAdapter networkAdapter : networkAdapters.values()) {
            try {
                WindowsRawData.NetworkAdapterConfig networkAdapterConfig = networkAdapterConfigs.get(networkAdapter.getIndex());
                WindowsRawData.TcpipInterface tcpipInterface = tcpipInterfaces.get(networkAdapter.getName());
                if (networkAdapterConfig == null || tcpipInterface == null) continue;
                WindowsRawData.NetworkInterfaceInfo networkInterface = new WindowsRawData.NetworkInterfaceInfo(networkAdapter.getName(), networkAdapter.getAvailability(), networkAdapter.getNetConnectionStatus(), networkAdapter.getSpeed(), networkAdapter.getNetEnabled(), networkAdapter.getFullDuplex(), networkAdapter.getMacAddress(), networkAdapterConfig.getIpAddress(), networkAdapterConfig.getIpSubnet(), networkAdapterConfig.getDefaultIpGateway(), networkAdapterConfig.getMtu(), tcpipInterface.getBytesIncomingPerSec(), tcpipInterface.getBytesOutgoingPerSec(), tcpipInterface.getPacketsIncomingPerSec(), tcpipInterface.getPacketsOutgoingPerSec(), tcpipInterface.getPacketsIncomingErrors(), tcpipInterface.getPacketsOutgoingErrors(), tcpipInterface.getBytesTotalPerSec(), tcpipInterface.getPerfTicksPerSec(), tcpipInterface.getTimestamp(), tcpipInterface.getTimestampTicksPerSec());
                rawData.getNetworkInterfaceInfo().put(networkInterface.getName(), networkInterface);
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Couldn't aggregate information for network {}. This network will be removedfrom the collected data. " + String.valueOf(e), new Object[]{networkAdapter.getName()});
            }
        }
    }

    @VisibleForTesting
    void preProcessMemory(WindowsRawData rawData) {
        if (rawData.getMemory() != null) {
            rawData.setPhysicalMemoryCapacityBytes(rawData.getMemory().getVisibleTotal());
        }
    }

    @VisibleForTesting
    String standardizeNetworkName(String name) {
        return name.replace('(', '[').replace(')', ']').replace('#', '_').replace('\\', '_').replace('/', '_');
    }

    @VisibleForTesting
    String replaceUnknownValueWithGivenString(String value, String replaceWith) {
        if (UnknownValueUtil.isUnknownValue(value)) {
            return replaceWith;
        }
        return value;
    }
}

