/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.windows.Perf100nsTimer;
import com.appdynamics.sim.agent.extensions.servers.model.windows.PerfAverageTimer;
import com.appdynamics.sim.agent.extensions.servers.model.windows.Uint64WraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.IntWraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterBulkCount;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import lombok.Generated;

class WindowsPartition
extends Partition<WindowsRawData> {
    private final PerfCounterBulkCount readCountPerSecCounter;
    private final PerfCounterBulkCount readBytesPerSecCounter;
    private final PerfCounterBulkCount writeCountPerSecCounter;
    private final PerfCounterBulkCount writeBytesPerSecCounter;
    private final PerfAverageTimer avgReadTimeCounter;
    private final PerfAverageTimer avgWriteTimeCounter;
    private final Perf100nsTimer utilization;
    private final IntWraparoundCalculator intWraparoundCalculator;
    private final Uint64WraparoundCalculator uint64WraparoundCalculator;
    private final RawDataFactory factory;
    private WindowsRawData.PerfLogicalDisk perfLogicalDisk;
    private String volumeId;
    private static final String UNABLE_TO_CALCULATE_USED_SPACE = "unable to calculate used space";

    @Inject
    private WindowsPartition(@Assisted String partitionName, @Sim MetricsService metricsService, IntWraparoundCalculator intWraparoundCalculator, Uint64WraparoundCalculator uint64WraparoundCalculator, RawDataFactory factory) {
        super(partitionName, metricsService, factory);
        this.intWraparoundCalculator = intWraparoundCalculator;
        this.uint64WraparoundCalculator = uint64WraparoundCalculator;
        this.factory = factory;
        this.readCountPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.readBytesPerSecCounter = new PerfCounterBulkCount(uint64WraparoundCalculator);
        this.avgReadTimeCounter = new PerfAverageTimer(intWraparoundCalculator, intWraparoundCalculator);
        this.writeCountPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.writeBytesPerSecCounter = new PerfCounterBulkCount(uint64WraparoundCalculator);
        this.avgWriteTimeCounter = new PerfAverageTimer(intWraparoundCalculator, intWraparoundCalculator);
        this.utilization = new Perf100nsTimer(uint64WraparoundCalculator, uint64WraparoundCalculator);
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.perfLogicalDisk = rawData.getPerfLogicalDisks().get(this.getPartitionName());
        this.readCountPerSecCounter.calculate(BigInteger.valueOf(this.perfLogicalDisk.getDiskReadsPerSec()), this.perfLogicalDisk.getTimestamp(), this.perfLogicalDisk.getTimestampTicksPerSec());
        this.readBytesPerSecCounter.calculate(this.perfLogicalDisk.getDiskReadBytesPerSec(), this.perfLogicalDisk.getTimestamp(), this.perfLogicalDisk.getTimestampTicksPerSec());
        this.writeCountPerSecCounter.calculate(BigInteger.valueOf(this.perfLogicalDisk.getDiskWritesPerSec()), this.perfLogicalDisk.getTimestamp(), this.perfLogicalDisk.getTimestampTicksPerSec());
        this.writeBytesPerSecCounter.calculate(this.perfLogicalDisk.getDiskWriteBytesPerSec(), this.perfLogicalDisk.getTimestamp(), this.perfLogicalDisk.getTimestampTicksPerSec());
        this.avgReadTimeCounter.calculate(BigInteger.valueOf(this.perfLogicalDisk.getDiskSecPerRead()), BigInteger.valueOf(this.perfLogicalDisk.getDiskSecPerReadBase()), this.perfLogicalDisk.getPerfTicksPerSec());
        this.avgWriteTimeCounter.calculate(BigInteger.valueOf(this.perfLogicalDisk.getDiskSecPerWrite()), BigInteger.valueOf(this.perfLogicalDisk.getDiskSecPerWriteBase()), this.perfLogicalDisk.getPerfTicksPerSec());
        this.utilization.calculate(this.perfLogicalDisk.getDiskUtilizationPct(), this.perfLogicalDisk.getDiskUtilizationPctBase());
        for (Map.Entry<String, WindowsRawData.LogicalDisk> entry : rawData.getLogicalDisks().entrySet()) {
            WindowsRawData.LogicalDisk v = entry.getValue();
            if (!v.getName().equalsIgnoreCase(this.getPartitionName())) continue;
            this.volumeId = entry.getKey();
            break;
        }
    }

    @Override
    public RawDataLong getReadCountPerSec() {
        return this.factory.createLong(Long.valueOf(this.readCountPerSecCounter.getLastCookedResult()));
    }

    @Override
    public RawDataLong getReadKbPerSec() {
        return this.factory.createLong(Long.valueOf(CalculationUtils.bytesToKilobytes(this.readBytesPerSecCounter.getLastCookedResult())));
    }

    @Override
    public RawDataLong getAvgReadTimeMillis() {
        return this.factory.createLong(Long.valueOf(this.avgReadTimeCounter.getLastCookedResult()));
    }

    @Override
    public RawDataLong getWriteCountPerSec() {
        return this.factory.createLong(Long.valueOf(this.writeCountPerSecCounter.getLastCookedResult()));
    }

    @Override
    public RawDataLong getWriteKbPerSec() {
        return this.factory.createLong(Long.valueOf(CalculationUtils.bytesToKilobytes(this.writeBytesPerSecCounter.getLastCookedResult())));
    }

    @Override
    public RawDataLong getAvgWriteTimeMillis() {
        return this.factory.createLong(Long.valueOf(this.avgWriteTimeCounter.getLastCookedResult()));
    }

    @Override
    public RawDataLong getUtilization() {
        long utilizationVal = this.utilization.getLastCookedResult();
        if (utilizationVal > 100L) {
            utilizationVal = 100L;
        }
        return this.factory.createLong(Long.valueOf(utilizationVal));
    }

    @Override
    public RawDataLong getSpaceAvailableKb() {
        return this.factory.createLong(Long.valueOf(CalculationUtils.megabytesToKilobytes(this.perfLogicalDisk.getFreeSpaceMb())));
    }

    @Override
    public RawDataLong getSpaceUsedKb() {
        int percentFreeSpace = this.perfLogicalDisk.getPercentFreeSpace();
        int percentFreeSpaceBase = this.perfLogicalDisk.getPercentFreeSpaceBase();
        double freePercentage = (double)percentFreeSpace / (double)percentFreeSpaceBase;
        BigDecimal multiplierFactor = BigDecimal.valueOf((1.0 - freePercentage) / freePercentage);
        if (this.getSpaceAvailableKb().isPresent() && !UnknownValueUtil.isUnknownValue(this.getSpaceAvailableKb().get())) {
            BigDecimal spaceAvailableKb = new BigDecimal(this.getSpaceAvailableKb().get());
            BigDecimal usedSpaceKb = spaceAvailableKb.multiply(multiplierFactor);
            return this.factory.createLong(Long.valueOf(usedSpaceKb.longValue()));
        }
        return this.factory.createLong(UNABLE_TO_CALCULATE_USED_SPACE);
    }

    @Override
    public Optional<String> getVolumeId() {
        return Optional.fromNullable((Object)this.volumeId);
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsPartition(super=" + super.toString() + ", readCountPerSecCounter=" + String.valueOf(this.readCountPerSecCounter) + ", readBytesPerSecCounter=" + String.valueOf(this.readBytesPerSecCounter) + ", writeCountPerSecCounter=" + String.valueOf(this.writeCountPerSecCounter) + ", writeBytesPerSecCounter=" + String.valueOf(this.writeBytesPerSecCounter) + ", avgReadTimeCounter=" + String.valueOf(this.avgReadTimeCounter) + ", avgWriteTimeCounter=" + String.valueOf(this.avgWriteTimeCounter) + ", utilization=" + String.valueOf(this.getUtilization()) + ", intWraparoundCalculator=" + String.valueOf(this.intWraparoundCalculator) + ", uint64WraparoundCalculator=" + String.valueOf(this.uint64WraparoundCalculator) + ", factory=" + String.valueOf(this.factory) + ", perfLogicalDisk=" + String.valueOf(this.perfLogicalDisk) + ", volumeId=" + String.valueOf(this.getVolumeId()) + ")";
    }
}

