/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;

class WindowsOperatingSystem
extends OperatingSystem<WindowsRawData> {
    private WindowsRawData.OperatingSystem os;

    @Inject
    private WindowsOperatingSystem(@Sim MachineProperties machineProperties, Predicate<ToggleableReporter<WindowsRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("Windows", machineProperties, isDisabledPredicate, rawDataFactory);
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.os = rawData.getOperatingSystem();
    }

    @Override
    public void report(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        if (rawData.getOperatingSystem() != null) {
            super.report(rawData, reportMetricsConfig);
        }
    }

    @Override
    protected RawDataString getRelease() {
        String release = this.os.getRelease();
        if (release.contains("Microsoftr")) {
            release = release.replace("Microsoftr", "Microsoft(R)");
        }
        if (release.contains("Serverr")) {
            release = release.replace("Serverr", "Server(R)");
        }
        return this.rawDataFactory.createString(Optional.fromNullable((Object)release));
    }

    @Override
    protected RawDataString getArchitecture() {
        return this.rawDataFactory.createString(Optional.fromNullable((Object)this.os.getArchitecture()));
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsOperatingSystem(super=" + super.toString() + ", os=" + String.valueOf(this.os) + ")";
    }
}

