/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.windows.Uint64WraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.IntWraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterBulkCount;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterRawCount;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.commons.validator.routines.InetAddressValidator;

class WindowsNetwork
extends Network<WindowsRawData> {
    private static final long ONE_MILLION = 1000000L;
    private WindowsRawData.NetworkInterfaceInfo networkInterfaceInfo;
    private String ipv4Addresses = UnknownValueUtil.getUnknownValueStr();
    private String ipv6Addresses = UnknownValueUtil.getUnknownValueStr();
    private String ipSubnets = UnknownValueUtil.getUnknownValueStr();
    private String defaultIpv4Gateways = UnknownValueUtil.getUnknownValueStr();
    private String defaultIpv6Gateways = UnknownValueUtil.getUnknownValueStr();
    private final PerfCounterRawCount errorsIncomingCounter;
    private final PerfCounterRawCount errorsOutgoingCounter;
    private final PerfCounterRawCount packetsIncomingCounter;
    private final PerfCounterRawCount packetsOutgoingCounter;
    private final PerfCounterRawCount bytesIncomingCounter;
    private final PerfCounterRawCount bytesOutgoingCounter;
    private final PerfCounterBulkCount packetsIncomingPerSecCounter;
    private final PerfCounterBulkCount packetsOutgoingPerSecCounter;
    private final PerfCounterBulkCount bytesIncomingPerSecCounter;
    private final PerfCounterBulkCount bytesOutgoingPerSecCounter;
    private final PerfCounterBulkCount bytesTotalPerSecCounter;
    private final IntWraparoundCalculator intWraparoundCalculator;
    private final Uint64WraparoundCalculator uint64WraparoundCalculator;

    @Inject
    private WindowsNetwork(@Assisted String networkName, @Sim MachineProperties machineProperties, @Sim MetricsService metricsService, IntWraparoundCalculator intWraparoundCalculator, Uint64WraparoundCalculator uint64WraparoundCalculator) {
        super(networkName, machineProperties, metricsService);
        this.intWraparoundCalculator = intWraparoundCalculator;
        this.uint64WraparoundCalculator = uint64WraparoundCalculator;
        this.packetsIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.packetsOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.bytesIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.bytesOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.errorsIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.errorsOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.packetsIncomingPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.packetsOutgoingPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.bytesIncomingPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.bytesOutgoingPerSecCounter = new PerfCounterBulkCount(intWraparoundCalculator);
        this.bytesTotalPerSecCounter = new PerfCounterBulkCount(uint64WraparoundCalculator);
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.networkInterfaceInfo = rawData.getNetworkInterfaceInfo().get(this.getNetworkName());
        this.processNetworkData();
        this.perfCounterRawCountCalculator(this.packetsIncomingCounter, this.networkInterfaceInfo.getPacketsIncomingPerSec());
        this.perfCounterRawCountCalculator(this.packetsOutgoingCounter, this.networkInterfaceInfo.getPacketsOutgoingPerSec());
        this.perfCounterRawCountCalculator(this.bytesIncomingCounter, this.networkInterfaceInfo.getBytesIncomingPerSec());
        this.perfCounterRawCountCalculator(this.bytesOutgoingCounter, this.networkInterfaceInfo.getBytesOutgoingPerSec());
        this.perfCounterRawCountCalculator(this.errorsIncomingCounter, this.networkInterfaceInfo.getPacketsIncomingErrors());
        this.perfCounterRawCountCalculator(this.errorsOutgoingCounter, this.networkInterfaceInfo.getPacketsOutgoingErrors());
        this.perfCounterBulkCountCalculator(this.bytesTotalPerSecCounter, this.networkInterfaceInfo.getBytesTotalPerSec());
        this.perfCounterBulkCountCalculator(this.packetsIncomingPerSecCounter, this.networkInterfaceInfo.getPacketsIncomingPerSec());
        this.perfCounterBulkCountCalculator(this.packetsOutgoingPerSecCounter, this.networkInterfaceInfo.getPacketsOutgoingPerSec());
        this.perfCounterBulkCountCalculator(this.bytesIncomingPerSecCounter, this.networkInterfaceInfo.getBytesIncomingPerSec());
        this.perfCounterBulkCountCalculator(this.bytesOutgoingPerSecCounter, this.networkInterfaceInfo.getBytesOutgoingPerSec());
    }

    private void perfCounterBulkCountCalculator(PerfCounterBulkCount counter, BigInteger metric) {
        counter.calculate(metric, this.networkInterfaceInfo.getTimestamp(), this.networkInterfaceInfo.getTimestampTicksPerSec());
    }

    private void perfCounterBulkCountCalculator(PerfCounterBulkCount counter, long metric) {
        this.perfCounterBulkCountCalculator(counter, BigInteger.valueOf(metric));
    }

    private void perfCounterRawCountCalculator(PerfCounterRawCount counter, long metric) {
        counter.calculate(BigInteger.valueOf(metric));
    }

    private void processNetworkData() {
        String ipGateway;
        String ipAddress = this.networkInterfaceInfo.getIpAddress();
        if (!UnknownValueUtil.isUnknownValue(ipAddress)) {
            List<String> ipAddresses = this.separateIpAddresses(ipAddress, true);
            this.ipv4Addresses = ipAddresses.get(0);
            this.ipv6Addresses = ipAddresses.get(1);
        }
        if (!UnknownValueUtil.isUnknownValue(ipGateway = this.networkInterfaceInfo.getDefaultIpGateway())) {
            List<String> ipGateways = this.separateIpAddresses(ipGateway, false);
            this.defaultIpv4Gateways = ipGateways.get(0);
            this.defaultIpv6Gateways = ipGateways.get(1);
        }
    }

    private List<String> separateIpAddresses(String ipAddresses, boolean addMask) {
        StringBuilder ip4sb = new StringBuilder();
        StringBuilder ip6sb = new StringBuilder();
        String[] ipAddressesArr = ipAddresses.split(",");
        String[] ipSubnetsArr = this.networkInterfaceInfo.getIpSubnet().split(",");
        for (int i = 0; i < ipAddressesArr.length; ++i) {
            String address = ipAddressesArr[i];
            if (InetAddressValidator.getInstance().isValidInet4Address(address)) {
                this.addAddress(ip4sb, address, addMask, i, ipSubnetsArr);
                continue;
            }
            if (!InetAddressValidator.getInstance().isValidInet6Address(address)) continue;
            this.addAddress(ip6sb, address, addMask, i, ipSubnetsArr);
        }
        ArrayList<String> addresses = new ArrayList<String>(2);
        addresses.add(0, ip4sb.toString());
        addresses.add(1, ip6sb.toString());
        return addresses;
    }

    private void addAddress(StringBuilder addressSb, String ipAddress, boolean addMask, int maskIndex, String[] ipSubnetsArr) {
        if (addressSb.length() != 0) {
            addressSb.append(",");
        }
        if (addMask) {
            String subnetMask = ipSubnetsArr[maskIndex];
            if (subnetMask.contains(".")) {
                SubnetUtils sUtils = new SubnetUtils(ipAddress, subnetMask);
                ipAddress = sUtils.getInfo().getCidrSignature();
            } else {
                ipAddress = ipAddress.concat("/" + subnetMask);
            }
        }
        addressSb.append(ipAddress);
    }

    @Override
    protected String getNetEnabled() {
        String netEnabled = this.networkInterfaceInfo.getNetEnabled().toLowerCase();
        if (UnknownValueUtil.isUnknownValue(netEnabled)) {
            return UnknownValueUtil.getUnknownValueStr();
        }
        if (netEnabled.equals("true")) {
            return "yes";
        }
        if (netEnabled.equals("false")) {
            return "no";
        }
        return "unknown";
    }

    @Override
    protected String getPluggedIn() {
        int statusNumber = this.networkInterfaceInfo.getNetConnectionStatus();
        if (UnknownValueUtil.isUnknownValue(new long[]{statusNumber})) {
            return UnknownValueUtil.getUnknownValueStr();
        }
        if (statusNumber == 7) {
            return "no";
        }
        return "yes";
    }

    @Override
    protected String getStatus() {
        String availability;
        int availabilityNumber = this.networkInterfaceInfo.getAvailability();
        if (UnknownValueUtil.isUnknownValue(new long[]{availabilityNumber})) {
            return UnknownValueUtil.getUnknownValueStr();
        }
        switch (availabilityNumber) {
            case 3: {
                availability = "up";
                break;
            }
            case 4: {
                availability = "up";
                break;
            }
            case 7: {
                availability = "down";
                break;
            }
            case 8: {
                availability = "down";
                break;
            }
            case 9: {
                availability = "down";
                break;
            }
            case 10: {
                availability = "up";
                break;
            }
            case 11: {
                availability = "down";
                break;
            }
            case 12: {
                availability = "down";
                break;
            }
            case 14: {
                availability = "down";
                break;
            }
            case 15: {
                availability = "down";
                break;
            }
            case 17: {
                availability = "down";
                break;
            }
            default: {
                availability = "unknown";
            }
        }
        return availability;
    }

    @Override
    protected String getDuplex() {
        return this.networkInterfaceInfo.getFullDuplex();
    }

    @Override
    protected String getMtu() {
        if (this.networkInterfaceInfo.getMtu() != 0L) {
            return String.valueOf(this.networkInterfaceInfo.getMtu());
        }
        return "unknown";
    }

    @Override
    protected String getSpeedMb() {
        return String.valueOf(CalculationUtils.divide(this.getSpeedBits(), 1000000L));
    }

    @Override
    protected String getMacAddress() {
        return this.networkInterfaceInfo.getMacAddress();
    }

    @Override
    protected String getIpv4Addresses() {
        return this.ipv4Addresses;
    }

    @Override
    protected String getIpv6Addresses() {
        return this.ipv6Addresses;
    }

    @Override
    protected String getDefaultIpv4Gateways() {
        return this.defaultIpv4Gateways;
    }

    @Override
    protected String getDefaultIpv6Gateways() {
        return this.defaultIpv6Gateways;
    }

    @Override
    protected long getIncomingKb() {
        return CalculationUtils.bytesToKilobytes(this.bytesIncomingCounter.getLastCookedResult());
    }

    @Override
    protected long getOutgoingKb() {
        return CalculationUtils.bytesToKilobytes(this.bytesOutgoingCounter.getLastCookedResult());
    }

    @Override
    protected long getIncomingPackets() {
        return this.packetsIncomingCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPackets() {
        return this.packetsOutgoingCounter.getLastCookedResult();
    }

    @Override
    protected long getIncomingPacketErrors() {
        return this.errorsIncomingCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPacketErrors() {
        return this.errorsOutgoingCounter.getLastCookedResult();
    }

    @Override
    protected long getIncomingKbPerSec() {
        return CalculationUtils.bytesToKilobytes(this.bytesIncomingPerSecCounter.getLastCookedResult());
    }

    @Override
    protected long getOutgoingKbPerSec() {
        return CalculationUtils.bytesToKilobytes(this.bytesOutgoingPerSecCounter.getLastCookedResult());
    }

    @Override
    protected long getIncomingPacketsPerSec() {
        return this.packetsIncomingPerSecCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPacketsPerSec() {
        return this.packetsOutgoingPerSecCounter.getLastCookedResult();
    }

    @Override
    protected Optional<Long> getUtilizationPct() {
        long bytesTotal = this.bytesTotalPerSecCounter.getLastCookedResult();
        long totalBits = CalculationUtils.bytesToBits(bytesTotal);
        long speedBits = this.getSpeedBits();
        if (speedBits == 0L) {
            return Optional.absent();
        }
        long calculatedUtilization = CalculationUtils.calculatePercentage(totalBits, 2L * speedBits);
        return Optional.of((Object)UnknownValueUtil.calculatedValueOrUnknown(bytesTotal, speedBits, calculatedUtilization));
    }

    protected long getSpeedBits() {
        return this.networkInterfaceInfo.getSpeed();
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsNetwork(super=" + super.toString() + ", networkInterfaceInfo=" + String.valueOf(this.networkInterfaceInfo) + ", ipv4Addresses=" + this.getIpv4Addresses() + ", ipv6Addresses=" + this.getIpv6Addresses() + ", ipSubnets=" + this.ipSubnets + ", defaultIpv4Gateways=" + this.getDefaultIpv4Gateways() + ", defaultIpv6Gateways=" + this.getDefaultIpv6Gateways() + ", errorsIncomingCounter=" + String.valueOf(this.errorsIncomingCounter) + ", errorsOutgoingCounter=" + String.valueOf(this.errorsOutgoingCounter) + ", packetsIncomingCounter=" + String.valueOf(this.packetsIncomingCounter) + ", packetsOutgoingCounter=" + String.valueOf(this.packetsOutgoingCounter) + ", bytesIncomingCounter=" + String.valueOf(this.bytesIncomingCounter) + ", bytesOutgoingCounter=" + String.valueOf(this.bytesOutgoingCounter) + ", packetsIncomingPerSecCounter=" + String.valueOf(this.packetsIncomingPerSecCounter) + ", packetsOutgoingPerSecCounter=" + String.valueOf(this.packetsOutgoingPerSecCounter) + ", bytesIncomingPerSecCounter=" + String.valueOf(this.bytesIncomingPerSecCounter) + ", bytesOutgoingPerSecCounter=" + String.valueOf(this.bytesOutgoingPerSecCounter) + ", bytesTotalPerSecCounter=" + String.valueOf(this.bytesTotalPerSecCounter) + ", intWraparoundCalculator=" + String.valueOf(this.intWraparoundCalculator) + ", uint64WraparoundCalculator=" + String.valueOf(this.uint64WraparoundCalculator) + ")";
    }
}

