/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.windows.Uint64WraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.IntWraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.processes.common.rest.SimProcessDtoState;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

class WindowsMonitoredProcessClass
extends MonitoredProcessClass<WindowsRawData> {
    private final RawDataFactory factory;
    private double cpuUsedPercent;
    private long memoryUsedKb;
    private long memoryUsedPercent;
    private long numThreads;
    private long virtualMemoryKb;
    private long processCount;
    private int numProcessors;
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessCpuMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessMemoryMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private Map<RawDataLong, String> currentProcessCommandLineMap = new HashMap<RawDataLong, String>();

    @Inject
    private WindowsMonitoredProcessClass(@Assisted @NonNull String classId, @Sim @NonNull MetricsService metricsService, IntWraparoundCalculator intWraparoundCalculator, Uint64WraparoundCalculator uint64WraparoundCalculator, @NonNull Provider<ServersMonitorConfig> serversMonitorConfig, @NonNull ProcessProperties processProperties, RawDataFactory factory, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        super(classId, metricsService, serversMonitorConfig, processProperties, repetitiveLogger, factory);
        if (classId == null) {
            throw new NullPointerException("classId is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (serversMonitorConfig == null) {
            throw new NullPointerException("serversMonitorConfig is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.factory = factory;
    }

    @Override
    protected void updateMetrics(WindowsRawData rawData, List<SimProcessObservationDto> filteredObservations) {
        List allProcsData = rawData.getProcData().get((Object)this.getClassId());
        if (allProcsData.isEmpty()) {
            return;
        }
        ImmutableSet.Builder filteredProcessIdSetBuilder = new ImmutableSet.Builder();
        for (SimProcessObservationDto simProcessObservationDto : filteredObservations) {
            filteredProcessIdSetBuilder.add((Object)((int)simProcessObservationDto.getProcessId()));
        }
        ImmutableSet filteredProcessIdSet = filteredProcessIdSetBuilder.build();
        long memoryUsedBytes = UnknownValueUtil.getUnknownValue();
        this.numThreads = UnknownValueUtil.getUnknownValue();
        long virtualMemoryRaw = UnknownValueUtil.getUnknownValue();
        double totalCpuPercent = 0.0;
        for (WindowsRawData.WinProcessRawData procData : allProcsData) {
            int processId = procData.getMetaData().getPid();
            WindowsRawData.PerfWinProcess perfData = procData.getPerfData();
            if (!filteredProcessIdSet.contains((Object)processId)) continue;
            memoryUsedBytes = CalculationUtils.aggregateComponentValue(memoryUsedBytes, perfData.getWorkingSet());
            this.numThreads = CalculationUtils.aggregateComponentValue(this.numThreads, perfData.getThreadCount());
            virtualMemoryRaw = CalculationUtils.aggregateComponentValue(virtualMemoryRaw, perfData.getVirtualBytes());
            totalCpuPercent += perfData.getCpuPercent();
        }
        this.processCount = filteredObservations.size();
        this.memoryUsedKb = CalculationUtils.bytesToKilobytes(memoryUsedBytes);
        this.memoryUsedPercent = CalculationUtils.calculatePercentage(memoryUsedBytes, rawData.getPhysicalMemoryCapacityBytes());
        this.numProcessors = rawData.getTotalNumLogicalProcessors();
        this.cpuUsedPercent = this.processCount == 0L ? 0.0 : totalCpuPercent;
        this.virtualMemoryKb = CalculationUtils.bytesToKilobytes(virtualMemoryRaw);
    }

    @Override
    protected RawDataLong getMemoryUsedKb() {
        return this.factory.createLong(Long.valueOf(this.memoryUsedKb));
    }

    @Override
    protected RawDataLong getMemoryUsedPercent() {
        return this.factory.createLong(Long.valueOf(this.memoryUsedPercent));
    }

    @Override
    protected RawDataLong getNumThreads() {
        return this.factory.createLong(Long.valueOf(this.numThreads));
    }

    @Override
    protected RawDataLong getVirtualMemoryKb() {
        return this.factory.createLong(Long.valueOf(this.virtualMemoryKb));
    }

    @Override
    protected RawDataLong getProcessCount() {
        return this.factory.createLong(Long.valueOf(this.processCount));
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessCpuMetrics() {
        return this.currentProcessCpuMetrics;
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessMemoryMetrics() {
        return this.currentProcessMemoryMetrics;
    }

    @Override
    public Map<RawDataLong, String> getCurrentProcessCommandLineMap() {
        return this.currentProcessCommandLineMap;
    }

    @Override
    protected RawDataLong getMajorFaultsRate() {
        return RawDataConstants.ZERO_LONG;
    }

    @Override
    protected RawDataLong getMinorFaultsRate() {
        return RawDataConstants.ZERO_LONG;
    }

    @Override
    protected RawDataLong getCpuUsedPercent() {
        return this.factory.createLong(Long.valueOf(this.numProcessors == 0 ? 0L : (long)(this.cpuUsedPercent * 100.0 / (double)this.numProcessors)));
    }

    @Override
    public Map<RawDataLong, SimProcessDtoState> getCurrentProcessStateMetrics() {
        return new HashMap<RawDataLong, SimProcessDtoState>();
    }

    @Override
    protected ImmutableList<SimProcessObservationDto> getAllObservations(WindowsRawData rawData) {
        this.numProcessors = rawData.getTotalNumLogicalProcessors();
        List allProcsData = rawData.getProcData().get((Object)this.getClassId());
        ImmutableList.Builder observationsBuilder = ImmutableList.builder();
        this.updateProcessMetricsMap(allProcsData, rawData.getPhysicalMemoryCapacityBytes());
        for (WindowsRawData.WinProcessRawData procData : allProcsData) {
            SimProcessObservationDto observation = new SimProcessObservationDto(procData.getPerfData().getElapsedTime(), procData.getProcClass().getProcessClassId(), procData.getProcClass().getProcessClass(), procData.getMetaData().getName(), (long)procData.getMetaData().getPid(), (long)procData.getMetaData().getPpid(), procData.getMetaData().getCommandLine(), procData.getMetaData().getOwner(), SimProcessDtoState.RUNNING, Collections.emptyMap());
            observationsBuilder.add((Object)observation);
        }
        return observationsBuilder.build();
    }

    private void updateProcessMetricsMap(List<WindowsRawData.WinProcessRawData> procData, long physicalMemoryCapacity) {
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newCpuData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newMemoryData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, String> newCommandLineMap = new HashMap<RawDataLong, String>();
        for (WindowsRawData.WinProcessRawData processRawData : procData) {
            WindowsRawData.PerfWinProcess process = processRawData.getPerfData();
            RawDataLong pid = this.factory.createLong(Long.valueOf(processRawData.getMetaData().getPid()));
            RawDataLong cpuUsage = this.factory.createLong(Long.valueOf(this.numProcessors == 0 ? 0L : (long)(process.getCpuPercent() * 100.0 / (double)this.numProcessors)));
            RawDataLong memoryUsage = this.factory.createLong(Long.valueOf(CalculationUtils.calculatePercentage(process.getWorkingSet(), physicalMemoryCapacity)));
            Double alpha = this.getAverageAlpha();
            Double expoMovingMemoryAverageValue = (double)memoryUsage.get().longValue() * 1.0;
            Double expoMovingCpuAverageValue = (double)cpuUsage.get().longValue() * 1.0;
            if (this.currentProcessMemoryMetrics.get(pid) != null) {
                Double oldMemoryUsage = this.currentProcessMemoryMetrics.get(pid).getSecond();
                Double oldCpuUsage = this.currentProcessCpuMetrics.get(pid).getSecond();
                expoMovingMemoryAverageValue = oldMemoryUsage + alpha * ((double)memoryUsage.get().longValue() - oldMemoryUsage);
                expoMovingCpuAverageValue = oldCpuUsage + alpha * ((double)cpuUsage.get().longValue() - oldCpuUsage);
            }
            newCpuData.put(pid, Pair.of(cpuUsage, expoMovingCpuAverageValue));
            newMemoryData.put(pid, Pair.of(memoryUsage, expoMovingMemoryAverageValue));
            newCommandLineMap.put(pid, processRawData.getMetaData().getCommandLine());
        }
        this.currentProcessCpuMetrics = newCpuData;
        this.currentProcessMemoryMetrics = newMemoryData;
        this.currentProcessCommandLineMap = newCommandLineMap;
    }
}

