/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;

class WindowsMemory
extends Memory<WindowsRawData> {
    private final RawDataFactory rawDataFactory;
    private WindowsRawData.Memory memory;
    private long physicalMemoryCapacityBytes;

    @Inject
    private WindowsMemory(@Sim MetricsService metricsService, @Sim MachineProperties machineProperties, Predicate<ToggleableReporter<WindowsRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("WindowsMemory", metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memory = rawData.getMemory();
        this.physicalMemoryCapacityBytes = rawData.getPhysicalMemoryCapacityBytes();
    }

    @Override
    public void report(WindowsRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        if (rawData.getMemory() != null) {
            super.report(rawData, reportMetricsConfig);
        }
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        return this.rawDataFactory.createLong(Long.valueOf(CalculationUtils.bytesToMegabytes(this.memory.getSwapTotal())));
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        return this.rawDataFactory.createLong(Long.valueOf(CalculationUtils.bytesToMegabytes(this.memory.getSwapFree())));
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        return this.rawDataFactory.createLong(Long.valueOf(CalculationUtils.bytesToMegabytes(this.physicalMemoryCapacityBytes)));
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        return this.rawDataFactory.createLong(Long.valueOf(CalculationUtils.bytesToMegabytes(this.memory.getPhysicalFree())));
    }

    @Generated
    public String toString() {
        return "WindowsMemory(super=" + super.toString() + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", memory=" + String.valueOf(this.memory) + ", physicalMemoryCapacityBytes=" + this.physicalMemoryCapacityBytes + ")";
    }
}

