/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.agent.extensions.servers.model.windows.WindowsRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WindowsCpus
extends Cpus<WindowsRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WindowsCpus.class);
    private final DeltaCalculatorUtil totalTicksCalc = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil idleTicksCalc = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil stealTicksCalc = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil systemTicksCalc = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil userTicksCalc = new DeltaCalculatorUtil();

    @Inject
    @VisibleForTesting
    protected WindowsCpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<WindowsRawData, Cpu<WindowsRawData>> cpuFactory, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<WindowsRawData>> filters, @NonNull Set<Transformer<Cpu<WindowsRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<WindowsRawData>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, metricsService, machineProperties, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
    }

    @Override
    protected Set<String> extractIds(WindowsRawData rawData) {
        return Collections.unmodifiableSet(rawData.getCpus().keySet());
    }

    @Override
    public void doAggregateUpdate(WindowsRawData rawData) {
        WindowsRawData.CpuPerf cpuPerf = rawData.getCpusPerf().get("_Total");
        this.totalTicksCalc.calculate(cpuPerf.getTimestamp());
        this.idleTicksCalc.calculate(cpuPerf.getIdleTicks());
        this.stealTicksCalc.calculate(cpuPerf.getStealTicks());
        this.systemTicksCalc.calculate(cpuPerf.getSystemTicks());
        this.userTicksCalc.calculate(cpuPerf.getUserTicks());
    }

    @Override
    protected long getPercentBusy() {
        return 100L - this.getPercentIdle() - (Long)this.getPercentStolen().get();
    }

    @Override
    protected long getPercentIdle() {
        return CalculationUtils.calculatePercentage(this.idleTicksCalc.getLastResult(), this.totalTicksCalc.getLastResult());
    }

    @Override
    protected Optional<Long> getPercentStolen() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.stealTicksCalc.getLastResult(), this.totalTicksCalc.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentSystem() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.systemTicksCalc.getLastResult(), this.totalTicksCalc.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentUser() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.userTicksCalc.getLastResult(), this.totalTicksCalc.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentNice() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentSoftIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIoWait() {
        return Optional.absent();
    }

    @Override
    @Generated
    public String toString() {
        return "WindowsCpus(super=" + super.toString() + ", totalTicksCalc=" + String.valueOf(this.totalTicksCalc) + ", idleTicksCalc=" + String.valueOf(this.idleTicksCalc) + ", stealTicksCalc=" + String.valueOf(this.stealTicksCalc) + ", systemTicksCalc=" + String.valueOf(this.systemTicksCalc) + ", userTicksCalc=" + String.valueOf(this.userTicksCalc) + ")";
    }
}

