/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.windows;

import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.agent.extensions.servers.util.WraparoundCalculator;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

class PerfAverageTimer {
    private static final long MILLIS_PER_SEC = TimeUnit.SECONDS.toMillis(1L);
    private BigInteger previousInput;
    private BigInteger previousInputBase;
    private final WraparoundCalculator inputCalculator;
    private final WraparoundCalculator baseCalculator;
    private long lastCookedResult;

    long calculate(BigInteger input, BigInteger base, BigInteger ticksPerSec) {
        if (UnknownValueUtil.isUnknownValue(input, base, ticksPerSec)) {
            this.lastCookedResult = UnknownValueUtil.getUnknownValue();
            return this.lastCookedResult;
        }
        if (this.previousInput != null) {
            if (base.equals(this.previousInputBase)) {
                return this.lastCookedResult;
            }
            BigInteger inputDifference = this.inputCalculator.calculateDifference(input, this.previousInput);
            BigInteger baseDifference = this.baseCalculator.calculateDifference(base, this.previousInputBase);
            this.lastCookedResult = BigInteger.valueOf(MILLIS_PER_SEC).multiply(inputDifference).divide(ticksPerSec).divide(baseDifference).longValue();
        }
        this.previousInput = input;
        this.previousInputBase = base;
        return this.lastCookedResult;
    }

    @Generated
    public String toString() {
        return "PerfAverageTimer(previousInput=" + String.valueOf(this.previousInput) + ", previousInputBase=" + String.valueOf(this.previousInputBase) + ", inputCalculator=" + String.valueOf(this.inputCalculator) + ", baseCalculator=" + String.valueOf(this.baseCalculator) + ", lastCookedResult=" + this.getLastCookedResult() + ")";
    }

    @Generated
    public PerfAverageTimer(WraparoundCalculator inputCalculator, WraparoundCalculator baseCalculator) {
        this.inputCalculator = inputCalculator;
        this.baseCalculator = baseCalculator;
    }

    @Generated
    public long getLastCookedResult() {
        return this.lastCookedResult;
    }
}

