/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.transformer;

import com.appdynamics.voltron.utils.overrides.OverrideIfBlank;
import com.appdynamics.voltron.utils.overrides.RegexValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TransformerConfig {
    @VisibleForTesting
    public static final String DEFAULT_MASK_TEXT = "***";
    private static final String DEFAULT_REGEX = "^$";
    private static final Pattern DEFAULT_PATTERN = Pattern.compile("^$");
    private static final List<Integer> DEFAULT_GROUPS = Collections.emptyList();
    @NotNull
    @OverrideIfBlank(value="^$")
    @RegexValidation
    private String regex;
    @NotNull
    private List<Integer> replaceAtGroupNumbers = Collections.emptyList();
    @NotNull
    @OverrideIfBlank(value="***")
    private String replaceWith;
    @JsonIgnore
    private Pattern pattern = DEFAULT_PATTERN;

    private TransformerConfig(String regex, List<Integer> replaceAtGroupNumbers, String replaceWith) {
        this.setRegex(regex);
        this.replaceAtGroupNumbers = replaceAtGroupNumbers;
        this.replaceWith = replaceWith;
    }

    public void setRegex(String regex) {
        if (StringUtils.isBlank((CharSequence)regex)) {
            this.regex = DEFAULT_REGEX;
            this.pattern = DEFAULT_PATTERN;
        } else {
            this.regex = regex;
            this.pattern = Pattern.compile(this.regex);
        }
    }

    @Generated
    public static TransformerConfigBuilder builder() {
        return new TransformerConfigBuilder();
    }

    @Generated
    public String getRegex() {
        return this.regex;
    }

    @Generated
    public List<Integer> getReplaceAtGroupNumbers() {
        return this.replaceAtGroupNumbers;
    }

    @Generated
    public String getReplaceWith() {
        return this.replaceWith;
    }

    @Generated
    public Pattern getPattern() {
        return this.pattern;
    }

    @Generated
    public void setReplaceAtGroupNumbers(List<Integer> replaceAtGroupNumbers) {
        this.replaceAtGroupNumbers = replaceAtGroupNumbers;
    }

    @Generated
    public void setReplaceWith(String replaceWith) {
        this.replaceWith = replaceWith;
    }

    @Generated
    public String toString() {
        return "TransformerConfig(regex=" + this.getRegex() + ", replaceAtGroupNumbers=" + String.valueOf(this.getReplaceAtGroupNumbers()) + ", replaceWith=" + this.getReplaceWith() + ", pattern=" + String.valueOf(this.getPattern()) + ")";
    }

    @Generated
    public TransformerConfig() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransformerConfig)) {
            return false;
        }
        TransformerConfig other = (TransformerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        List<Integer> this$replaceAtGroupNumbers = this.getReplaceAtGroupNumbers();
        List<Integer> other$replaceAtGroupNumbers = other.getReplaceAtGroupNumbers();
        if (this$replaceAtGroupNumbers == null ? other$replaceAtGroupNumbers != null : !((Object)this$replaceAtGroupNumbers).equals(other$replaceAtGroupNumbers)) {
            return false;
        }
        String this$replaceWith = this.getReplaceWith();
        String other$replaceWith = other.getReplaceWith();
        return !(this$replaceWith == null ? other$replaceWith != null : !this$replaceWith.equals(other$replaceWith));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TransformerConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        List<Integer> $replaceAtGroupNumbers = this.getReplaceAtGroupNumbers();
        result = result * 59 + ($replaceAtGroupNumbers == null ? 43 : ((Object)$replaceAtGroupNumbers).hashCode());
        String $replaceWith = this.getReplaceWith();
        result = result * 59 + ($replaceWith == null ? 43 : $replaceWith.hashCode());
        return result;
    }

    @Generated
    public static class TransformerConfigBuilder {
        @Generated
        private String regex;
        @Generated
        private List<Integer> replaceAtGroupNumbers;
        @Generated
        private String replaceWith;

        @Generated
        TransformerConfigBuilder() {
        }

        @Generated
        public TransformerConfigBuilder regex(String regex) {
            this.regex = regex;
            return this;
        }

        @Generated
        public TransformerConfigBuilder replaceAtGroupNumbers(List<Integer> replaceAtGroupNumbers) {
            this.replaceAtGroupNumbers = replaceAtGroupNumbers;
            return this;
        }

        @Generated
        public TransformerConfigBuilder replaceWith(String replaceWith) {
            this.replaceWith = replaceWith;
            return this;
        }

        @Generated
        public TransformerConfig build() {
            return new TransformerConfig(this.regex, this.replaceAtGroupNumbers, this.replaceWith);
        }

        @Generated
        public String toString() {
            return "TransformerConfig.TransformerConfigBuilder(regex=" + this.regex + ", replaceAtGroupNumbers=" + String.valueOf(this.replaceAtGroupNumbers) + ", replaceWith=" + this.replaceWith + ")";
        }
    }
}

