/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisVolumesUtil;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

@VisibleForAssistedInject
public class SolarisVolume
extends Volume<SolarisRawData> {
    private SolarisRawData.Volume volume;
    private Set<String> validVolumePartitionNames;

    @Inject
    private SolarisVolume(@Assisted @NonNull String mountPoint, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataFactory factory, @NonNull RawDataItemUtil dataItemUtil) {
        super(mountPoint, metricsService, machineProperties, factory, dataItemUtil);
        if (mountPoint == null) {
            throw new NullPointerException("mountPoint is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        if (dataItemUtil == null) {
            throw new NullPointerException("dataItemUtil is marked non-null but is null");
        }
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.volume = rawData.getVolumes().get(this.getMountPoint());
        this.validVolumePartitionNames = rawData.getPartitions().keySet();
    }

    @Override
    protected RawDataString getPartition() {
        if (this.validVolumePartitionNames.contains(this.volume.getName())) {
            return this.getFactory().createString(Optional.of((Object)this.volume.getName()));
        }
        return RawDataConstants.ABSENT_STRING;
    }

    @Override
    protected RawDataLong getSizeMb() {
        long sizeKb = SolarisVolumesUtil.getKbsFromSize(this.volume.getTotalSpace(), this.volume.getName());
        long sizeMb = SizeUnit.KILOBYTES.toMegabytes(sizeKb);
        return this.getFactory().createLong(Long.valueOf(sizeMb));
    }

    @Override
    protected RawDataLong getUsedMb() {
        long usedKb = SolarisVolumesUtil.getKbsFromSize(this.volume.getUsedSpace(), this.volume.getName());
        long usedMb = SizeUnit.KILOBYTES.toMegabytes(usedKb);
        return this.getFactory().createLong(Long.valueOf(usedMb));
    }

    @Override
    protected RawDataString getPartitionDisplayName() {
        Optional partitionOpt = this.getPartition().getValue();
        Optional<String> partitionDisplayNameOpt = SolarisVolumesUtil.getPartitionNameFromPath((Optional<String>)partitionOpt);
        return this.getFactory().createString(partitionDisplayNameOpt);
    }

    @Override
    @Generated
    public String toString() {
        return "SolarisVolume(super=" + super.toString() + ", volume=" + String.valueOf(this.volume) + ", validVolumePartitionNames=" + String.valueOf(this.validVolumePartitionNames) + ")";
    }
}

