/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

class SolarisRawData {
    @NonNull
    private OperatingSystem operatingSystem;
    @NonNull
    private Memory memory;
    @NonNull
    private Map<String, Cpu> cpus = Collections.emptyMap();
    @NonNull
    private Map<String, CpuPerf> cpuPerfs = Collections.emptyMap();
    @NonNull
    private Map<String, Volume> volumes = Collections.emptyMap();
    @NonNull
    private Map<String, Partition> partitions = Collections.emptyMap();
    @NonNull
    private Load load;
    private int totalNumLogicalProcessors;
    private long epochTime;
    @NonNull
    private Map<String, Process> processes = Collections.emptyMap();
    @NonNull
    private ListMultimap<String, ProcessRawData> procData = ArrayListMultimap.create();
    @NonNull
    private Map<String, NetworkInterfaceInfo> networkInterfaces = Collections.emptyMap();

    public SolarisRawData(Memory memory, Map<String, Cpu> cpus, Map<String, CpuPerf> cpuPerfs, Map<String, Process> processes, OperatingSystem operatingSystem, Load load, Map<String, NetworkInterfaceInfo> networkInterfaces, Map<String, Volume> volumes, Map<String, Partition> partitions, int totalNumLogicalProcessors, long epochTime) {
        this.memory = memory;
        this.cpus = cpus;
        this.cpuPerfs = cpuPerfs;
        this.processes = processes;
        this.operatingSystem = operatingSystem;
        this.volumes = volumes;
        this.partitions = partitions;
        this.load = load;
        this.networkInterfaces = networkInterfaces;
        this.totalNumLogicalProcessors = totalNumLogicalProcessors;
        this.epochTime = epochTime;
    }

    @NonNull
    @Generated
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @NonNull
    @Generated
    public Memory getMemory() {
        return this.memory;
    }

    @NonNull
    @Generated
    public Map<String, Cpu> getCpus() {
        return this.cpus;
    }

    @NonNull
    @Generated
    public Map<String, CpuPerf> getCpuPerfs() {
        return this.cpuPerfs;
    }

    @NonNull
    @Generated
    public Map<String, Volume> getVolumes() {
        return this.volumes;
    }

    @NonNull
    @Generated
    public Map<String, Partition> getPartitions() {
        return this.partitions;
    }

    @NonNull
    @Generated
    public Load getLoad() {
        return this.load;
    }

    @Generated
    public int getTotalNumLogicalProcessors() {
        return this.totalNumLogicalProcessors;
    }

    @Generated
    public long getEpochTime() {
        return this.epochTime;
    }

    @NonNull
    @Generated
    public Map<String, Process> getProcesses() {
        return this.processes;
    }

    @NonNull
    @Generated
    public ListMultimap<String, ProcessRawData> getProcData() {
        return this.procData;
    }

    @NonNull
    @Generated
    public Map<String, NetworkInterfaceInfo> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @Generated
    public void setOperatingSystem(@NonNull OperatingSystem operatingSystem) {
        if (operatingSystem == null) {
            throw new NullPointerException("operatingSystem is marked non-null but is null");
        }
        this.operatingSystem = operatingSystem;
    }

    @Generated
    public void setMemory(@NonNull Memory memory) {
        if (memory == null) {
            throw new NullPointerException("memory is marked non-null but is null");
        }
        this.memory = memory;
    }

    @Generated
    public void setCpus(@NonNull Map<String, Cpu> cpus) {
        if (cpus == null) {
            throw new NullPointerException("cpus is marked non-null but is null");
        }
        this.cpus = cpus;
    }

    @Generated
    public void setCpuPerfs(@NonNull Map<String, CpuPerf> cpuPerfs) {
        if (cpuPerfs == null) {
            throw new NullPointerException("cpuPerfs is marked non-null but is null");
        }
        this.cpuPerfs = cpuPerfs;
    }

    @Generated
    public void setVolumes(@NonNull Map<String, Volume> volumes) {
        if (volumes == null) {
            throw new NullPointerException("volumes is marked non-null but is null");
        }
        this.volumes = volumes;
    }

    @Generated
    public void setPartitions(@NonNull Map<String, Partition> partitions) {
        if (partitions == null) {
            throw new NullPointerException("partitions is marked non-null but is null");
        }
        this.partitions = partitions;
    }

    @Generated
    public void setLoad(@NonNull Load load) {
        if (load == null) {
            throw new NullPointerException("load is marked non-null but is null");
        }
        this.load = load;
    }

    @Generated
    public void setTotalNumLogicalProcessors(int totalNumLogicalProcessors) {
        this.totalNumLogicalProcessors = totalNumLogicalProcessors;
    }

    @Generated
    public void setEpochTime(long epochTime) {
        this.epochTime = epochTime;
    }

    @Generated
    public void setProcesses(@NonNull Map<String, Process> processes) {
        if (processes == null) {
            throw new NullPointerException("processes is marked non-null but is null");
        }
        this.processes = processes;
    }

    @Generated
    public void setProcData(@NonNull ListMultimap<String, ProcessRawData> procData) {
        if (procData == null) {
            throw new NullPointerException("procData is marked non-null but is null");
        }
        this.procData = procData;
    }

    @Generated
    public void setNetworkInterfaces(@NonNull Map<String, NetworkInterfaceInfo> networkInterfaces) {
        if (networkInterfaces == null) {
            throw new NullPointerException("networkInterfaces is marked non-null but is null");
        }
        this.networkInterfaces = networkInterfaces;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolarisRawData)) {
            return false;
        }
        SolarisRawData other = (SolarisRawData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalNumLogicalProcessors() != other.getTotalNumLogicalProcessors()) {
            return false;
        }
        if (this.getEpochTime() != other.getEpochTime()) {
            return false;
        }
        OperatingSystem this$operatingSystem = this.getOperatingSystem();
        OperatingSystem other$operatingSystem = other.getOperatingSystem();
        if (this$operatingSystem == null ? other$operatingSystem != null : !((Object)this$operatingSystem).equals(other$operatingSystem)) {
            return false;
        }
        Memory this$memory = this.getMemory();
        Memory other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        Map<String, Cpu> this$cpus = this.getCpus();
        Map<String, Cpu> other$cpus = other.getCpus();
        if (this$cpus == null ? other$cpus != null : !((Object)this$cpus).equals(other$cpus)) {
            return false;
        }
        Map<String, CpuPerf> this$cpuPerfs = this.getCpuPerfs();
        Map<String, CpuPerf> other$cpuPerfs = other.getCpuPerfs();
        if (this$cpuPerfs == null ? other$cpuPerfs != null : !((Object)this$cpuPerfs).equals(other$cpuPerfs)) {
            return false;
        }
        Map<String, Volume> this$volumes = this.getVolumes();
        Map<String, Volume> other$volumes = other.getVolumes();
        if (this$volumes == null ? other$volumes != null : !((Object)this$volumes).equals(other$volumes)) {
            return false;
        }
        Map<String, Partition> this$partitions = this.getPartitions();
        Map<String, Partition> other$partitions = other.getPartitions();
        if (this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions)) {
            return false;
        }
        Load this$load = this.getLoad();
        Load other$load = other.getLoad();
        if (this$load == null ? other$load != null : !((Object)this$load).equals(other$load)) {
            return false;
        }
        Map<String, Process> this$processes = this.getProcesses();
        Map<String, Process> other$processes = other.getProcesses();
        if (this$processes == null ? other$processes != null : !((Object)this$processes).equals(other$processes)) {
            return false;
        }
        ListMultimap<String, ProcessRawData> this$procData = this.getProcData();
        ListMultimap<String, ProcessRawData> other$procData = other.getProcData();
        if (this$procData == null ? other$procData != null : !this$procData.equals(other$procData)) {
            return false;
        }
        Map<String, NetworkInterfaceInfo> this$networkInterfaces = this.getNetworkInterfaces();
        Map<String, NetworkInterfaceInfo> other$networkInterfaces = other.getNetworkInterfaces();
        return !(this$networkInterfaces == null ? other$networkInterfaces != null : !((Object)this$networkInterfaces).equals(other$networkInterfaces));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SolarisRawData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalNumLogicalProcessors();
        long $epochTime = this.getEpochTime();
        result = result * 59 + (int)($epochTime >>> 32 ^ $epochTime);
        OperatingSystem $operatingSystem = this.getOperatingSystem();
        result = result * 59 + ($operatingSystem == null ? 43 : ((Object)$operatingSystem).hashCode());
        Memory $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        Map<String, Cpu> $cpus = this.getCpus();
        result = result * 59 + ($cpus == null ? 43 : ((Object)$cpus).hashCode());
        Map<String, CpuPerf> $cpuPerfs = this.getCpuPerfs();
        result = result * 59 + ($cpuPerfs == null ? 43 : ((Object)$cpuPerfs).hashCode());
        Map<String, Volume> $volumes = this.getVolumes();
        result = result * 59 + ($volumes == null ? 43 : ((Object)$volumes).hashCode());
        Map<String, Partition> $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        Load $load = this.getLoad();
        result = result * 59 + ($load == null ? 43 : ((Object)$load).hashCode());
        Map<String, Process> $processes = this.getProcesses();
        result = result * 59 + ($processes == null ? 43 : ((Object)$processes).hashCode());
        ListMultimap<String, ProcessRawData> $procData = this.getProcData();
        result = result * 59 + ($procData == null ? 43 : $procData.hashCode());
        Map<String, NetworkInterfaceInfo> $networkInterfaces = this.getNetworkInterfaces();
        result = result * 59 + ($networkInterfaces == null ? 43 : ((Object)$networkInterfaces).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SolarisRawData(operatingSystem=" + String.valueOf(this.getOperatingSystem()) + ", memory=" + String.valueOf(this.getMemory()) + ", cpus=" + String.valueOf(this.getCpus()) + ", cpuPerfs=" + String.valueOf(this.getCpuPerfs()) + ", volumes=" + String.valueOf(this.getVolumes()) + ", partitions=" + String.valueOf(this.getPartitions()) + ", load=" + String.valueOf(this.getLoad()) + ", totalNumLogicalProcessors=" + this.getTotalNumLogicalProcessors() + ", epochTime=" + this.getEpochTime() + ", processes=" + String.valueOf(this.getProcesses()) + ", procData=" + String.valueOf(this.getProcData()) + ", networkInterfaces=" + String.valueOf(this.getNetworkInterfaces()) + ")";
    }

    @Generated
    protected SolarisRawData() {
    }

    static class Memory {
        private long pageSize;
        private long totalPages;
        private long freePages;
        private long arcSize;
        private long arcMinSize;
        private long swapUsedKb;
        private long swapFreeKb;

        @Generated
        public static MemoryBuilder builder() {
            return new MemoryBuilder();
        }

        @Generated
        public long getPageSize() {
            return this.pageSize;
        }

        @Generated
        public long getTotalPages() {
            return this.totalPages;
        }

        @Generated
        public long getFreePages() {
            return this.freePages;
        }

        @Generated
        public long getArcSize() {
            return this.arcSize;
        }

        @Generated
        public long getArcMinSize() {
            return this.arcMinSize;
        }

        @Generated
        public long getSwapUsedKb() {
            return this.swapUsedKb;
        }

        @Generated
        public long getSwapFreeKb() {
            return this.swapFreeKb;
        }

        @Generated
        public void setPageSize(long pageSize) {
            this.pageSize = pageSize;
        }

        @Generated
        public void setTotalPages(long totalPages) {
            this.totalPages = totalPages;
        }

        @Generated
        public void setFreePages(long freePages) {
            this.freePages = freePages;
        }

        @Generated
        public void setArcSize(long arcSize) {
            this.arcSize = arcSize;
        }

        @Generated
        public void setArcMinSize(long arcMinSize) {
            this.arcMinSize = arcMinSize;
        }

        @Generated
        public void setSwapUsedKb(long swapUsedKb) {
            this.swapUsedKb = swapUsedKb;
        }

        @Generated
        public void setSwapFreeKb(long swapFreeKb) {
            this.swapFreeKb = swapFreeKb;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Memory)) {
                return false;
            }
            Memory other = (Memory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPageSize() != other.getPageSize()) {
                return false;
            }
            if (this.getTotalPages() != other.getTotalPages()) {
                return false;
            }
            if (this.getFreePages() != other.getFreePages()) {
                return false;
            }
            if (this.getArcSize() != other.getArcSize()) {
                return false;
            }
            if (this.getArcMinSize() != other.getArcMinSize()) {
                return false;
            }
            if (this.getSwapUsedKb() != other.getSwapUsedKb()) {
                return false;
            }
            return this.getSwapFreeKb() == other.getSwapFreeKb();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Memory;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $pageSize = this.getPageSize();
            result = result * 59 + (int)($pageSize >>> 32 ^ $pageSize);
            long $totalPages = this.getTotalPages();
            result = result * 59 + (int)($totalPages >>> 32 ^ $totalPages);
            long $freePages = this.getFreePages();
            result = result * 59 + (int)($freePages >>> 32 ^ $freePages);
            long $arcSize = this.getArcSize();
            result = result * 59 + (int)($arcSize >>> 32 ^ $arcSize);
            long $arcMinSize = this.getArcMinSize();
            result = result * 59 + (int)($arcMinSize >>> 32 ^ $arcMinSize);
            long $swapUsedKb = this.getSwapUsedKb();
            result = result * 59 + (int)($swapUsedKb >>> 32 ^ $swapUsedKb);
            long $swapFreeKb = this.getSwapFreeKb();
            result = result * 59 + (int)($swapFreeKb >>> 32 ^ $swapFreeKb);
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Memory(pageSize=" + this.getPageSize() + ", totalPages=" + this.getTotalPages() + ", freePages=" + this.getFreePages() + ", arcSize=" + this.getArcSize() + ", arcMinSize=" + this.getArcMinSize() + ", swapUsedKb=" + this.getSwapUsedKb() + ", swapFreeKb=" + this.getSwapFreeKb() + ")";
        }

        @Generated
        public Memory(long pageSize, long totalPages, long freePages, long arcSize, long arcMinSize, long swapUsedKb, long swapFreeKb) {
            this.pageSize = pageSize;
            this.totalPages = totalPages;
            this.freePages = freePages;
            this.arcSize = arcSize;
            this.arcMinSize = arcMinSize;
            this.swapUsedKb = swapUsedKb;
            this.swapFreeKb = swapFreeKb;
        }

        @Generated
        protected Memory() {
        }

        @Generated
        public static class MemoryBuilder {
            @Generated
            private long pageSize;
            @Generated
            private long totalPages;
            @Generated
            private long freePages;
            @Generated
            private long arcSize;
            @Generated
            private long arcMinSize;
            @Generated
            private long swapUsedKb;
            @Generated
            private long swapFreeKb;

            @Generated
            MemoryBuilder() {
            }

            @Generated
            public MemoryBuilder pageSize(long pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            @Generated
            public MemoryBuilder totalPages(long totalPages) {
                this.totalPages = totalPages;
                return this;
            }

            @Generated
            public MemoryBuilder freePages(long freePages) {
                this.freePages = freePages;
                return this;
            }

            @Generated
            public MemoryBuilder arcSize(long arcSize) {
                this.arcSize = arcSize;
                return this;
            }

            @Generated
            public MemoryBuilder arcMinSize(long arcMinSize) {
                this.arcMinSize = arcMinSize;
                return this;
            }

            @Generated
            public MemoryBuilder swapUsedKb(long swapUsedKb) {
                this.swapUsedKb = swapUsedKb;
                return this;
            }

            @Generated
            public MemoryBuilder swapFreeKb(long swapFreeKb) {
                this.swapFreeKb = swapFreeKb;
                return this;
            }

            @Generated
            public Memory build() {
                return new Memory(this.pageSize, this.totalPages, this.freePages, this.arcSize, this.arcMinSize, this.swapUsedKb, this.swapFreeKb);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Memory.MemoryBuilder(pageSize=" + this.pageSize + ", totalPages=" + this.totalPages + ", freePages=" + this.freePages + ", arcSize=" + this.arcSize + ", arcMinSize=" + this.arcMinSize + ", swapUsedKb=" + this.swapUsedKb + ", swapFreeKb=" + this.swapFreeKb + ")";
            }
        }
    }

    static class OperatingSystem {
        @NonNull
        private String release;
        @NonNull
        private String architecture;

        @Generated
        public static OperatingSystemBuilder builder() {
            return new OperatingSystemBuilder();
        }

        @NonNull
        @Generated
        public String getRelease() {
            return this.release;
        }

        @NonNull
        @Generated
        public String getArchitecture() {
            return this.architecture;
        }

        @Generated
        public void setRelease(@NonNull String release) {
            if (release == null) {
                throw new NullPointerException("release is marked non-null but is null");
            }
            this.release = release;
        }

        @Generated
        public void setArchitecture(@NonNull String architecture) {
            if (architecture == null) {
                throw new NullPointerException("architecture is marked non-null but is null");
            }
            this.architecture = architecture;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatingSystem)) {
                return false;
            }
            OperatingSystem other = (OperatingSystem)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$release = this.getRelease();
            String other$release = other.getRelease();
            if (this$release == null ? other$release != null : !this$release.equals(other$release)) {
                return false;
            }
            String this$architecture = this.getArchitecture();
            String other$architecture = other.getArchitecture();
            return !(this$architecture == null ? other$architecture != null : !this$architecture.equals(other$architecture));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OperatingSystem;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $release = this.getRelease();
            result = result * 59 + ($release == null ? 43 : $release.hashCode());
            String $architecture = this.getArchitecture();
            result = result * 59 + ($architecture == null ? 43 : $architecture.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.OperatingSystem(release=" + this.getRelease() + ", architecture=" + this.getArchitecture() + ")";
        }

        @Generated
        public OperatingSystem(@NonNull String release, @NonNull String architecture) {
            if (release == null) {
                throw new NullPointerException("release is marked non-null but is null");
            }
            if (architecture == null) {
                throw new NullPointerException("architecture is marked non-null but is null");
            }
            this.release = release;
            this.architecture = architecture;
        }

        @Generated
        protected OperatingSystem() {
        }

        @Generated
        public static class OperatingSystemBuilder {
            @Generated
            private String release;
            @Generated
            private String architecture;

            @Generated
            OperatingSystemBuilder() {
            }

            @Generated
            public OperatingSystemBuilder release(@NonNull String release) {
                if (release == null) {
                    throw new NullPointerException("release is marked non-null but is null");
                }
                this.release = release;
                return this;
            }

            @Generated
            public OperatingSystemBuilder architecture(@NonNull String architecture) {
                if (architecture == null) {
                    throw new NullPointerException("architecture is marked non-null but is null");
                }
                this.architecture = architecture;
                return this;
            }

            @Generated
            public OperatingSystem build() {
                return new OperatingSystem(this.release, this.architecture);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.OperatingSystem.OperatingSystemBuilder(release=" + this.release + ", architecture=" + this.architecture + ")";
            }
        }
    }

    static class Load {
        private long oneMinute;
        private long fiveMinutes;
        private long fifteenMinutes;

        @Generated
        public static LoadBuilder builder() {
            return new LoadBuilder();
        }

        @Generated
        public long getOneMinute() {
            return this.oneMinute;
        }

        @Generated
        public long getFiveMinutes() {
            return this.fiveMinutes;
        }

        @Generated
        public long getFifteenMinutes() {
            return this.fifteenMinutes;
        }

        @Generated
        public void setOneMinute(long oneMinute) {
            this.oneMinute = oneMinute;
        }

        @Generated
        public void setFiveMinutes(long fiveMinutes) {
            this.fiveMinutes = fiveMinutes;
        }

        @Generated
        public void setFifteenMinutes(long fifteenMinutes) {
            this.fifteenMinutes = fifteenMinutes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Load)) {
                return false;
            }
            Load other = (Load)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getOneMinute() != other.getOneMinute()) {
                return false;
            }
            if (this.getFiveMinutes() != other.getFiveMinutes()) {
                return false;
            }
            return this.getFifteenMinutes() == other.getFifteenMinutes();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Load;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $oneMinute = this.getOneMinute();
            result = result * 59 + (int)($oneMinute >>> 32 ^ $oneMinute);
            long $fiveMinutes = this.getFiveMinutes();
            result = result * 59 + (int)($fiveMinutes >>> 32 ^ $fiveMinutes);
            long $fifteenMinutes = this.getFifteenMinutes();
            result = result * 59 + (int)($fifteenMinutes >>> 32 ^ $fifteenMinutes);
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Load(oneMinute=" + this.getOneMinute() + ", fiveMinutes=" + this.getFiveMinutes() + ", fifteenMinutes=" + this.getFifteenMinutes() + ")";
        }

        @Generated
        public Load(long oneMinute, long fiveMinutes, long fifteenMinutes) {
            this.oneMinute = oneMinute;
            this.fiveMinutes = fiveMinutes;
            this.fifteenMinutes = fifteenMinutes;
        }

        @Generated
        protected Load() {
        }

        @Generated
        public static class LoadBuilder {
            @Generated
            private long oneMinute;
            @Generated
            private long fiveMinutes;
            @Generated
            private long fifteenMinutes;

            @Generated
            LoadBuilder() {
            }

            @Generated
            public LoadBuilder oneMinute(long oneMinute) {
                this.oneMinute = oneMinute;
                return this;
            }

            @Generated
            public LoadBuilder fiveMinutes(long fiveMinutes) {
                this.fiveMinutes = fiveMinutes;
                return this;
            }

            @Generated
            public LoadBuilder fifteenMinutes(long fifteenMinutes) {
                this.fifteenMinutes = fifteenMinutes;
                return this;
            }

            @Generated
            public Load build() {
                return new Load(this.oneMinute, this.fiveMinutes, this.fifteenMinutes);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Load.LoadBuilder(oneMinute=" + this.oneMinute + ", fiveMinutes=" + this.fiveMinutes + ", fifteenMinutes=" + this.fifteenMinutes + ")";
            }
        }
    }

    static class NetworkInterfaceInfo {
        private static final long UNKNOWN = -1L;
        private long timeStamp;
        private long enabled;
        private long incomingBytes;
        private long incomingPacketErrors;
        private long incomingPackets;
        private long outgoingBytes;
        private long outgoingPacketErrors;
        private long outgoingPackets;
        private long pluggedIn;
        private long speed;
        @NonNull
        private String duplex;
        @NonNull
        private String ipv4;
        @NonNull
        private String ipv4DefaultGateway;
        @NonNull
        private String ipv6;
        @NonNull
        private String ipv6DefaultGateway;
        @NonNull
        private String macAddress;
        private long mtu;
        @NonNull
        private String operational;

        @Generated
        private static long $default$enabled() {
            return -1L;
        }

        @Generated
        private static long $default$pluggedIn() {
            return -1L;
        }

        @Generated
        public static NetworkInterfaceInfoBuilder builder() {
            return new NetworkInterfaceInfoBuilder();
        }

        @Generated
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Generated
        public long getEnabled() {
            return this.enabled;
        }

        @Generated
        public long getIncomingBytes() {
            return this.incomingBytes;
        }

        @Generated
        public long getIncomingPacketErrors() {
            return this.incomingPacketErrors;
        }

        @Generated
        public long getIncomingPackets() {
            return this.incomingPackets;
        }

        @Generated
        public long getOutgoingBytes() {
            return this.outgoingBytes;
        }

        @Generated
        public long getOutgoingPacketErrors() {
            return this.outgoingPacketErrors;
        }

        @Generated
        public long getOutgoingPackets() {
            return this.outgoingPackets;
        }

        @Generated
        public long getPluggedIn() {
            return this.pluggedIn;
        }

        @Generated
        public long getSpeed() {
            return this.speed;
        }

        @NonNull
        @Generated
        public String getDuplex() {
            return this.duplex;
        }

        @NonNull
        @Generated
        public String getIpv4() {
            return this.ipv4;
        }

        @NonNull
        @Generated
        public String getIpv4DefaultGateway() {
            return this.ipv4DefaultGateway;
        }

        @NonNull
        @Generated
        public String getIpv6() {
            return this.ipv6;
        }

        @NonNull
        @Generated
        public String getIpv6DefaultGateway() {
            return this.ipv6DefaultGateway;
        }

        @NonNull
        @Generated
        public String getMacAddress() {
            return this.macAddress;
        }

        @Generated
        public long getMtu() {
            return this.mtu;
        }

        @NonNull
        @Generated
        public String getOperational() {
            return this.operational;
        }

        @Generated
        public void setTimeStamp(long timeStamp) {
            this.timeStamp = timeStamp;
        }

        @Generated
        public void setEnabled(long enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setIncomingBytes(long incomingBytes) {
            this.incomingBytes = incomingBytes;
        }

        @Generated
        public void setIncomingPacketErrors(long incomingPacketErrors) {
            this.incomingPacketErrors = incomingPacketErrors;
        }

        @Generated
        public void setIncomingPackets(long incomingPackets) {
            this.incomingPackets = incomingPackets;
        }

        @Generated
        public void setOutgoingBytes(long outgoingBytes) {
            this.outgoingBytes = outgoingBytes;
        }

        @Generated
        public void setOutgoingPacketErrors(long outgoingPacketErrors) {
            this.outgoingPacketErrors = outgoingPacketErrors;
        }

        @Generated
        public void setOutgoingPackets(long outgoingPackets) {
            this.outgoingPackets = outgoingPackets;
        }

        @Generated
        public void setPluggedIn(long pluggedIn) {
            this.pluggedIn = pluggedIn;
        }

        @Generated
        public void setSpeed(long speed) {
            this.speed = speed;
        }

        @Generated
        public void setDuplex(@NonNull String duplex) {
            if (duplex == null) {
                throw new NullPointerException("duplex is marked non-null but is null");
            }
            this.duplex = duplex;
        }

        @Generated
        public void setIpv4(@NonNull String ipv4) {
            if (ipv4 == null) {
                throw new NullPointerException("ipv4 is marked non-null but is null");
            }
            this.ipv4 = ipv4;
        }

        @Generated
        public void setIpv4DefaultGateway(@NonNull String ipv4DefaultGateway) {
            if (ipv4DefaultGateway == null) {
                throw new NullPointerException("ipv4DefaultGateway is marked non-null but is null");
            }
            this.ipv4DefaultGateway = ipv4DefaultGateway;
        }

        @Generated
        public void setIpv6(@NonNull String ipv6) {
            if (ipv6 == null) {
                throw new NullPointerException("ipv6 is marked non-null but is null");
            }
            this.ipv6 = ipv6;
        }

        @Generated
        public void setIpv6DefaultGateway(@NonNull String ipv6DefaultGateway) {
            if (ipv6DefaultGateway == null) {
                throw new NullPointerException("ipv6DefaultGateway is marked non-null but is null");
            }
            this.ipv6DefaultGateway = ipv6DefaultGateway;
        }

        @Generated
        public void setMacAddress(@NonNull String macAddress) {
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            this.macAddress = macAddress;
        }

        @Generated
        public void setMtu(long mtu) {
            this.mtu = mtu;
        }

        @Generated
        public void setOperational(@NonNull String operational) {
            if (operational == null) {
                throw new NullPointerException("operational is marked non-null but is null");
            }
            this.operational = operational;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NetworkInterfaceInfo)) {
                return false;
            }
            NetworkInterfaceInfo other = (NetworkInterfaceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimeStamp() != other.getTimeStamp()) {
                return false;
            }
            if (this.getEnabled() != other.getEnabled()) {
                return false;
            }
            if (this.getIncomingBytes() != other.getIncomingBytes()) {
                return false;
            }
            if (this.getIncomingPacketErrors() != other.getIncomingPacketErrors()) {
                return false;
            }
            if (this.getIncomingPackets() != other.getIncomingPackets()) {
                return false;
            }
            if (this.getOutgoingBytes() != other.getOutgoingBytes()) {
                return false;
            }
            if (this.getOutgoingPacketErrors() != other.getOutgoingPacketErrors()) {
                return false;
            }
            if (this.getOutgoingPackets() != other.getOutgoingPackets()) {
                return false;
            }
            if (this.getPluggedIn() != other.getPluggedIn()) {
                return false;
            }
            if (this.getSpeed() != other.getSpeed()) {
                return false;
            }
            if (this.getMtu() != other.getMtu()) {
                return false;
            }
            String this$duplex = this.getDuplex();
            String other$duplex = other.getDuplex();
            if (this$duplex == null ? other$duplex != null : !this$duplex.equals(other$duplex)) {
                return false;
            }
            String this$ipv4 = this.getIpv4();
            String other$ipv4 = other.getIpv4();
            if (this$ipv4 == null ? other$ipv4 != null : !this$ipv4.equals(other$ipv4)) {
                return false;
            }
            String this$ipv4DefaultGateway = this.getIpv4DefaultGateway();
            String other$ipv4DefaultGateway = other.getIpv4DefaultGateway();
            if (this$ipv4DefaultGateway == null ? other$ipv4DefaultGateway != null : !this$ipv4DefaultGateway.equals(other$ipv4DefaultGateway)) {
                return false;
            }
            String this$ipv6 = this.getIpv6();
            String other$ipv6 = other.getIpv6();
            if (this$ipv6 == null ? other$ipv6 != null : !this$ipv6.equals(other$ipv6)) {
                return false;
            }
            String this$ipv6DefaultGateway = this.getIpv6DefaultGateway();
            String other$ipv6DefaultGateway = other.getIpv6DefaultGateway();
            if (this$ipv6DefaultGateway == null ? other$ipv6DefaultGateway != null : !this$ipv6DefaultGateway.equals(other$ipv6DefaultGateway)) {
                return false;
            }
            String this$macAddress = this.getMacAddress();
            String other$macAddress = other.getMacAddress();
            if (this$macAddress == null ? other$macAddress != null : !this$macAddress.equals(other$macAddress)) {
                return false;
            }
            String this$operational = this.getOperational();
            String other$operational = other.getOperational();
            return !(this$operational == null ? other$operational != null : !this$operational.equals(other$operational));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NetworkInterfaceInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timeStamp = this.getTimeStamp();
            result = result * 59 + (int)($timeStamp >>> 32 ^ $timeStamp);
            long $enabled = this.getEnabled();
            result = result * 59 + (int)($enabled >>> 32 ^ $enabled);
            long $incomingBytes = this.getIncomingBytes();
            result = result * 59 + (int)($incomingBytes >>> 32 ^ $incomingBytes);
            long $incomingPacketErrors = this.getIncomingPacketErrors();
            result = result * 59 + (int)($incomingPacketErrors >>> 32 ^ $incomingPacketErrors);
            long $incomingPackets = this.getIncomingPackets();
            result = result * 59 + (int)($incomingPackets >>> 32 ^ $incomingPackets);
            long $outgoingBytes = this.getOutgoingBytes();
            result = result * 59 + (int)($outgoingBytes >>> 32 ^ $outgoingBytes);
            long $outgoingPacketErrors = this.getOutgoingPacketErrors();
            result = result * 59 + (int)($outgoingPacketErrors >>> 32 ^ $outgoingPacketErrors);
            long $outgoingPackets = this.getOutgoingPackets();
            result = result * 59 + (int)($outgoingPackets >>> 32 ^ $outgoingPackets);
            long $pluggedIn = this.getPluggedIn();
            result = result * 59 + (int)($pluggedIn >>> 32 ^ $pluggedIn);
            long $speed = this.getSpeed();
            result = result * 59 + (int)($speed >>> 32 ^ $speed);
            long $mtu = this.getMtu();
            result = result * 59 + (int)($mtu >>> 32 ^ $mtu);
            String $duplex = this.getDuplex();
            result = result * 59 + ($duplex == null ? 43 : $duplex.hashCode());
            String $ipv4 = this.getIpv4();
            result = result * 59 + ($ipv4 == null ? 43 : $ipv4.hashCode());
            String $ipv4DefaultGateway = this.getIpv4DefaultGateway();
            result = result * 59 + ($ipv4DefaultGateway == null ? 43 : $ipv4DefaultGateway.hashCode());
            String $ipv6 = this.getIpv6();
            result = result * 59 + ($ipv6 == null ? 43 : $ipv6.hashCode());
            String $ipv6DefaultGateway = this.getIpv6DefaultGateway();
            result = result * 59 + ($ipv6DefaultGateway == null ? 43 : $ipv6DefaultGateway.hashCode());
            String $macAddress = this.getMacAddress();
            result = result * 59 + ($macAddress == null ? 43 : $macAddress.hashCode());
            String $operational = this.getOperational();
            result = result * 59 + ($operational == null ? 43 : $operational.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.NetworkInterfaceInfo(timeStamp=" + this.getTimeStamp() + ", enabled=" + this.getEnabled() + ", incomingBytes=" + this.getIncomingBytes() + ", incomingPacketErrors=" + this.getIncomingPacketErrors() + ", incomingPackets=" + this.getIncomingPackets() + ", outgoingBytes=" + this.getOutgoingBytes() + ", outgoingPacketErrors=" + this.getOutgoingPacketErrors() + ", outgoingPackets=" + this.getOutgoingPackets() + ", pluggedIn=" + this.getPluggedIn() + ", speed=" + this.getSpeed() + ", duplex=" + this.getDuplex() + ", ipv4=" + this.getIpv4() + ", ipv4DefaultGateway=" + this.getIpv4DefaultGateway() + ", ipv6=" + this.getIpv6() + ", ipv6DefaultGateway=" + this.getIpv6DefaultGateway() + ", macAddress=" + this.getMacAddress() + ", mtu=" + this.getMtu() + ", operational=" + this.getOperational() + ")";
        }

        @Generated
        public NetworkInterfaceInfo(long timeStamp, long enabled, long incomingBytes, long incomingPacketErrors, long incomingPackets, long outgoingBytes, long outgoingPacketErrors, long outgoingPackets, long pluggedIn, long speed, @NonNull String duplex, @NonNull String ipv4, @NonNull String ipv4DefaultGateway, @NonNull String ipv6, @NonNull String ipv6DefaultGateway, @NonNull String macAddress, long mtu, @NonNull String operational) {
            if (duplex == null) {
                throw new NullPointerException("duplex is marked non-null but is null");
            }
            if (ipv4 == null) {
                throw new NullPointerException("ipv4 is marked non-null but is null");
            }
            if (ipv4DefaultGateway == null) {
                throw new NullPointerException("ipv4DefaultGateway is marked non-null but is null");
            }
            if (ipv6 == null) {
                throw new NullPointerException("ipv6 is marked non-null but is null");
            }
            if (ipv6DefaultGateway == null) {
                throw new NullPointerException("ipv6DefaultGateway is marked non-null but is null");
            }
            if (macAddress == null) {
                throw new NullPointerException("macAddress is marked non-null but is null");
            }
            if (operational == null) {
                throw new NullPointerException("operational is marked non-null but is null");
            }
            this.timeStamp = timeStamp;
            this.enabled = enabled;
            this.incomingBytes = incomingBytes;
            this.incomingPacketErrors = incomingPacketErrors;
            this.incomingPackets = incomingPackets;
            this.outgoingBytes = outgoingBytes;
            this.outgoingPacketErrors = outgoingPacketErrors;
            this.outgoingPackets = outgoingPackets;
            this.pluggedIn = pluggedIn;
            this.speed = speed;
            this.duplex = duplex;
            this.ipv4 = ipv4;
            this.ipv4DefaultGateway = ipv4DefaultGateway;
            this.ipv6 = ipv6;
            this.ipv6DefaultGateway = ipv6DefaultGateway;
            this.macAddress = macAddress;
            this.mtu = mtu;
            this.operational = operational;
        }

        @Generated
        protected NetworkInterfaceInfo() {
            this.enabled = NetworkInterfaceInfo.$default$enabled();
            this.pluggedIn = NetworkInterfaceInfo.$default$pluggedIn();
        }

        @Generated
        public static class NetworkInterfaceInfoBuilder {
            @Generated
            private long timeStamp;
            @Generated
            private boolean enabled$set;
            @Generated
            private long enabled$value;
            @Generated
            private long incomingBytes;
            @Generated
            private long incomingPacketErrors;
            @Generated
            private long incomingPackets;
            @Generated
            private long outgoingBytes;
            @Generated
            private long outgoingPacketErrors;
            @Generated
            private long outgoingPackets;
            @Generated
            private boolean pluggedIn$set;
            @Generated
            private long pluggedIn$value;
            @Generated
            private long speed;
            @Generated
            private String duplex;
            @Generated
            private String ipv4;
            @Generated
            private String ipv4DefaultGateway;
            @Generated
            private String ipv6;
            @Generated
            private String ipv6DefaultGateway;
            @Generated
            private String macAddress;
            @Generated
            private long mtu;
            @Generated
            private String operational;

            @Generated
            NetworkInterfaceInfoBuilder() {
            }

            @Generated
            public NetworkInterfaceInfoBuilder timeStamp(long timeStamp) {
                this.timeStamp = timeStamp;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder enabled(long enabled) {
                this.enabled$value = enabled;
                this.enabled$set = true;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder incomingBytes(long incomingBytes) {
                this.incomingBytes = incomingBytes;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder incomingPacketErrors(long incomingPacketErrors) {
                this.incomingPacketErrors = incomingPacketErrors;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder incomingPackets(long incomingPackets) {
                this.incomingPackets = incomingPackets;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder outgoingBytes(long outgoingBytes) {
                this.outgoingBytes = outgoingBytes;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder outgoingPacketErrors(long outgoingPacketErrors) {
                this.outgoingPacketErrors = outgoingPacketErrors;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder outgoingPackets(long outgoingPackets) {
                this.outgoingPackets = outgoingPackets;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder pluggedIn(long pluggedIn) {
                this.pluggedIn$value = pluggedIn;
                this.pluggedIn$set = true;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder speed(long speed) {
                this.speed = speed;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder duplex(@NonNull String duplex) {
                if (duplex == null) {
                    throw new NullPointerException("duplex is marked non-null but is null");
                }
                this.duplex = duplex;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipv4(@NonNull String ipv4) {
                if (ipv4 == null) {
                    throw new NullPointerException("ipv4 is marked non-null but is null");
                }
                this.ipv4 = ipv4;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipv4DefaultGateway(@NonNull String ipv4DefaultGateway) {
                if (ipv4DefaultGateway == null) {
                    throw new NullPointerException("ipv4DefaultGateway is marked non-null but is null");
                }
                this.ipv4DefaultGateway = ipv4DefaultGateway;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipv6(@NonNull String ipv6) {
                if (ipv6 == null) {
                    throw new NullPointerException("ipv6 is marked non-null but is null");
                }
                this.ipv6 = ipv6;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder ipv6DefaultGateway(@NonNull String ipv6DefaultGateway) {
                if (ipv6DefaultGateway == null) {
                    throw new NullPointerException("ipv6DefaultGateway is marked non-null but is null");
                }
                this.ipv6DefaultGateway = ipv6DefaultGateway;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder macAddress(@NonNull String macAddress) {
                if (macAddress == null) {
                    throw new NullPointerException("macAddress is marked non-null but is null");
                }
                this.macAddress = macAddress;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder mtu(long mtu) {
                this.mtu = mtu;
                return this;
            }

            @Generated
            public NetworkInterfaceInfoBuilder operational(@NonNull String operational) {
                if (operational == null) {
                    throw new NullPointerException("operational is marked non-null but is null");
                }
                this.operational = operational;
                return this;
            }

            @Generated
            public NetworkInterfaceInfo build() {
                long enabled$value = this.enabled$value;
                if (!this.enabled$set) {
                    enabled$value = NetworkInterfaceInfo.$default$enabled();
                }
                long pluggedIn$value = this.pluggedIn$value;
                if (!this.pluggedIn$set) {
                    pluggedIn$value = NetworkInterfaceInfo.$default$pluggedIn();
                }
                return new NetworkInterfaceInfo(this.timeStamp, enabled$value, this.incomingBytes, this.incomingPacketErrors, this.incomingPackets, this.outgoingBytes, this.outgoingPacketErrors, this.outgoingPackets, pluggedIn$value, this.speed, this.duplex, this.ipv4, this.ipv4DefaultGateway, this.ipv6, this.ipv6DefaultGateway, this.macAddress, this.mtu, this.operational);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.NetworkInterfaceInfo.NetworkInterfaceInfoBuilder(timeStamp=" + this.timeStamp + ", enabled$value=" + this.enabled$value + ", incomingBytes=" + this.incomingBytes + ", incomingPacketErrors=" + this.incomingPacketErrors + ", incomingPackets=" + this.incomingPackets + ", outgoingBytes=" + this.outgoingBytes + ", outgoingPacketErrors=" + this.outgoingPacketErrors + ", outgoingPackets=" + this.outgoingPackets + ", pluggedIn$value=" + this.pluggedIn$value + ", speed=" + this.speed + ", duplex=" + this.duplex + ", ipv4=" + this.ipv4 + ", ipv4DefaultGateway=" + this.ipv4DefaultGateway + ", ipv6=" + this.ipv6 + ", ipv6DefaultGateway=" + this.ipv6DefaultGateway + ", macAddress=" + this.macAddress + ", mtu=" + this.mtu + ", operational=" + this.operational + ")";
            }
        }
    }

    static class Partition {
        private String name;
        private String readsPerSec;
        private String writesPerSec;
        private String readKbPerSec;
        private String writeKbPerSec;
        private long ioUtilizationPct;
        private long avgServiceTime;
        private BigInteger timeStampInSeconds;

        @Generated
        public static PartitionBuilder builder() {
            return new PartitionBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getReadsPerSec() {
            return this.readsPerSec;
        }

        @Generated
        public String getWritesPerSec() {
            return this.writesPerSec;
        }

        @Generated
        public String getReadKbPerSec() {
            return this.readKbPerSec;
        }

        @Generated
        public String getWriteKbPerSec() {
            return this.writeKbPerSec;
        }

        @Generated
        public long getIoUtilizationPct() {
            return this.ioUtilizationPct;
        }

        @Generated
        public long getAvgServiceTime() {
            return this.avgServiceTime;
        }

        @Generated
        public BigInteger getTimeStampInSeconds() {
            return this.timeStampInSeconds;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setReadsPerSec(String readsPerSec) {
            this.readsPerSec = readsPerSec;
        }

        @Generated
        public void setWritesPerSec(String writesPerSec) {
            this.writesPerSec = writesPerSec;
        }

        @Generated
        public void setReadKbPerSec(String readKbPerSec) {
            this.readKbPerSec = readKbPerSec;
        }

        @Generated
        public void setWriteKbPerSec(String writeKbPerSec) {
            this.writeKbPerSec = writeKbPerSec;
        }

        @Generated
        public void setIoUtilizationPct(long ioUtilizationPct) {
            this.ioUtilizationPct = ioUtilizationPct;
        }

        @Generated
        public void setAvgServiceTime(long avgServiceTime) {
            this.avgServiceTime = avgServiceTime;
        }

        @Generated
        public void setTimeStampInSeconds(BigInteger timeStampInSeconds) {
            this.timeStampInSeconds = timeStampInSeconds;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition other = (Partition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getIoUtilizationPct() != other.getIoUtilizationPct()) {
                return false;
            }
            if (this.getAvgServiceTime() != other.getAvgServiceTime()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$readsPerSec = this.getReadsPerSec();
            String other$readsPerSec = other.getReadsPerSec();
            if (this$readsPerSec == null ? other$readsPerSec != null : !this$readsPerSec.equals(other$readsPerSec)) {
                return false;
            }
            String this$writesPerSec = this.getWritesPerSec();
            String other$writesPerSec = other.getWritesPerSec();
            if (this$writesPerSec == null ? other$writesPerSec != null : !this$writesPerSec.equals(other$writesPerSec)) {
                return false;
            }
            String this$readKbPerSec = this.getReadKbPerSec();
            String other$readKbPerSec = other.getReadKbPerSec();
            if (this$readKbPerSec == null ? other$readKbPerSec != null : !this$readKbPerSec.equals(other$readKbPerSec)) {
                return false;
            }
            String this$writeKbPerSec = this.getWriteKbPerSec();
            String other$writeKbPerSec = other.getWriteKbPerSec();
            if (this$writeKbPerSec == null ? other$writeKbPerSec != null : !this$writeKbPerSec.equals(other$writeKbPerSec)) {
                return false;
            }
            BigInteger this$timeStampInSeconds = this.getTimeStampInSeconds();
            BigInteger other$timeStampInSeconds = other.getTimeStampInSeconds();
            return !(this$timeStampInSeconds == null ? other$timeStampInSeconds != null : !((Object)this$timeStampInSeconds).equals(other$timeStampInSeconds));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Partition;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $ioUtilizationPct = this.getIoUtilizationPct();
            result = result * 59 + (int)($ioUtilizationPct >>> 32 ^ $ioUtilizationPct);
            long $avgServiceTime = this.getAvgServiceTime();
            result = result * 59 + (int)($avgServiceTime >>> 32 ^ $avgServiceTime);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $readsPerSec = this.getReadsPerSec();
            result = result * 59 + ($readsPerSec == null ? 43 : $readsPerSec.hashCode());
            String $writesPerSec = this.getWritesPerSec();
            result = result * 59 + ($writesPerSec == null ? 43 : $writesPerSec.hashCode());
            String $readKbPerSec = this.getReadKbPerSec();
            result = result * 59 + ($readKbPerSec == null ? 43 : $readKbPerSec.hashCode());
            String $writeKbPerSec = this.getWriteKbPerSec();
            result = result * 59 + ($writeKbPerSec == null ? 43 : $writeKbPerSec.hashCode());
            BigInteger $timeStampInSeconds = this.getTimeStampInSeconds();
            result = result * 59 + ($timeStampInSeconds == null ? 43 : ((Object)$timeStampInSeconds).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Partition(name=" + this.getName() + ", readsPerSec=" + this.getReadsPerSec() + ", writesPerSec=" + this.getWritesPerSec() + ", readKbPerSec=" + this.getReadKbPerSec() + ", writeKbPerSec=" + this.getWriteKbPerSec() + ", ioUtilizationPct=" + this.getIoUtilizationPct() + ", avgServiceTime=" + this.getAvgServiceTime() + ", timeStampInSeconds=" + String.valueOf(this.getTimeStampInSeconds()) + ")";
        }

        @Generated
        public Partition(String name, String readsPerSec, String writesPerSec, String readKbPerSec, String writeKbPerSec, long ioUtilizationPct, long avgServiceTime, BigInteger timeStampInSeconds) {
            this.name = name;
            this.readsPerSec = readsPerSec;
            this.writesPerSec = writesPerSec;
            this.readKbPerSec = readKbPerSec;
            this.writeKbPerSec = writeKbPerSec;
            this.ioUtilizationPct = ioUtilizationPct;
            this.avgServiceTime = avgServiceTime;
            this.timeStampInSeconds = timeStampInSeconds;
        }

        @Generated
        protected Partition() {
        }

        @Generated
        public static class PartitionBuilder {
            @Generated
            private String name;
            @Generated
            private String readsPerSec;
            @Generated
            private String writesPerSec;
            @Generated
            private String readKbPerSec;
            @Generated
            private String writeKbPerSec;
            @Generated
            private long ioUtilizationPct;
            @Generated
            private long avgServiceTime;
            @Generated
            private BigInteger timeStampInSeconds;

            @Generated
            PartitionBuilder() {
            }

            @Generated
            public PartitionBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public PartitionBuilder readsPerSec(String readsPerSec) {
                this.readsPerSec = readsPerSec;
                return this;
            }

            @Generated
            public PartitionBuilder writesPerSec(String writesPerSec) {
                this.writesPerSec = writesPerSec;
                return this;
            }

            @Generated
            public PartitionBuilder readKbPerSec(String readKbPerSec) {
                this.readKbPerSec = readKbPerSec;
                return this;
            }

            @Generated
            public PartitionBuilder writeKbPerSec(String writeKbPerSec) {
                this.writeKbPerSec = writeKbPerSec;
                return this;
            }

            @Generated
            public PartitionBuilder ioUtilizationPct(long ioUtilizationPct) {
                this.ioUtilizationPct = ioUtilizationPct;
                return this;
            }

            @Generated
            public PartitionBuilder avgServiceTime(long avgServiceTime) {
                this.avgServiceTime = avgServiceTime;
                return this;
            }

            @Generated
            public PartitionBuilder timeStampInSeconds(BigInteger timeStampInSeconds) {
                this.timeStampInSeconds = timeStampInSeconds;
                return this;
            }

            @Generated
            public Partition build() {
                return new Partition(this.name, this.readsPerSec, this.writesPerSec, this.readKbPerSec, this.writeKbPerSec, this.ioUtilizationPct, this.avgServiceTime, this.timeStampInSeconds);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Partition.PartitionBuilder(name=" + this.name + ", readsPerSec=" + this.readsPerSec + ", writesPerSec=" + this.writesPerSec + ", readKbPerSec=" + this.readKbPerSec + ", writeKbPerSec=" + this.writeKbPerSec + ", ioUtilizationPct=" + this.ioUtilizationPct + ", avgServiceTime=" + this.avgServiceTime + ", timeStampInSeconds=" + String.valueOf(this.timeStampInSeconds) + ")";
            }
        }
    }

    static class Volume {
        private String name;
        private String totalSpace;
        private String usedSpace;

        @Generated
        public static VolumeBuilder builder() {
            return new VolumeBuilder();
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getTotalSpace() {
            return this.totalSpace;
        }

        @Generated
        public String getUsedSpace() {
            return this.usedSpace;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setTotalSpace(String totalSpace) {
            this.totalSpace = totalSpace;
        }

        @Generated
        public void setUsedSpace(String usedSpace) {
            this.usedSpace = usedSpace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Volume)) {
                return false;
            }
            Volume other = (Volume)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$totalSpace = this.getTotalSpace();
            String other$totalSpace = other.getTotalSpace();
            if (this$totalSpace == null ? other$totalSpace != null : !this$totalSpace.equals(other$totalSpace)) {
                return false;
            }
            String this$usedSpace = this.getUsedSpace();
            String other$usedSpace = other.getUsedSpace();
            return !(this$usedSpace == null ? other$usedSpace != null : !this$usedSpace.equals(other$usedSpace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Volume;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $totalSpace = this.getTotalSpace();
            result = result * 59 + ($totalSpace == null ? 43 : $totalSpace.hashCode());
            String $usedSpace = this.getUsedSpace();
            result = result * 59 + ($usedSpace == null ? 43 : $usedSpace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Volume(name=" + this.getName() + ", totalSpace=" + this.getTotalSpace() + ", usedSpace=" + this.getUsedSpace() + ")";
        }

        @Generated
        public Volume(String name, String totalSpace, String usedSpace) {
            this.name = name;
            this.totalSpace = totalSpace;
            this.usedSpace = usedSpace;
        }

        @Generated
        protected Volume() {
        }

        @Generated
        public static class VolumeBuilder {
            @Generated
            private String name;
            @Generated
            private String totalSpace;
            @Generated
            private String usedSpace;

            @Generated
            VolumeBuilder() {
            }

            @Generated
            public VolumeBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public VolumeBuilder totalSpace(String totalSpace) {
                this.totalSpace = totalSpace;
                return this;
            }

            @Generated
            public VolumeBuilder usedSpace(String usedSpace) {
                this.usedSpace = usedSpace;
                return this;
            }

            @Generated
            public Volume build() {
                return new Volume(this.name, this.totalSpace, this.usedSpace);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Volume.VolumeBuilder(name=" + this.name + ", totalSpace=" + this.totalSpace + ", usedSpace=" + this.usedSpace + ")";
            }
        }
    }

    static class Process {
        private int pid;
        private String name;
        private String commandLine;
        @NonNull
        private String memoryPercent;
        @NonNull
        private String cpuTime;
        private int effectiveGroupId;
        private String elapsedTime;
        @NonNull
        private String effectiveUser;
        @NonNull
        private String nice;
        private long threadCount;
        private int groupId;
        private int parentId;
        private long memoryUsedKb;
        @NonNull
        private String state;
        @NonNull
        private String realUser;
        @NonNull
        private String realGroup;
        private long virtualMemSizeKb;
        private String nameElapsedTimeCommandLine;

        @Generated
        public static ProcessBuilder builder() {
            return new ProcessBuilder();
        }

        @Generated
        public int getPid() {
            return this.pid;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getCommandLine() {
            return this.commandLine;
        }

        @NonNull
        @Generated
        public String getMemoryPercent() {
            return this.memoryPercent;
        }

        @NonNull
        @Generated
        public String getCpuTime() {
            return this.cpuTime;
        }

        @Generated
        public int getEffectiveGroupId() {
            return this.effectiveGroupId;
        }

        @Generated
        public String getElapsedTime() {
            return this.elapsedTime;
        }

        @NonNull
        @Generated
        public String getEffectiveUser() {
            return this.effectiveUser;
        }

        @NonNull
        @Generated
        public String getNice() {
            return this.nice;
        }

        @Generated
        public long getThreadCount() {
            return this.threadCount;
        }

        @Generated
        public int getGroupId() {
            return this.groupId;
        }

        @Generated
        public int getParentId() {
            return this.parentId;
        }

        @Generated
        public long getMemoryUsedKb() {
            return this.memoryUsedKb;
        }

        @NonNull
        @Generated
        public String getState() {
            return this.state;
        }

        @NonNull
        @Generated
        public String getRealUser() {
            return this.realUser;
        }

        @NonNull
        @Generated
        public String getRealGroup() {
            return this.realGroup;
        }

        @Generated
        public long getVirtualMemSizeKb() {
            return this.virtualMemSizeKb;
        }

        @Generated
        public String getNameElapsedTimeCommandLine() {
            return this.nameElapsedTimeCommandLine;
        }

        @Generated
        public void setPid(int pid) {
            this.pid = pid;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setCommandLine(String commandLine) {
            this.commandLine = commandLine;
        }

        @Generated
        public void setMemoryPercent(@NonNull String memoryPercent) {
            if (memoryPercent == null) {
                throw new NullPointerException("memoryPercent is marked non-null but is null");
            }
            this.memoryPercent = memoryPercent;
        }

        @Generated
        public void setCpuTime(@NonNull String cpuTime) {
            if (cpuTime == null) {
                throw new NullPointerException("cpuTime is marked non-null but is null");
            }
            this.cpuTime = cpuTime;
        }

        @Generated
        public void setEffectiveGroupId(int effectiveGroupId) {
            this.effectiveGroupId = effectiveGroupId;
        }

        @Generated
        public void setElapsedTime(String elapsedTime) {
            this.elapsedTime = elapsedTime;
        }

        @Generated
        public void setEffectiveUser(@NonNull String effectiveUser) {
            if (effectiveUser == null) {
                throw new NullPointerException("effectiveUser is marked non-null but is null");
            }
            this.effectiveUser = effectiveUser;
        }

        @Generated
        public void setNice(@NonNull String nice) {
            if (nice == null) {
                throw new NullPointerException("nice is marked non-null but is null");
            }
            this.nice = nice;
        }

        @Generated
        public void setThreadCount(long threadCount) {
            this.threadCount = threadCount;
        }

        @Generated
        public void setGroupId(int groupId) {
            this.groupId = groupId;
        }

        @Generated
        public void setParentId(int parentId) {
            this.parentId = parentId;
        }

        @Generated
        public void setMemoryUsedKb(long memoryUsedKb) {
            this.memoryUsedKb = memoryUsedKb;
        }

        @Generated
        public void setState(@NonNull String state) {
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            this.state = state;
        }

        @Generated
        public void setRealUser(@NonNull String realUser) {
            if (realUser == null) {
                throw new NullPointerException("realUser is marked non-null but is null");
            }
            this.realUser = realUser;
        }

        @Generated
        public void setRealGroup(@NonNull String realGroup) {
            if (realGroup == null) {
                throw new NullPointerException("realGroup is marked non-null but is null");
            }
            this.realGroup = realGroup;
        }

        @Generated
        public void setVirtualMemSizeKb(long virtualMemSizeKb) {
            this.virtualMemSizeKb = virtualMemSizeKb;
        }

        @Generated
        public void setNameElapsedTimeCommandLine(String nameElapsedTimeCommandLine) {
            this.nameElapsedTimeCommandLine = nameElapsedTimeCommandLine;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Process)) {
                return false;
            }
            Process other = (Process)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPid() != other.getPid()) {
                return false;
            }
            if (this.getEffectiveGroupId() != other.getEffectiveGroupId()) {
                return false;
            }
            if (this.getThreadCount() != other.getThreadCount()) {
                return false;
            }
            if (this.getGroupId() != other.getGroupId()) {
                return false;
            }
            if (this.getParentId() != other.getParentId()) {
                return false;
            }
            if (this.getMemoryUsedKb() != other.getMemoryUsedKb()) {
                return false;
            }
            if (this.getVirtualMemSizeKb() != other.getVirtualMemSizeKb()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$commandLine = this.getCommandLine();
            String other$commandLine = other.getCommandLine();
            if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
                return false;
            }
            String this$memoryPercent = this.getMemoryPercent();
            String other$memoryPercent = other.getMemoryPercent();
            if (this$memoryPercent == null ? other$memoryPercent != null : !this$memoryPercent.equals(other$memoryPercent)) {
                return false;
            }
            String this$cpuTime = this.getCpuTime();
            String other$cpuTime = other.getCpuTime();
            if (this$cpuTime == null ? other$cpuTime != null : !this$cpuTime.equals(other$cpuTime)) {
                return false;
            }
            String this$elapsedTime = this.getElapsedTime();
            String other$elapsedTime = other.getElapsedTime();
            if (this$elapsedTime == null ? other$elapsedTime != null : !this$elapsedTime.equals(other$elapsedTime)) {
                return false;
            }
            String this$effectiveUser = this.getEffectiveUser();
            String other$effectiveUser = other.getEffectiveUser();
            if (this$effectiveUser == null ? other$effectiveUser != null : !this$effectiveUser.equals(other$effectiveUser)) {
                return false;
            }
            String this$nice = this.getNice();
            String other$nice = other.getNice();
            if (this$nice == null ? other$nice != null : !this$nice.equals(other$nice)) {
                return false;
            }
            String this$state = this.getState();
            String other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                return false;
            }
            String this$realUser = this.getRealUser();
            String other$realUser = other.getRealUser();
            if (this$realUser == null ? other$realUser != null : !this$realUser.equals(other$realUser)) {
                return false;
            }
            String this$realGroup = this.getRealGroup();
            String other$realGroup = other.getRealGroup();
            if (this$realGroup == null ? other$realGroup != null : !this$realGroup.equals(other$realGroup)) {
                return false;
            }
            String this$nameElapsedTimeCommandLine = this.getNameElapsedTimeCommandLine();
            String other$nameElapsedTimeCommandLine = other.getNameElapsedTimeCommandLine();
            return !(this$nameElapsedTimeCommandLine == null ? other$nameElapsedTimeCommandLine != null : !this$nameElapsedTimeCommandLine.equals(other$nameElapsedTimeCommandLine));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Process;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPid();
            result = result * 59 + this.getEffectiveGroupId();
            long $threadCount = this.getThreadCount();
            result = result * 59 + (int)($threadCount >>> 32 ^ $threadCount);
            result = result * 59 + this.getGroupId();
            result = result * 59 + this.getParentId();
            long $memoryUsedKb = this.getMemoryUsedKb();
            result = result * 59 + (int)($memoryUsedKb >>> 32 ^ $memoryUsedKb);
            long $virtualMemSizeKb = this.getVirtualMemSizeKb();
            result = result * 59 + (int)($virtualMemSizeKb >>> 32 ^ $virtualMemSizeKb);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $commandLine = this.getCommandLine();
            result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
            String $memoryPercent = this.getMemoryPercent();
            result = result * 59 + ($memoryPercent == null ? 43 : $memoryPercent.hashCode());
            String $cpuTime = this.getCpuTime();
            result = result * 59 + ($cpuTime == null ? 43 : $cpuTime.hashCode());
            String $elapsedTime = this.getElapsedTime();
            result = result * 59 + ($elapsedTime == null ? 43 : $elapsedTime.hashCode());
            String $effectiveUser = this.getEffectiveUser();
            result = result * 59 + ($effectiveUser == null ? 43 : $effectiveUser.hashCode());
            String $nice = this.getNice();
            result = result * 59 + ($nice == null ? 43 : $nice.hashCode());
            String $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            String $realUser = this.getRealUser();
            result = result * 59 + ($realUser == null ? 43 : $realUser.hashCode());
            String $realGroup = this.getRealGroup();
            result = result * 59 + ($realGroup == null ? 43 : $realGroup.hashCode());
            String $nameElapsedTimeCommandLine = this.getNameElapsedTimeCommandLine();
            result = result * 59 + ($nameElapsedTimeCommandLine == null ? 43 : $nameElapsedTimeCommandLine.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Process(pid=" + this.getPid() + ", name=" + this.getName() + ", commandLine=" + this.getCommandLine() + ", memoryPercent=" + this.getMemoryPercent() + ", cpuTime=" + this.getCpuTime() + ", effectiveGroupId=" + this.getEffectiveGroupId() + ", elapsedTime=" + this.getElapsedTime() + ", effectiveUser=" + this.getEffectiveUser() + ", nice=" + this.getNice() + ", threadCount=" + this.getThreadCount() + ", groupId=" + this.getGroupId() + ", parentId=" + this.getParentId() + ", memoryUsedKb=" + this.getMemoryUsedKb() + ", state=" + this.getState() + ", realUser=" + this.getRealUser() + ", realGroup=" + this.getRealGroup() + ", virtualMemSizeKb=" + this.getVirtualMemSizeKb() + ", nameElapsedTimeCommandLine=" + this.getNameElapsedTimeCommandLine() + ")";
        }

        @Generated
        public Process(int pid, String name, String commandLine, @NonNull String memoryPercent, @NonNull String cpuTime, int effectiveGroupId, String elapsedTime, @NonNull String effectiveUser, @NonNull String nice, long threadCount, int groupId, int parentId, long memoryUsedKb, @NonNull String state, @NonNull String realUser, @NonNull String realGroup, long virtualMemSizeKb, String nameElapsedTimeCommandLine) {
            if (memoryPercent == null) {
                throw new NullPointerException("memoryPercent is marked non-null but is null");
            }
            if (cpuTime == null) {
                throw new NullPointerException("cpuTime is marked non-null but is null");
            }
            if (effectiveUser == null) {
                throw new NullPointerException("effectiveUser is marked non-null but is null");
            }
            if (nice == null) {
                throw new NullPointerException("nice is marked non-null but is null");
            }
            if (state == null) {
                throw new NullPointerException("state is marked non-null but is null");
            }
            if (realUser == null) {
                throw new NullPointerException("realUser is marked non-null but is null");
            }
            if (realGroup == null) {
                throw new NullPointerException("realGroup is marked non-null but is null");
            }
            this.pid = pid;
            this.name = name;
            this.commandLine = commandLine;
            this.memoryPercent = memoryPercent;
            this.cpuTime = cpuTime;
            this.effectiveGroupId = effectiveGroupId;
            this.elapsedTime = elapsedTime;
            this.effectiveUser = effectiveUser;
            this.nice = nice;
            this.threadCount = threadCount;
            this.groupId = groupId;
            this.parentId = parentId;
            this.memoryUsedKb = memoryUsedKb;
            this.state = state;
            this.realUser = realUser;
            this.realGroup = realGroup;
            this.virtualMemSizeKb = virtualMemSizeKb;
            this.nameElapsedTimeCommandLine = nameElapsedTimeCommandLine;
        }

        @Generated
        protected Process() {
        }

        @Generated
        public static class ProcessBuilder {
            @Generated
            private int pid;
            @Generated
            private String name;
            @Generated
            private String commandLine;
            @Generated
            private String memoryPercent;
            @Generated
            private String cpuTime;
            @Generated
            private int effectiveGroupId;
            @Generated
            private String elapsedTime;
            @Generated
            private String effectiveUser;
            @Generated
            private String nice;
            @Generated
            private long threadCount;
            @Generated
            private int groupId;
            @Generated
            private int parentId;
            @Generated
            private long memoryUsedKb;
            @Generated
            private String state;
            @Generated
            private String realUser;
            @Generated
            private String realGroup;
            @Generated
            private long virtualMemSizeKb;
            @Generated
            private String nameElapsedTimeCommandLine;

            @Generated
            ProcessBuilder() {
            }

            @Generated
            public ProcessBuilder pid(int pid) {
                this.pid = pid;
                return this;
            }

            @Generated
            public ProcessBuilder name(String name) {
                this.name = name;
                return this;
            }

            @Generated
            public ProcessBuilder commandLine(String commandLine) {
                this.commandLine = commandLine;
                return this;
            }

            @Generated
            public ProcessBuilder memoryPercent(@NonNull String memoryPercent) {
                if (memoryPercent == null) {
                    throw new NullPointerException("memoryPercent is marked non-null but is null");
                }
                this.memoryPercent = memoryPercent;
                return this;
            }

            @Generated
            public ProcessBuilder cpuTime(@NonNull String cpuTime) {
                if (cpuTime == null) {
                    throw new NullPointerException("cpuTime is marked non-null but is null");
                }
                this.cpuTime = cpuTime;
                return this;
            }

            @Generated
            public ProcessBuilder effectiveGroupId(int effectiveGroupId) {
                this.effectiveGroupId = effectiveGroupId;
                return this;
            }

            @Generated
            public ProcessBuilder elapsedTime(String elapsedTime) {
                this.elapsedTime = elapsedTime;
                return this;
            }

            @Generated
            public ProcessBuilder effectiveUser(@NonNull String effectiveUser) {
                if (effectiveUser == null) {
                    throw new NullPointerException("effectiveUser is marked non-null but is null");
                }
                this.effectiveUser = effectiveUser;
                return this;
            }

            @Generated
            public ProcessBuilder nice(@NonNull String nice) {
                if (nice == null) {
                    throw new NullPointerException("nice is marked non-null but is null");
                }
                this.nice = nice;
                return this;
            }

            @Generated
            public ProcessBuilder threadCount(long threadCount) {
                this.threadCount = threadCount;
                return this;
            }

            @Generated
            public ProcessBuilder groupId(int groupId) {
                this.groupId = groupId;
                return this;
            }

            @Generated
            public ProcessBuilder parentId(int parentId) {
                this.parentId = parentId;
                return this;
            }

            @Generated
            public ProcessBuilder memoryUsedKb(long memoryUsedKb) {
                this.memoryUsedKb = memoryUsedKb;
                return this;
            }

            @Generated
            public ProcessBuilder state(@NonNull String state) {
                if (state == null) {
                    throw new NullPointerException("state is marked non-null but is null");
                }
                this.state = state;
                return this;
            }

            @Generated
            public ProcessBuilder realUser(@NonNull String realUser) {
                if (realUser == null) {
                    throw new NullPointerException("realUser is marked non-null but is null");
                }
                this.realUser = realUser;
                return this;
            }

            @Generated
            public ProcessBuilder realGroup(@NonNull String realGroup) {
                if (realGroup == null) {
                    throw new NullPointerException("realGroup is marked non-null but is null");
                }
                this.realGroup = realGroup;
                return this;
            }

            @Generated
            public ProcessBuilder virtualMemSizeKb(long virtualMemSizeKb) {
                this.virtualMemSizeKb = virtualMemSizeKb;
                return this;
            }

            @Generated
            public ProcessBuilder nameElapsedTimeCommandLine(String nameElapsedTimeCommandLine) {
                this.nameElapsedTimeCommandLine = nameElapsedTimeCommandLine;
                return this;
            }

            @Generated
            public Process build() {
                return new Process(this.pid, this.name, this.commandLine, this.memoryPercent, this.cpuTime, this.effectiveGroupId, this.elapsedTime, this.effectiveUser, this.nice, this.threadCount, this.groupId, this.parentId, this.memoryUsedKb, this.state, this.realUser, this.realGroup, this.virtualMemSizeKb, this.nameElapsedTimeCommandLine);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Process.ProcessBuilder(pid=" + this.pid + ", name=" + this.name + ", commandLine=" + this.commandLine + ", memoryPercent=" + this.memoryPercent + ", cpuTime=" + this.cpuTime + ", effectiveGroupId=" + this.effectiveGroupId + ", elapsedTime=" + this.elapsedTime + ", effectiveUser=" + this.effectiveUser + ", nice=" + this.nice + ", threadCount=" + this.threadCount + ", groupId=" + this.groupId + ", parentId=" + this.parentId + ", memoryUsedKb=" + this.memoryUsedKb + ", state=" + this.state + ", realUser=" + this.realUser + ", realGroup=" + this.realGroup + ", virtualMemSizeKb=" + this.virtualMemSizeKb + ", nameElapsedTimeCommandLine=" + this.nameElapsedTimeCommandLine + ")";
            }
        }
    }

    static class ProcessRawData {
        @NonNull
        private final ProcessClassIdCreator.ProcessClass procClass;
        @NonNull
        private final Process process;

        @NonNull
        @Generated
        public ProcessClassIdCreator.ProcessClass getProcClass() {
            return this.procClass;
        }

        @NonNull
        @Generated
        public Process getProcess() {
            return this.process;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessRawData)) {
                return false;
            }
            ProcessRawData other = (ProcessRawData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProcessClassIdCreator.ProcessClass this$procClass = this.getProcClass();
            ProcessClassIdCreator.ProcessClass other$procClass = other.getProcClass();
            if (this$procClass == null ? other$procClass != null : !((Object)this$procClass).equals(other$procClass)) {
                return false;
            }
            Process this$process = this.getProcess();
            Process other$process = other.getProcess();
            return !(this$process == null ? other$process != null : !((Object)this$process).equals(other$process));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProcessRawData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProcessClassIdCreator.ProcessClass $procClass = this.getProcClass();
            result = result * 59 + ($procClass == null ? 43 : ((Object)$procClass).hashCode());
            Process $process = this.getProcess();
            result = result * 59 + ($process == null ? 43 : ((Object)$process).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.ProcessRawData(procClass=" + String.valueOf(this.getProcClass()) + ", process=" + String.valueOf(this.getProcess()) + ")";
        }

        @Generated
        public ProcessRawData(@NonNull ProcessClassIdCreator.ProcessClass procClass, @NonNull Process process) {
            if (procClass == null) {
                throw new NullPointerException("procClass is marked non-null but is null");
            }
            if (process == null) {
                throw new NullPointerException("process is marked non-null but is null");
            }
            this.procClass = procClass;
            this.process = process;
        }
    }

    static class CpuPerf {
        @NonNull
        private String id;
        private long userTicks;
        private long systemTicks;
        private long idleTicks;
        private long stolenTicks;
        private long waitTicks;
        private long totalTicks;

        @Generated
        public static CpuPerfBuilder builder() {
            return new CpuPerfBuilder();
        }

        @NonNull
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public long getUserTicks() {
            return this.userTicks;
        }

        @Generated
        public long getSystemTicks() {
            return this.systemTicks;
        }

        @Generated
        public long getIdleTicks() {
            return this.idleTicks;
        }

        @Generated
        public long getStolenTicks() {
            return this.stolenTicks;
        }

        @Generated
        public long getWaitTicks() {
            return this.waitTicks;
        }

        @Generated
        public long getTotalTicks() {
            return this.totalTicks;
        }

        @Generated
        public void setId(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
        }

        @Generated
        public void setUserTicks(long userTicks) {
            this.userTicks = userTicks;
        }

        @Generated
        public void setSystemTicks(long systemTicks) {
            this.systemTicks = systemTicks;
        }

        @Generated
        public void setIdleTicks(long idleTicks) {
            this.idleTicks = idleTicks;
        }

        @Generated
        public void setStolenTicks(long stolenTicks) {
            this.stolenTicks = stolenTicks;
        }

        @Generated
        public void setWaitTicks(long waitTicks) {
            this.waitTicks = waitTicks;
        }

        @Generated
        public void setTotalTicks(long totalTicks) {
            this.totalTicks = totalTicks;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CpuPerf)) {
                return false;
            }
            CpuPerf other = (CpuPerf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getUserTicks() != other.getUserTicks()) {
                return false;
            }
            if (this.getSystemTicks() != other.getSystemTicks()) {
                return false;
            }
            if (this.getIdleTicks() != other.getIdleTicks()) {
                return false;
            }
            if (this.getStolenTicks() != other.getStolenTicks()) {
                return false;
            }
            if (this.getWaitTicks() != other.getWaitTicks()) {
                return false;
            }
            if (this.getTotalTicks() != other.getTotalTicks()) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CpuPerf;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $userTicks = this.getUserTicks();
            result = result * 59 + (int)($userTicks >>> 32 ^ $userTicks);
            long $systemTicks = this.getSystemTicks();
            result = result * 59 + (int)($systemTicks >>> 32 ^ $systemTicks);
            long $idleTicks = this.getIdleTicks();
            result = result * 59 + (int)($idleTicks >>> 32 ^ $idleTicks);
            long $stolenTicks = this.getStolenTicks();
            result = result * 59 + (int)($stolenTicks >>> 32 ^ $stolenTicks);
            long $waitTicks = this.getWaitTicks();
            result = result * 59 + (int)($waitTicks >>> 32 ^ $waitTicks);
            long $totalTicks = this.getTotalTicks();
            result = result * 59 + (int)($totalTicks >>> 32 ^ $totalTicks);
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.CpuPerf(id=" + this.getId() + ", userTicks=" + this.getUserTicks() + ", systemTicks=" + this.getSystemTicks() + ", idleTicks=" + this.getIdleTicks() + ", stolenTicks=" + this.getStolenTicks() + ", waitTicks=" + this.getWaitTicks() + ", totalTicks=" + this.getTotalTicks() + ")";
        }

        @Generated
        public CpuPerf(@NonNull String id, long userTicks, long systemTicks, long idleTicks, long stolenTicks, long waitTicks, long totalTicks) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            this.userTicks = userTicks;
            this.systemTicks = systemTicks;
            this.idleTicks = idleTicks;
            this.stolenTicks = stolenTicks;
            this.waitTicks = waitTicks;
            this.totalTicks = totalTicks;
        }

        @Generated
        protected CpuPerf() {
        }

        @Generated
        public static class CpuPerfBuilder {
            @Generated
            private String id;
            @Generated
            private long userTicks;
            @Generated
            private long systemTicks;
            @Generated
            private long idleTicks;
            @Generated
            private long stolenTicks;
            @Generated
            private long waitTicks;
            @Generated
            private long totalTicks;

            @Generated
            CpuPerfBuilder() {
            }

            @Generated
            public CpuPerfBuilder id(@NonNull String id) {
                if (id == null) {
                    throw new NullPointerException("id is marked non-null but is null");
                }
                this.id = id;
                return this;
            }

            @Generated
            public CpuPerfBuilder userTicks(long userTicks) {
                this.userTicks = userTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder systemTicks(long systemTicks) {
                this.systemTicks = systemTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder idleTicks(long idleTicks) {
                this.idleTicks = idleTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder stolenTicks(long stolenTicks) {
                this.stolenTicks = stolenTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder waitTicks(long waitTicks) {
                this.waitTicks = waitTicks;
                return this;
            }

            @Generated
            public CpuPerfBuilder totalTicks(long totalTicks) {
                this.totalTicks = totalTicks;
                return this;
            }

            @Generated
            public CpuPerf build() {
                return new CpuPerf(this.id, this.userTicks, this.systemTicks, this.idleTicks, this.stolenTicks, this.waitTicks, this.totalTicks);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.CpuPerf.CpuPerfBuilder(id=" + this.id + ", userTicks=" + this.userTicks + ", systemTicks=" + this.systemTicks + ", idleTicks=" + this.idleTicks + ", stolenTicks=" + this.stolenTicks + ", waitTicks=" + this.waitTicks + ", totalTicks=" + this.totalTicks + ")";
            }
        }
    }

    static class Cpu {
        private String processorId;
        private String chipId;
        private String coreId;
        @NonNull
        private String vendor;
        @NonNull
        private String model;
        @NonNull
        private String implementation;
        private int numCores;
        private int numLogicalProcessors;
        private long currentSpeedHz;

        @Generated
        public static CpuBuilder builder() {
            return new CpuBuilder();
        }

        @Generated
        public String getProcessorId() {
            return this.processorId;
        }

        @Generated
        public String getChipId() {
            return this.chipId;
        }

        @Generated
        public String getCoreId() {
            return this.coreId;
        }

        @NonNull
        @Generated
        public String getVendor() {
            return this.vendor;
        }

        @NonNull
        @Generated
        public String getModel() {
            return this.model;
        }

        @NonNull
        @Generated
        public String getImplementation() {
            return this.implementation;
        }

        @Generated
        public int getNumCores() {
            return this.numCores;
        }

        @Generated
        public int getNumLogicalProcessors() {
            return this.numLogicalProcessors;
        }

        @Generated
        public long getCurrentSpeedHz() {
            return this.currentSpeedHz;
        }

        @Generated
        public void setProcessorId(String processorId) {
            this.processorId = processorId;
        }

        @Generated
        public void setChipId(String chipId) {
            this.chipId = chipId;
        }

        @Generated
        public void setCoreId(String coreId) {
            this.coreId = coreId;
        }

        @Generated
        public void setVendor(@NonNull String vendor) {
            if (vendor == null) {
                throw new NullPointerException("vendor is marked non-null but is null");
            }
            this.vendor = vendor;
        }

        @Generated
        public void setModel(@NonNull String model) {
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            this.model = model;
        }

        @Generated
        public void setImplementation(@NonNull String implementation) {
            if (implementation == null) {
                throw new NullPointerException("implementation is marked non-null but is null");
            }
            this.implementation = implementation;
        }

        @Generated
        public void setNumCores(int numCores) {
            this.numCores = numCores;
        }

        @Generated
        public void setNumLogicalProcessors(int numLogicalProcessors) {
            this.numLogicalProcessors = numLogicalProcessors;
        }

        @Generated
        public void setCurrentSpeedHz(long currentSpeedHz) {
            this.currentSpeedHz = currentSpeedHz;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cpu)) {
                return false;
            }
            Cpu other = (Cpu)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNumCores() != other.getNumCores()) {
                return false;
            }
            if (this.getNumLogicalProcessors() != other.getNumLogicalProcessors()) {
                return false;
            }
            if (this.getCurrentSpeedHz() != other.getCurrentSpeedHz()) {
                return false;
            }
            String this$processorId = this.getProcessorId();
            String other$processorId = other.getProcessorId();
            if (this$processorId == null ? other$processorId != null : !this$processorId.equals(other$processorId)) {
                return false;
            }
            String this$chipId = this.getChipId();
            String other$chipId = other.getChipId();
            if (this$chipId == null ? other$chipId != null : !this$chipId.equals(other$chipId)) {
                return false;
            }
            String this$coreId = this.getCoreId();
            String other$coreId = other.getCoreId();
            if (this$coreId == null ? other$coreId != null : !this$coreId.equals(other$coreId)) {
                return false;
            }
            String this$vendor = this.getVendor();
            String other$vendor = other.getVendor();
            if (this$vendor == null ? other$vendor != null : !this$vendor.equals(other$vendor)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            String this$implementation = this.getImplementation();
            String other$implementation = other.getImplementation();
            return !(this$implementation == null ? other$implementation != null : !this$implementation.equals(other$implementation));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cpu;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNumCores();
            result = result * 59 + this.getNumLogicalProcessors();
            long $currentSpeedHz = this.getCurrentSpeedHz();
            result = result * 59 + (int)($currentSpeedHz >>> 32 ^ $currentSpeedHz);
            String $processorId = this.getProcessorId();
            result = result * 59 + ($processorId == null ? 43 : $processorId.hashCode());
            String $chipId = this.getChipId();
            result = result * 59 + ($chipId == null ? 43 : $chipId.hashCode());
            String $coreId = this.getCoreId();
            result = result * 59 + ($coreId == null ? 43 : $coreId.hashCode());
            String $vendor = this.getVendor();
            result = result * 59 + ($vendor == null ? 43 : $vendor.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            String $implementation = this.getImplementation();
            result = result * 59 + ($implementation == null ? 43 : $implementation.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SolarisRawData.Cpu(processorId=" + this.getProcessorId() + ", chipId=" + this.getChipId() + ", coreId=" + this.getCoreId() + ", vendor=" + this.getVendor() + ", model=" + this.getModel() + ", implementation=" + this.getImplementation() + ", numCores=" + this.getNumCores() + ", numLogicalProcessors=" + this.getNumLogicalProcessors() + ", currentSpeedHz=" + this.getCurrentSpeedHz() + ")";
        }

        @Generated
        public Cpu(String processorId, String chipId, String coreId, @NonNull String vendor, @NonNull String model, @NonNull String implementation, int numCores, int numLogicalProcessors, long currentSpeedHz) {
            if (vendor == null) {
                throw new NullPointerException("vendor is marked non-null but is null");
            }
            if (model == null) {
                throw new NullPointerException("model is marked non-null but is null");
            }
            if (implementation == null) {
                throw new NullPointerException("implementation is marked non-null but is null");
            }
            this.processorId = processorId;
            this.chipId = chipId;
            this.coreId = coreId;
            this.vendor = vendor;
            this.model = model;
            this.implementation = implementation;
            this.numCores = numCores;
            this.numLogicalProcessors = numLogicalProcessors;
            this.currentSpeedHz = currentSpeedHz;
        }

        @Generated
        protected Cpu() {
        }

        @Generated
        public static class CpuBuilder {
            @Generated
            private String processorId;
            @Generated
            private String chipId;
            @Generated
            private String coreId;
            @Generated
            private String vendor;
            @Generated
            private String model;
            @Generated
            private String implementation;
            @Generated
            private int numCores;
            @Generated
            private int numLogicalProcessors;
            @Generated
            private long currentSpeedHz;

            @Generated
            CpuBuilder() {
            }

            @Generated
            public CpuBuilder processorId(String processorId) {
                this.processorId = processorId;
                return this;
            }

            @Generated
            public CpuBuilder chipId(String chipId) {
                this.chipId = chipId;
                return this;
            }

            @Generated
            public CpuBuilder coreId(String coreId) {
                this.coreId = coreId;
                return this;
            }

            @Generated
            public CpuBuilder vendor(@NonNull String vendor) {
                if (vendor == null) {
                    throw new NullPointerException("vendor is marked non-null but is null");
                }
                this.vendor = vendor;
                return this;
            }

            @Generated
            public CpuBuilder model(@NonNull String model) {
                if (model == null) {
                    throw new NullPointerException("model is marked non-null but is null");
                }
                this.model = model;
                return this;
            }

            @Generated
            public CpuBuilder implementation(@NonNull String implementation) {
                if (implementation == null) {
                    throw new NullPointerException("implementation is marked non-null but is null");
                }
                this.implementation = implementation;
                return this;
            }

            @Generated
            public CpuBuilder numCores(int numCores) {
                this.numCores = numCores;
                return this;
            }

            @Generated
            public CpuBuilder numLogicalProcessors(int numLogicalProcessors) {
                this.numLogicalProcessors = numLogicalProcessors;
                return this;
            }

            @Generated
            public CpuBuilder currentSpeedHz(long currentSpeedHz) {
                this.currentSpeedHz = currentSpeedHz;
                return this;
            }

            @Generated
            public Cpu build() {
                return new Cpu(this.processorId, this.chipId, this.coreId, this.vendor, this.model, this.implementation, this.numCores, this.numLogicalProcessors, this.currentSpeedHz);
            }

            @Generated
            public String toString() {
                return "SolarisRawData.Cpu.CpuBuilder(processorId=" + this.processorId + ", chipId=" + this.chipId + ", coreId=" + this.coreId + ", vendor=" + this.vendor + ", model=" + this.model + ", implementation=" + this.implementation + ", numCores=" + this.numCores + ", numLogicalProcessors=" + this.numLogicalProcessors + ", currentSpeedHz=" + this.currentSpeedHz + ")";
            }
        }
    }
}

