/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MetricNameUtil;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisVolumesUtil;
import com.appdynamics.sim.agent.extensions.servers.util.ServerIostatAverageServiceTimeCounter;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@VisibleForAssistedInject
public class SolarisPartition
extends Partition<SolarisRawData> {
    @VisibleForTesting
    Map<String, SolarisRawData.Volume> partitionNameToVolume;
    private SolarisRawData.Partition partitionStats;
    private SolarisRawData rawData;
    private RateCalculatorUtil readsPerSecondCounter;
    private RateCalculatorUtil writesPerSecondCounter;
    private RateCalculatorUtil readKbPerSecondCounter;
    private RateCalculatorUtil writeKbPerSecondCounter;
    private ServerIostatAverageServiceTimeCounter averageServiceTimeCounter;
    private long currentReadCountPerSec;
    private long currentWriteCountPerSec;
    private long currentReadKbPerSec;
    private long currentWriteKbPerSec;
    private long currentAverageServiceTime;
    private long averageReadTime;
    private long averageWriteTime;
    private String metricNameServiceTime;
    private String volumeId;
    private final RawDataFactory factory;

    @Inject
    SolarisPartition(@Assisted String partitionName, @Sim MetricsService metricsService, RawDataFactory factory) {
        super(partitionName, metricsService, factory);
        this.factory = factory;
        this.readsPerSecondCounter = new RateCalculatorUtil();
        this.writesPerSecondCounter = new RateCalculatorUtil();
        this.readKbPerSecondCounter = new RateCalculatorUtil();
        this.writeKbPerSecondCounter = new RateCalculatorUtil();
        this.averageServiceTimeCounter = new ServerIostatAverageServiceTimeCounter();
        String normalizedPartitionName = MetricNameUtil.normalizeMetricName(partitionName);
        this.metricNameServiceTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg Service Time (ms)", (String)normalizedPartitionName);
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.rawData = rawData;
        this.partitionStats = rawData.getPartitions().get(this.getPartitionName());
        this.buildPartitionNameToVolumeMap(rawData.getVolumes());
        long readsPerSec = SolarisVolumesUtil.getbytesFromData(this.partitionStats.getReadsPerSec(), this.getPartitionName());
        long writesPerSec = SolarisVolumesUtil.getbytesFromData(this.partitionStats.getWritesPerSec(), this.getPartitionName());
        long readKbPerSec = SolarisVolumesUtil.getKbsFromSize(this.partitionStats.getReadKbPerSec(), this.getPartitionName());
        long writeKbPerSec = SolarisVolumesUtil.getKbsFromSize(this.partitionStats.getWriteKbPerSec(), this.getPartitionName());
        this.currentReadCountPerSec = this.readsPerSecondCounter.calculate(readsPerSec * this.partitionStats.getTimeStampInSeconds().longValue(), this.partitionStats.getTimeStampInSeconds().longValue());
        this.currentWriteCountPerSec = this.writesPerSecondCounter.calculate(writesPerSec * this.partitionStats.getTimeStampInSeconds().longValue(), this.partitionStats.getTimeStampInSeconds().longValue());
        this.currentReadKbPerSec = this.readKbPerSecondCounter.calculate(readKbPerSec * this.partitionStats.getTimeStampInSeconds().longValue(), this.partitionStats.getTimeStampInSeconds().longValue());
        this.currentWriteKbPerSec = this.writeKbPerSecondCounter.calculate(writeKbPerSec * this.partitionStats.getTimeStampInSeconds().longValue(), this.partitionStats.getTimeStampInSeconds().longValue());
        this.currentAverageServiceTime = this.averageServiceTimeCounter.calculate(readsPerSec, writesPerSec, this.partitionStats.getAvgServiceTime(), this.partitionStats.getTimeStampInSeconds());
        long totalKbsPerSec = this.currentReadKbPerSec + this.currentWriteKbPerSec;
        this.averageReadTime = this.getAverageTime(this.currentAverageServiceTime, this.currentReadKbPerSec, totalKbsPerSec);
        this.averageWriteTime = this.getAverageTime(this.currentAverageServiceTime, this.currentWriteKbPerSec, totalKbsPerSec);
        for (Map.Entry<String, SolarisRawData.Volume> entry : rawData.getVolumes().entrySet()) {
            SolarisRawData.Volume v = entry.getValue();
            if (!v.getName().equalsIgnoreCase(this.getPartitionName())) continue;
            this.volumeId = entry.getKey();
            break;
        }
    }

    @Override
    protected void doReporting(ReportMetricsConfig reportMetricsConfig) {
        super.doReporting(reportMetricsConfig);
        if (reportMetricsConfig.isReportBasicMetrics()) {
            this.metricsService.reportMetric(this.metricNameServiceTime, ExtensionMetricAggregatorType.AVERAGE, this.currentAverageServiceTime);
        }
    }

    @Override
    public RawDataLong getReadCountPerSec() {
        return this.factory.createLong(Long.valueOf(this.readsPerSecondCounter.getLastResult()));
    }

    @Override
    public RawDataLong getReadKbPerSec() {
        return this.factory.createLong(Long.valueOf(this.readKbPerSecondCounter.getLastResult()));
    }

    @Override
    public RawDataLong getAvgReadTimeMillis() {
        return this.factory.createLong(Long.valueOf(this.averageReadTime));
    }

    @Override
    public RawDataLong getWriteCountPerSec() {
        return this.factory.createLong(Long.valueOf(this.writesPerSecondCounter.getLastResult()));
    }

    @Override
    public RawDataLong getWriteKbPerSec() {
        return this.factory.createLong(Long.valueOf(this.writeKbPerSecondCounter.getLastResult()));
    }

    @Override
    public RawDataLong getAvgWriteTimeMillis() {
        return this.factory.createLong(Long.valueOf(this.averageWriteTime));
    }

    @Override
    public RawDataLong getUtilization() {
        return this.factory.createLong(Long.valueOf(this.partitionStats.getIoUtilizationPct()));
    }

    @Override
    public RawDataLong getSpaceAvailableKb() {
        if (this.partitionNameToVolume.isEmpty() || !this.partitionNameToVolume.containsKey(this.getPartitionName())) {
            return this.factory.createLong(Long.valueOf(0L));
        }
        String partitionName = this.getPartitionName();
        SolarisRawData.Volume volume = this.partitionNameToVolume.get(partitionName);
        long result = SolarisVolumesUtil.getKbsFromSize(volume.getTotalSpace(), partitionName) - SolarisVolumesUtil.getKbsFromSize(volume.getUsedSpace(), partitionName);
        return this.factory.createLong(Long.valueOf(result));
    }

    @Override
    public RawDataLong getSpaceUsedKb() {
        if (this.partitionNameToVolume.isEmpty() || !this.partitionNameToVolume.containsKey(this.getPartitionName())) {
            return this.factory.createLong(Long.valueOf(0L));
        }
        String partitionName = this.getPartitionName();
        long result = SolarisVolumesUtil.getKbsFromSize(this.partitionNameToVolume.get(partitionName).getUsedSpace(), partitionName);
        return this.factory.createLong(Long.valueOf(result));
    }

    @VisibleForTesting
    void buildPartitionNameToVolumeMap(Map<String, SolarisRawData.Volume> volumes) {
        this.partitionNameToVolume = new HashMap<String, SolarisRawData.Volume>();
        for (SolarisRawData.Volume volume : volumes.values()) {
            this.partitionNameToVolume.put(volume.getName(), volume);
        }
    }

    private long getAverageTime(long averageServiceTime, long readOrWriteKbsPerSec, long totalKbsPerSec) {
        long averageReadOrWriteTime = 0L;
        if (totalKbsPerSec > 0L) {
            averageReadOrWriteTime = averageServiceTime * readOrWriteKbsPerSec / totalKbsPerSec;
        }
        return averageReadOrWriteTime;
    }

    @Override
    public Optional<String> getVolumeId() {
        return Optional.fromNullable((Object)this.volumeId);
    }

    @Override
    @Generated
    public String toString() {
        return "SolarisPartition(super=" + super.toString() + ", partitionNameToVolume=" + String.valueOf(this.partitionNameToVolume) + ", partitionStats=" + String.valueOf(this.partitionStats) + ", rawData=" + String.valueOf(this.rawData) + ", readsPerSecondCounter=" + String.valueOf(this.readsPerSecondCounter) + ", writesPerSecondCounter=" + String.valueOf(this.writesPerSecondCounter) + ", readKbPerSecondCounter=" + String.valueOf(this.readKbPerSecondCounter) + ", writeKbPerSecondCounter=" + String.valueOf(this.writeKbPerSecondCounter) + ", averageServiceTimeCounter=" + String.valueOf(this.averageServiceTimeCounter) + ", currentReadCountPerSec=" + this.currentReadCountPerSec + ", currentWriteCountPerSec=" + this.currentWriteCountPerSec + ", currentReadKbPerSec=" + this.currentReadKbPerSec + ", currentWriteKbPerSec=" + this.currentWriteKbPerSec + ", currentAverageServiceTime=" + this.currentAverageServiceTime + ", averageReadTime=" + this.averageReadTime + ", averageWriteTime=" + this.averageWriteTime + ", metricNameServiceTime=" + this.metricNameServiceTime + ", volumeId=" + String.valueOf(this.getVolumeId()) + ", factory=" + String.valueOf(this.factory) + ")";
    }
}

