/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import lombok.Generated;

@VisibleForAssistedInject
public class SolarisOperatingSystem
extends OperatingSystem<SolarisRawData> {
    private SolarisRawData.OperatingSystem os;

    @Inject
    private SolarisOperatingSystem(@Sim MachineProperties machineProperties, Predicate<ToggleableReporter<SolarisRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("Solaris", machineProperties, isDisabledPredicate, rawDataFactory);
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.os = rawData.getOperatingSystem();
    }

    @Override
    protected RawDataString getRelease() {
        return this.rawDataFactory.createString(Optional.fromNullable((Object)this.os.getRelease()));
    }

    @Override
    protected RawDataString getArchitecture() {
        return this.rawDataFactory.createString(Optional.fromNullable((Object)this.os.getArchitecture()));
    }

    @Override
    @Generated
    public String toString() {
        return "SolarisOperatingSystem(super=" + super.toString() + ", os=" + String.valueOf(this.os) + ")";
    }
}

