/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;

@VisibleForAssistedInject
public class SolarisNetwork
extends Network<SolarisRawData> {
    private static final String HALF = "half";
    private static final String FULL = "full";
    private SolarisRawData.NetworkInterfaceInfo networkInterfaceInfo;
    private DeltaCalculatorUtil incomingBytesCalculator;
    private DeltaCalculatorUtil outgoingBytesCalculator;
    private DeltaCalculatorUtil incomingPacketsCalculator;
    private DeltaCalculatorUtil outgoingPacketsCalculator;
    private DeltaCalculatorUtil incomingPacketErrorsCalculator;
    private DeltaCalculatorUtil outgoingPacketErrorsCalculator;
    private RateCalculatorUtil incomingBytesPerSecCalculator;
    private RateCalculatorUtil outgoingBytesPerSecCalculator;
    private RateCalculatorUtil incomingPacketsPerSecCalculator;
    private RateCalculatorUtil outgoingPacketsPerSecCalculator;

    @Inject
    SolarisNetwork(@Assisted String networkName, @Sim MachineProperties machineProperties, @Sim MetricsService metricsService) {
        super(networkName, machineProperties, metricsService);
        this.incomingBytesCalculator = new DeltaCalculatorUtil();
        this.outgoingBytesCalculator = new DeltaCalculatorUtil();
        this.incomingPacketsCalculator = new DeltaCalculatorUtil();
        this.outgoingPacketsCalculator = new DeltaCalculatorUtil();
        this.incomingPacketErrorsCalculator = new DeltaCalculatorUtil();
        this.outgoingPacketErrorsCalculator = new DeltaCalculatorUtil();
        this.incomingBytesPerSecCalculator = new RateCalculatorUtil();
        this.outgoingBytesPerSecCalculator = new RateCalculatorUtil();
        this.incomingPacketsPerSecCalculator = new RateCalculatorUtil();
        this.outgoingPacketsPerSecCalculator = new RateCalculatorUtil();
    }

    @VisibleForTesting
    SolarisNetwork(String networkName, MachineProperties machineProperties, MetricsService metricsService, SolarisRawData.NetworkInterfaceInfo networkInterfaceInfo, DeltaCalculatorUtil incomingBytesCalculator, DeltaCalculatorUtil outgoingBytesCalculator, DeltaCalculatorUtil incomingPacketsCalculator, DeltaCalculatorUtil outgoingPacketsCalculator, DeltaCalculatorUtil incomingPacketErrorsCalculator, DeltaCalculatorUtil outgoingPacketErrorsCalculator, RateCalculatorUtil incomingBytesPerSecCalculator, RateCalculatorUtil outgoingBytesPerSecCalculator, RateCalculatorUtil incomingPacketsPerSecCalculator, RateCalculatorUtil outgoingPacketsPerSecCalculator) {
        super(networkName, machineProperties, metricsService);
        this.networkInterfaceInfo = networkInterfaceInfo;
        this.incomingBytesCalculator = incomingBytesCalculator;
        this.outgoingBytesCalculator = outgoingBytesCalculator;
        this.incomingPacketsCalculator = incomingPacketsCalculator;
        this.outgoingPacketsCalculator = outgoingPacketsCalculator;
        this.incomingPacketErrorsCalculator = incomingPacketErrorsCalculator;
        this.outgoingPacketErrorsCalculator = outgoingPacketErrorsCalculator;
        this.incomingBytesPerSecCalculator = incomingBytesPerSecCalculator;
        this.outgoingBytesPerSecCalculator = outgoingBytesPerSecCalculator;
        this.incomingPacketsPerSecCalculator = incomingPacketsPerSecCalculator;
        this.outgoingPacketsPerSecCalculator = outgoingPacketsPerSecCalculator;
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.networkInterfaceInfo = rawData.getNetworkInterfaces().get(this.getNetworkName());
        long incomingBytes = this.networkInterfaceInfo.getIncomingBytes();
        long outgoingBytes = this.networkInterfaceInfo.getOutgoingBytes();
        long incomingPackets = this.networkInterfaceInfo.getIncomingPackets();
        long outgoingPackets = this.networkInterfaceInfo.getOutgoingPackets();
        this.incomingBytesCalculator.calculate(incomingBytes);
        this.outgoingBytesCalculator.calculate(outgoingBytes);
        this.incomingPacketsCalculator.calculate(incomingPackets);
        this.outgoingPacketsCalculator.calculate(outgoingPackets);
        this.incomingPacketErrorsCalculator.calculate(this.networkInterfaceInfo.getIncomingPacketErrors());
        this.outgoingPacketErrorsCalculator.calculate(this.networkInterfaceInfo.getOutgoingPacketErrors());
        long timeStamp = this.networkInterfaceInfo.getTimeStamp();
        this.incomingBytesPerSecCalculator.calculate(incomingBytes, timeStamp);
        this.outgoingBytesPerSecCalculator.calculate(outgoingBytes, timeStamp);
        this.incomingPacketsPerSecCalculator.calculate(incomingPackets, timeStamp);
        this.outgoingPacketsPerSecCalculator.calculate(outgoingPackets, timeStamp);
    }

    @Override
    protected String getNetEnabled() {
        return this.valueToNoYesUnknown(this.networkInterfaceInfo.getEnabled());
    }

    @Override
    protected String getPluggedIn() {
        return this.valueToNoYesUnknown(this.networkInterfaceInfo.getPluggedIn());
    }

    @Override
    protected String getStatus() {
        return this.networkInterfaceInfo.getOperational().toLowerCase();
    }

    @Override
    protected String getDuplex() {
        String value = this.networkInterfaceInfo.getDuplex().toLowerCase();
        if (value.equals(HALF) || value.equals(FULL)) {
            return value;
        }
        if (value.isEmpty() || value.equals("unknown")) {
            return "unknown";
        }
        return "no";
    }

    @Override
    protected String getMtu() {
        return String.valueOf(this.networkInterfaceInfo.getMtu());
    }

    @Override
    protected String getSpeedMb() {
        long speed = this.getSpeedBits() / 1000000L;
        return String.valueOf(speed);
    }

    @Override
    protected String getMacAddress() {
        return this.networkInterfaceInfo.getMacAddress();
    }

    @Override
    protected String getIpv4Addresses() {
        return this.networkInterfaceInfo.getIpv4();
    }

    @Override
    protected String getIpv6Addresses() {
        return this.networkInterfaceInfo.getIpv6();
    }

    @Override
    protected String getDefaultIpv4Gateways() {
        return this.networkInterfaceInfo.getIpv4DefaultGateway();
    }

    @Override
    protected String getDefaultIpv6Gateways() {
        return this.networkInterfaceInfo.getIpv6DefaultGateway();
    }

    @Override
    protected long getIncomingKb() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKb() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPackets() {
        return this.incomingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPackets() {
        return this.outgoingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingPacketErrors() {
        return this.incomingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketErrors() {
        return this.outgoingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPacketsPerSec() {
        return this.incomingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketsPerSec() {
        return this.outgoingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getUtilizationPct() {
        long maxBits = this.getSpeedBits();
        if (this.getDuplex().equals(FULL)) {
            maxBits *= 2L;
        }
        if (maxBits == 0L) {
            return Optional.absent();
        }
        long totalBytesPerSec = this.incomingBytesPerSecCalculator.getLastResult() + this.outgoingBytesPerSecCalculator.getLastResult();
        return Optional.of((Object)CalculationUtils.calculatePercentage(CalculationUtils.bytesToBits(totalBytesPerSec), maxBits));
    }

    private long getSpeedBits() {
        return this.networkInterfaceInfo.getSpeed();
    }

    private String valueToNoYesUnknown(long value) {
        if (value == 0L) {
            return "no";
        }
        if (value == 1L) {
            return "yes";
        }
        return "unknown";
    }

    @Override
    @Generated
    public String toString() {
        return "SolarisNetwork(super=" + super.toString() + ", networkInterfaceInfo=" + String.valueOf(this.networkInterfaceInfo) + ", incomingBytesCalculator=" + String.valueOf(this.incomingBytesCalculator) + ", outgoingBytesCalculator=" + String.valueOf(this.outgoingBytesCalculator) + ", incomingPacketsCalculator=" + String.valueOf(this.incomingPacketsCalculator) + ", outgoingPacketsCalculator=" + String.valueOf(this.outgoingPacketsCalculator) + ", incomingPacketErrorsCalculator=" + String.valueOf(this.incomingPacketErrorsCalculator) + ", outgoingPacketErrorsCalculator=" + String.valueOf(this.outgoingPacketErrorsCalculator) + ", incomingBytesPerSecCalculator=" + String.valueOf(this.incomingBytesPerSecCalculator) + ", outgoingBytesPerSecCalculator=" + String.valueOf(this.outgoingBytesPerSecCalculator) + ", incomingPacketsPerSecCalculator=" + String.valueOf(this.incomingPacketsPerSecCalculator) + ", outgoingPacketsPerSecCalculator=" + String.valueOf(this.outgoingPacketsPerSecCalculator) + ")";
    }
}

