/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.HostId;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClasses;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.processes.agent.rest.SimProcessesAgentService;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SolarisMonitoredProcessClasses
extends MonitoredProcessClasses<SolarisRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolarisMonitoredProcessClasses.class);
    private RawDataFactory factory;

    @Inject
    private SolarisMonitoredProcessClasses(@HostId @NonNull String hostId, @NonNull SimProcessesAgentService processesAgentService, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<SolarisRawData, MonitoredProcessClass<SolarisRawData>> componentFactory, @NonNull Filters<MonitoredProcessClass<SolarisRawData>> filters, @NonNull Set<Transformer<MonitoredProcessClass<SolarisRawData>>> metadataTransformers, @NonNull ProcessProperties processProperties, @Sim @NonNull MetricsService metricsService, @NonNull Predicate<ToggleableReporter<SolarisRawData>> isDisabledPredicate, @NonNull RawDataFactory factory) {
        super(hostId, processesAgentService, repetitiveLogger, componentFactory, filters, metadataTransformers, processProperties, metricsService, isDisabledPredicate);
        if (hostId == null) {
            throw new NullPointerException("hostId is marked non-null but is null");
        }
        if (processesAgentService == null) {
            throw new NullPointerException("processesAgentService is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (componentFactory == null) {
            throw new NullPointerException("componentFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.factory = factory;
    }

    @Override
    protected Set<String> extractIds(SolarisRawData rawData) {
        return Collections.unmodifiableSet(rawData.getProcData().keySet());
    }

    @Override
    protected RawDataLong getTotalProcessCount(SolarisRawData rawData) {
        return this.factory.createLong(Long.valueOf(rawData.getProcesses().size()));
    }
}

