/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.solaris;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.solaris.SolarisRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;

@VisibleForAssistedInject
public class SolarisMemory
extends Memory<SolarisRawData> {
    private final RawDataFactory rawDataFactory;
    private SolarisRawData.Memory memory;

    @Inject
    public SolarisMemory(@Sim MetricsService metricsService, @Sim MachineProperties machineProperties, Predicate<ToggleableReporter<SolarisRawData>> isDisabledPredicate, RawDataFactory rawDataFactory) {
        super("SolarisMemory", metricsService, machineProperties, isDisabledPredicate, rawDataFactory);
        this.rawDataFactory = rawDataFactory;
    }

    @Override
    public void update(SolarisRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.memory = rawData.getMemory();
    }

    @Override
    protected RawDataLong getSwapTotalMb() {
        RawDataLong swapFreeMb = this.getSwapFreeMb();
        if (!swapFreeMb.isPresent()) {
            return swapFreeMb;
        }
        return this.rawDataFactory.createLong(Long.valueOf(swapFreeMb.get() + SizeUnit.KILOBYTES.toMegabytes(this.memory.getSwapUsedKb())));
    }

    @Override
    protected RawDataLong getSwapFreeMb() {
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(this.memory.getSwapFreeKb())));
    }

    @Override
    protected RawDataLong getPhysicalTotalMb() {
        return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.BYTES.toMegabytes(this.memory.getTotalPages() * this.memory.getPageSize())));
    }

    @Override
    protected RawDataLong getPhysicalFreeMb() {
        long arcSizeMb = SizeUnit.BYTES.toMegabytes(this.memory.getArcSize() - this.memory.getArcMinSize());
        return this.rawDataFactory.createLong(Long.valueOf(arcSizeMb + SizeUnit.BYTES.toMegabytes(this.memory.getFreePages() * this.memory.getPageSize())));
    }

    @Generated
    public String toString() {
        return "SolarisMemory(super=" + super.toString() + ", rawDataFactory=" + String.valueOf(this.rawDataFactory) + ", memory=" + String.valueOf(this.memory) + ")";
    }
}

