/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarVolumeDto;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Volumes
implements IModule<Map<String, SigarVolumeDto>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Volumes.class);

    @Inject
    Volumes() {
    }

    @Override
    public Optional<Map<String, SigarVolumeDto>> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            ArrayList<FileSystem> fsList = new ArrayList<FileSystem>(Arrays.asList(sigar.getFileSystemList()));
            ImmutableMap.Builder mountPointToVolumeBuilder = ImmutableMap.builder();
            for (FileSystem fs : fsList) {
                Optional totalOpt = Optional.absent();
                Optional freeOpt = Optional.absent();
                Optional usedOpt = Optional.absent();
                Optional availableOpt = Optional.absent();
                Optional usedPercentageOpt = Optional.absent();
                String mountPoint = fs.getDirName();
                String devName = fs.getDevName();
                try {
                    FileSystemUsage usage = sigar.getMountedFileSystemUsage(mountPoint);
                    if (usage != null) {
                        totalOpt = Optional.of((Object)usage.getTotal());
                        freeOpt = Optional.of((Object)usage.getFree());
                        usedOpt = Optional.of((Object)usage.getUsed());
                        availableOpt = Optional.of((Object)usage.getAvail());
                        usedPercentageOpt = Optional.of((Object)usage.getUsePercent());
                    }
                    String normalizedMountPoint = this.normalizeMountPoint(mountPoint);
                    SigarVolumeDto volumeDto = SigarVolumeDto.builder().mountPoint(normalizedMountPoint).devName(devName).totalKbOpt((Optional<Long>)totalOpt).freeKbOpt((Optional<Long>)freeOpt).usedKbOpt((Optional<Long>)usedOpt).availableKbOpt((Optional<Long>)availableOpt).usedPercentOpt((Optional<Double>)usedPercentageOpt).build();
                    mountPointToVolumeBuilder.put((Object)normalizedMountPoint, (Object)volumeDto);
                }
                catch (SigarException e) {
                    log.debug("Skipping unmounted file system: " + mountPoint);
                }
            }
            result.setMountPointToVolume((Map<String, SigarVolumeDto>)mountPointToVolumeBuilder.build());
            return Optional.of(result.getMountPointToVolume());
        }
        catch (Exception e) {
            log.error("Error while collecting volume metrics ", (Throwable)e);
            return Optional.absent();
        }
    }

    private String normalizeMountPoint(String mountPoint) {
        int length;
        if (mountPoint != null && (length = mountPoint.length()) > 0 && mountPoint.charAt(length - 1) == '\\') {
            return mountPoint.substring(0, length - 1);
        }
        return mountPoint;
    }
}

