/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarVolumeDto;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SigarVolume
extends Volume<SigarRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigarVolume.class);
    private final RawDataFactory rawDataFactory;
    private SigarVolumeDto volumeDto;

    @Inject
    SigarVolume(@Assisted @NonNull String mountPoint, @Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataFactory factory, RawDataItemUtil dataItemUtil) {
        super(mountPoint, metricsService, machineProperties, factory, dataItemUtil);
        if (mountPoint == null) {
            throw new NullPointerException("mountPoint is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.rawDataFactory = factory;
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        String mountPoint = this.getMountPoint();
        this.volumeDto = rawData.getMountPointToVolume().get(mountPoint);
    }

    @Override
    protected RawDataString getPartition() {
        return this.rawDataFactory.createString(Optional.of((Object)this.volumeDto.getDevName()));
    }

    @Override
    protected RawDataLong getSizeMb() {
        Optional<Long> sizeKbOpt = this.volumeDto.getTotalKbOpt();
        if (sizeKbOpt.isPresent()) {
            return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(((Long)sizeKbOpt.get()).longValue())));
        }
        return RawDataConstants.ABSENT_LONG;
    }

    @Override
    protected RawDataLong getUsedMb() {
        Optional<Long> usedKbOpt = this.volumeDto.getUsedKbOpt();
        if (usedKbOpt.isPresent()) {
            return this.rawDataFactory.createLong(Long.valueOf(SizeUnit.KILOBYTES.toMegabytes(((Long)usedKbOpt.get()).longValue())));
        }
        return RawDataConstants.ABSENT_LONG;
    }
}

