/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentName;
import com.appdynamics.sim.agent.extensions.servers.model.ProcessClassIdCreator;
import com.appdynamics.sim.agent.extensions.servers.model.RawCollector;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.ISigarCollector;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Load;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Memory;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Networks;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.OperatingSystem;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Partitions;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Processes;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarProcessesDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.Volumes;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SigarRawCollector
implements RawCollector<SigarRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SigarRawCollector.class);
    private final Map<String, IModule<?>> nameToModuleMap;
    private final ISigarCollector sigarCollector;
    private final ProcessClassIdCreator processClassIdCreator;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    SigarRawCollector(@NonNull ISigarCollector sigarCollector, @NonNull ProcessClassIdCreator processClassIdCreator, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull Cpu cpu, @NonNull Load load, @NonNull Memory memory, @NonNull Networks networks, @NonNull OperatingSystem operatingSystem, @NonNull Processes processes, @NonNull Volumes volumes, @NonNull Partitions partitions) {
        if (sigarCollector == null) {
            throw new NullPointerException("sigarCollector is marked non-null but is null");
        }
        if (processClassIdCreator == null) {
            throw new NullPointerException("processClassIdCreator is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpu == null) {
            throw new NullPointerException("cpu is marked non-null but is null");
        }
        if (load == null) {
            throw new NullPointerException("load is marked non-null but is null");
        }
        if (memory == null) {
            throw new NullPointerException("memory is marked non-null but is null");
        }
        if (networks == null) {
            throw new NullPointerException("networks is marked non-null but is null");
        }
        if (operatingSystem == null) {
            throw new NullPointerException("operatingSystem is marked non-null but is null");
        }
        if (processes == null) {
            throw new NullPointerException("processes is marked non-null but is null");
        }
        if (volumes == null) {
            throw new NullPointerException("volumes is marked non-null but is null");
        }
        if (partitions == null) {
            throw new NullPointerException("partitions is marked non-null but is null");
        }
        this.sigarCollector = sigarCollector;
        this.processClassIdCreator = processClassIdCreator;
        this.repetitiveLogger = repetitiveLogger;
        ImmutableMap.Builder nameToModuleMapBuilder = ImmutableMap.builder();
        nameToModuleMapBuilder.put((Object)ComponentName.CPUS.toString(), (Object)cpu);
        nameToModuleMapBuilder.put((Object)ComponentName.LOAD.toString(), (Object)load);
        nameToModuleMapBuilder.put((Object)ComponentName.MEMORY.toString(), (Object)memory);
        nameToModuleMapBuilder.put((Object)ComponentName.NETWORKS.toString(), (Object)networks);
        nameToModuleMapBuilder.put((Object)ComponentName.OPERATING_SYSTEM.toString(), (Object)operatingSystem);
        nameToModuleMapBuilder.put((Object)ComponentName.MONITORED_PROCESS_CLASSES.toString(), (Object)processes);
        nameToModuleMapBuilder.put((Object)ComponentName.VOLUMES.toString(), (Object)volumes);
        nameToModuleMapBuilder.put((Object)ComponentName.PARTITIONS.toString(), (Object)partitions);
        this.nameToModuleMap = nameToModuleMapBuilder.build();
    }

    @Override
    public SigarRawData collectRawData(@NonNull Set<String> componentsToCollect, long maxCollectionTimeMillis) {
        if (componentsToCollect == null) {
            throw new NullPointerException("componentsToCollect is marked non-null but is null");
        }
        log.debug("Collecting SigarRawData");
        Set<IModule<?>> modulesToCollect = this.getModulesToCollectFromNames(componentsToCollect);
        SigarRawData rawData = this.sigarCollector.collectMetrics(modulesToCollect);
        log.debug("Collected SigarRawData: {}", (Object)rawData);
        this.preProcess(rawData);
        log.debug("After pre-processing, SigarRawData: {}", (Object)rawData);
        return rawData;
    }

    private void preProcess(SigarRawData rawData) {
        try {
            this.preProcessCpus(rawData);
            this.preProcessProcesses(rawData);
        }
        catch (Exception e) {
            this.repetitiveLogger.warn(log, "Caught exception during pre-processing: " + String.valueOf(e), new Object[0]);
        }
    }

    private void preProcessCpus(SigarRawData rawData) {
        long numLogicalCores = rawData.getCpu().getCpuInfos().size();
        rawData.getCpu().setNumLogicalCores((Optional<Long>)Optional.of((Object)numLogicalCores));
    }

    @VisibleForTesting
    void preProcessProcesses(SigarRawData rawData) {
        ArrayListMultimap procData = ArrayListMultimap.create();
        for (Map.Entry<String, SigarProcessesDto.Process> processEntry : rawData.getProcesses().getPidToprocess().entrySet()) {
            try {
                SigarProcessesDto.Process process = processEntry.getValue();
                if (!process.getCommandLine().isPresent() || !process.getName().isPresent()) continue;
                ProcessClassIdCreator.ProcessClass processClass = this.processClassIdCreator.extractClass(process.getCommandLine().get(), process.getName().get());
                procData.put((Object)processClass.getProcessClassId(), (Object)new SigarProcessesDto.ProcessRawData(processClass, process));
            }
            catch (Exception e) {
                this.repetitiveLogger.warn(log, "Caught exception when pre-processing process with id {}. The process will be removed from collected data. " + String.valueOf(e), new Object[]{processEntry.getKey()});
            }
        }
        rawData.getProcesses().setProcData((ListMultimap<String, SigarProcessesDto.ProcessRawData>)procData);
    }

    private Set<IModule<?>> getModulesToCollectFromNames(Set<String> componentsToCollect) {
        ImmutableSet.Builder modulesToCollectBuilder = ImmutableSet.builder();
        for (String componentName : componentsToCollect) {
            IModule<?> module = this.nameToModuleMap.get(componentName);
            if (module != null) {
                modulesToCollectBuilder.add(module);
                continue;
            }
            log.debug("Component name is invalid or collection not supported: " + componentName);
        }
        return modulesToCollectBuilder.build();
    }
}

