/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.Networks;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarNetworkDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarNetworkUtil;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

class SigarNetworks
extends Networks<SigarRawData> {
    @Inject
    SigarNetworks(@Sim @NonNull MetricsService metricsService, @Sim @NonNull MachineProperties machineProperties, @NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<SigarRawData, Network<SigarRawData>> networkFactory, @NonNull Filters<Network<SigarRawData>> filters, @NonNull Set<Transformer<Network<SigarRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<SigarRawData>> isDisabledPredicate) {
        super(metricsService, machineProperties, repetitiveLogger, networkFactory, filters, metadataTransformers, isDisabledPredicate);
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (networkFactory == null) {
            throw new NullPointerException("networkFactory is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
    }

    @Override
    protected Set<String> extractIds(SigarRawData rawData) {
        return this.getNonLoopbackInterfacesWithMacAndIpAddresses(rawData);
    }

    @VisibleForTesting
    Set<String> getNonLoopbackInterfacesWithMacAndIpAddresses(SigarRawData rawData) {
        ImmutableSet.Builder nonLoopbackInterfacesWithMacAndIpBuilder = ImmutableSet.builder();
        for (Map.Entry<String, SigarNetworkDto> entry : rawData.getNetworkNameToNetwork().entrySet()) {
            String networkName = entry.getKey();
            SigarNetworkDto networkDto = entry.getValue();
            if (SigarNetworkUtil.isLoopbackInterface(networkDto) || !SigarNetworkUtil.hasIpAddress(networkDto) || !SigarNetworkUtil.hasMacAddress(networkDto)) continue;
            nonLoopbackInterfacesWithMacAndIpBuilder.add((Object)networkName);
        }
        return nonLoopbackInterfacesWithMacAndIpBuilder.build();
    }
}

