/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarNetworkDto;

public class SigarNetworkUtil {
    private static final long IFF_LOOPBACK = 8L;
    private static final String IP_ADDRESS_ALL_ZEROS = "0.0.0.0";
    private static final String MAC_ADDRESS_ALL_ZEROS = "00:00:00:00:00:00";

    public static boolean isLoopbackInterface(SigarNetworkDto networkDto) {
        long flags;
        return networkDto.getFlagsOpt().isPresent() && ((flags = ((Long)networkDto.getFlagsOpt().get()).longValue()) & 8L) != 0L;
    }

    public static boolean hasIpAddress(SigarNetworkDto networkDto) {
        if (networkDto.getAddressOpt().isPresent()) {
            String ipAddress = (String)networkDto.getAddressOpt().get();
            return !ipAddress.equals(IP_ADDRESS_ALL_ZEROS);
        }
        return false;
    }

    public static boolean hasMacAddress(SigarNetworkDto networkDto) {
        if (networkDto.getMacAddressOpt().isPresent()) {
            String macAddress = (String)networkDto.getMacAddressOpt().get();
            return !macAddress.equals(MAC_ADDRESS_ALL_ZEROS);
        }
        return false;
    }
}

