/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarNetworkDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.IntWraparoundCalculator;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterBulkCountWithTimestamp;
import com.appdynamics.sim.agent.extensions.servers.util.PerfCounterRawCount;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.google.common.base.Optional;
import com.google.common.primitives.UnsignedInteger;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.math.BigInteger;
import lombok.NonNull;

class SigarNetwork
extends Network<SigarRawData> {
    private static final long IFF_RUNNING = 64L;
    private static final long IFF_UP = 1L;
    private static final long SPEED_NOT_IMPLEMENTED = -1L;
    private Optional<String> addressOpt;
    private Optional<String> macAddressOpt;
    private Optional<Long> mtuOpt;
    private Optional<Long> speedBitsPerSecOpt;
    private Optional<Long> flagsOpt;
    private long uptimeInSec;
    private final PerfCounterRawCount errorsIncomingCounter;
    private final PerfCounterRawCount errorsOutgoingCounter;
    private final PerfCounterRawCount packetsIncomingCounter;
    private final PerfCounterRawCount packetsOutgoingCounter;
    private final PerfCounterRawCount bytesIncomingCounter;
    private final PerfCounterRawCount bytesOutgoingCounter;
    private final PerfCounterBulkCountWithTimestamp packetsIncomingPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp packetsOutgoingPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp bytesIncomingPerSecCounter;
    private final PerfCounterBulkCountWithTimestamp bytesOutgoingPerSecCounter;

    @Inject
    private SigarNetwork(@Assisted @NonNull String networkName, @Sim @NonNull MachineProperties machineProperties, @Sim @NonNull MetricsService metricsService, IntWraparoundCalculator intWraparoundCalculator) {
        super(networkName, machineProperties, metricsService);
        if (networkName == null) {
            throw new NullPointerException("networkName is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        this.packetsIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.packetsOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.bytesIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.bytesOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.errorsIncomingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.errorsOutgoingCounter = new PerfCounterRawCount(intWraparoundCalculator);
        this.packetsIncomingPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.packetsOutgoingPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.bytesIncomingPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
        this.bytesOutgoingPerSecCounter = new PerfCounterBulkCountWithTimestamp(intWraparoundCalculator);
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        String networkName = this.getNetworkName();
        SigarNetworkDto sigarNetworkDto = rawData.getNetworkNameToNetwork().get(networkName);
        this.addressOpt = sigarNetworkDto.getAddressOpt();
        this.macAddressOpt = sigarNetworkDto.getMacAddressOpt();
        this.mtuOpt = sigarNetworkDto.getMtuOpt();
        this.speedBitsPerSecOpt = sigarNetworkDto.getSpeedBitsPerSecOpt();
        this.flagsOpt = sigarNetworkDto.getFlagsOpt();
        this.uptimeInSec = sigarNetworkDto.getUptimeInSec();
        if (sigarNetworkDto.getRxPacketsOpt().isPresent()) {
            Long rxPackets = (Long)sigarNetworkDto.getRxPacketsOpt().get();
            this.perfCounterRawCountCalculator(this.packetsIncomingCounter, rxPackets);
            this.perfCounterBulkCountCalculator(this.packetsIncomingPerSecCounter, rxPackets);
        } else {
            this.perfCounterRawCountCalculator(this.packetsIncomingCounter, UnknownValueUtil.getUnknownValue());
            this.perfCounterBulkCountCalculator(this.packetsIncomingPerSecCounter, UnknownValueUtil.getUnknownValue());
        }
        if (sigarNetworkDto.getTxPacketsOpt().isPresent()) {
            Long txPackets = (Long)sigarNetworkDto.getTxPacketsOpt().get();
            this.perfCounterRawCountCalculator(this.packetsOutgoingCounter, txPackets);
            this.perfCounterBulkCountCalculator(this.packetsOutgoingPerSecCounter, txPackets);
        } else {
            this.perfCounterRawCountCalculator(this.packetsOutgoingCounter, UnknownValueUtil.getUnknownValue());
            this.perfCounterBulkCountCalculator(this.packetsOutgoingPerSecCounter, UnknownValueUtil.getUnknownValue());
        }
        if (sigarNetworkDto.getRxBytesOpt().isPresent()) {
            Long rxBytes = (Long)sigarNetworkDto.getRxBytesOpt().get();
            this.perfCounterRawCountCalculator(this.bytesIncomingCounter, rxBytes);
            this.perfCounterBulkCountCalculator(this.bytesIncomingPerSecCounter, rxBytes);
        } else {
            this.perfCounterRawCountCalculator(this.bytesIncomingCounter, UnknownValueUtil.getUnknownValue());
            this.perfCounterBulkCountCalculator(this.bytesIncomingPerSecCounter, UnknownValueUtil.getUnknownValue());
        }
        if (sigarNetworkDto.getTxBytesOpt().isPresent()) {
            Long txBytes = (Long)sigarNetworkDto.getTxBytesOpt().get();
            this.perfCounterRawCountCalculator(this.bytesOutgoingCounter, txBytes);
            this.perfCounterBulkCountCalculator(this.bytesOutgoingPerSecCounter, txBytes);
        } else {
            this.perfCounterRawCountCalculator(this.bytesOutgoingCounter, UnknownValueUtil.getUnknownValue());
            this.perfCounterBulkCountCalculator(this.bytesOutgoingPerSecCounter, UnknownValueUtil.getUnknownValue());
        }
        if (sigarNetworkDto.getRxErrorsOpt().isPresent()) {
            this.perfCounterRawCountCalculator(this.errorsIncomingCounter, (Long)sigarNetworkDto.getRxErrorsOpt().get());
        } else {
            this.perfCounterRawCountCalculator(this.errorsIncomingCounter, UnknownValueUtil.getUnknownValue());
        }
        if (sigarNetworkDto.getTxErrorsOpt().isPresent()) {
            this.perfCounterRawCountCalculator(this.errorsOutgoingCounter, (Long)sigarNetworkDto.getTxErrorsOpt().get());
        } else {
            this.perfCounterRawCountCalculator(this.errorsOutgoingCounter, UnknownValueUtil.getUnknownValue());
        }
    }

    @Override
    protected String getNetEnabled() {
        if (this.flagsOpt.isPresent()) {
            long flags = (Long)this.flagsOpt.get();
            return (flags & 1L) != 0L ? "yes" : "no";
        }
        return "unknown";
    }

    @Override
    protected String getPluggedIn() {
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getStatus() {
        if (this.flagsOpt.isPresent()) {
            long flags = (Long)this.flagsOpt.get();
            return (flags & 0x40L) != 0L ? "up" : "down";
        }
        return "unknown";
    }

    @Override
    protected String getDuplex() {
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getMtu() {
        if (this.mtuOpt.isPresent()) {
            return String.valueOf(this.mtuOpt.get());
        }
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getSpeedMb() {
        long speedBits;
        if (this.speedBitsPerSecOpt.isPresent() && (speedBits = ((Long)this.speedBitsPerSecOpt.get()).longValue()) != -1L && speedBits != UnsignedInteger.MAX_VALUE.longValue()) {
            return String.valueOf(speedBits / 1000000L);
        }
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getMacAddress() {
        if (this.macAddressOpt.isPresent()) {
            return String.valueOf(this.macAddressOpt.get());
        }
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getIpv4Addresses() {
        if (this.addressOpt.isPresent()) {
            return String.valueOf(this.addressOpt.get());
        }
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getIpv6Addresses() {
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getDefaultIpv4Gateways() {
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected String getDefaultIpv6Gateways() {
        return UnknownValueUtil.getUnknownValueStr();
    }

    @Override
    protected long getIncomingPacketErrors() {
        return this.errorsIncomingCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPacketErrors() {
        return this.errorsOutgoingCounter.getLastCookedResult();
    }

    @Override
    protected long getIncomingKbPerSec() {
        return CalculationUtils.bytesToKilobytes(this.bytesIncomingPerSecCounter.getLastCookedResult());
    }

    @Override
    protected long getOutgoingKbPerSec() {
        return CalculationUtils.bytesToKilobytes(this.bytesOutgoingPerSecCounter.getLastCookedResult());
    }

    @Override
    protected long getIncomingPacketsPerSec() {
        return this.packetsIncomingPerSecCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPacketsPerSec() {
        return this.packetsOutgoingPerSecCounter.getLastCookedResult();
    }

    @Override
    protected Optional<Long> getUtilizationPct() {
        return Optional.absent();
    }

    @Override
    protected long getIncomingKb() {
        return CalculationUtils.bytesToKilobytes(this.bytesIncomingCounter.getLastCookedResult());
    }

    @Override
    protected long getOutgoingKb() {
        return CalculationUtils.bytesToKilobytes(this.bytesOutgoingCounter.getLastCookedResult());
    }

    @Override
    protected long getIncomingPackets() {
        return this.packetsIncomingCounter.getLastCookedResult();
    }

    @Override
    protected long getOutgoingPackets() {
        return this.packetsOutgoingCounter.getLastCookedResult();
    }

    private void perfCounterBulkCountCalculator(PerfCounterBulkCountWithTimestamp counter, BigInteger metric) {
        counter.calculate(metric, this.uptimeInSec);
    }

    private void perfCounterBulkCountCalculator(PerfCounterBulkCountWithTimestamp counter, long metric) {
        this.perfCounterBulkCountCalculator(counter, BigInteger.valueOf(metric));
    }

    private void perfCounterRawCountCalculator(PerfCounterRawCount counter, long metric) {
        counter.calculate(BigInteger.valueOf(metric));
    }
}

