/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarCpuInfoDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import lombok.NonNull;

class SigarCpu
extends Cpu<SigarRawData> {
    private final RawDataLong notImplementedLong;
    private final RawDataString notImplementedString;
    private final RawDataFactory rawDataFactory;
    private SigarCpuInfoDto cpuInfo;

    @Inject
    @VisibleForTesting
    SigarCpu(@Assisted @NonNull String cpuId, @Sim @NonNull MachineProperties machineProperties, @NonNull RawDataFactory rawDataFactory, @NonNull RawDataItemUtil rawDataItemUtil) {
        super(cpuId, machineProperties, rawDataItemUtil);
        if (cpuId == null) {
            throw new NullPointerException("cpuId is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (rawDataFactory == null) {
            throw new NullPointerException("rawDataFactory is marked non-null but is null");
        }
        if (rawDataItemUtil == null) {
            throw new NullPointerException("rawDataItemUtil is marked non-null but is null");
        }
        this.rawDataFactory = rawDataFactory;
        this.notImplementedLong = rawDataFactory.createLong("Not implemented");
        this.notImplementedString = rawDataFactory.createString(Optional.absent(), "Not implemented");
    }

    @Override
    public void update(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpuInfo = rawData.getCpu().getCpuInfos().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.notImplementedLong;
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.rawDataFactory.createLong(Long.valueOf(this.cpuInfo.getLogicalCores()));
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.rawDataFactory.createString(Optional.of((Object)this.cpuInfo.getVendor()));
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.rawDataFactory.createString(Optional.of((Object)this.cpuInfo.getModel()));
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        return this.rawDataFactory.createString(Optional.of((Object)String.valueOf(this.cpuInfo.getMaxSpeedMhz())));
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        return this.notImplementedString;
    }

    @Override
    public void report(SigarRawData rawData, ReportMetricsConfig reportMetricsConfig) {
    }
}

