/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarNetworkDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import lombok.Generated;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Networks
implements IModule<Map<String, SigarNetworkDto>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Networks.class);

    @Inject
    Networks() {
    }

    @Override
    public Optional<Map<String, SigarNetworkDto>> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            ArrayList<String> networkNames = new ArrayList<String>(Arrays.asList(sigar.getNetInterfaceList()));
            ImmutableMap.Builder networkNameToNetworkBuilder = ImmutableMap.builder();
            for (String networkName : networkNames) {
                Optional speedOpt = Optional.absent();
                Optional rxBytesOpt = Optional.absent();
                Optional txBytesOpt = Optional.absent();
                Optional rxPacketsOpt = Optional.absent();
                Optional txPacketsOpt = Optional.absent();
                Optional rxErrorsOpt = Optional.absent();
                Optional txErrorsOpt = Optional.absent();
                NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(networkName);
                if (netInterfaceConfig == null) continue;
                String realNetworkName = netInterfaceConfig.getDescription();
                Optional addressOpt = Optional.of((Object)netInterfaceConfig.getAddress());
                Optional macAddressOpt = Optional.of((Object)netInterfaceConfig.getHwaddr());
                Optional mtuOpt = Optional.of((Object)netInterfaceConfig.getMtu());
                Optional flagsOpt = Optional.of((Object)netInterfaceConfig.getFlags());
                NetInterfaceStat netInterfaceStat = sigar.getNetInterfaceStat(networkName);
                if (netInterfaceStat != null) {
                    speedOpt = Optional.of((Object)netInterfaceStat.getSpeed());
                    rxBytesOpt = Optional.of((Object)netInterfaceStat.getRxBytes());
                    txBytesOpt = Optional.of((Object)netInterfaceStat.getTxBytes());
                    rxPacketsOpt = Optional.of((Object)netInterfaceStat.getRxPackets());
                    txPacketsOpt = Optional.of((Object)netInterfaceStat.getTxPackets());
                    rxErrorsOpt = Optional.of((Object)netInterfaceStat.getRxErrors());
                    txErrorsOpt = Optional.of((Object)netInterfaceStat.getTxErrors());
                }
                SigarNetworkDto networkDto = SigarNetworkDto.builder().name(realNetworkName).uptimeInSec((long)sigar.getUptime().getUptime()).addressOpt((Optional<String>)addressOpt).macAddressOpt((Optional<String>)macAddressOpt).flagsOpt((Optional<Long>)flagsOpt).mtuOpt((Optional<Long>)mtuOpt).speedBitsPerSecOpt((Optional<Long>)speedOpt).rxBytesOpt((Optional<Long>)rxBytesOpt).txBytesOpt((Optional<Long>)txBytesOpt).rxPacketsOpt((Optional<Long>)rxPacketsOpt).txPacketsOpt((Optional<Long>)txPacketsOpt).rxErrorsOpt((Optional<Long>)rxErrorsOpt).txErrorsOpt((Optional<Long>)txErrorsOpt).build();
                networkNameToNetworkBuilder.put((Object)realNetworkName, (Object)networkDto);
            }
            result.setNetworkNameToNetwork((Map<String, SigarNetworkDto>)networkNameToNetworkBuilder.build());
            return Optional.of(result.getNetworkNameToNetwork());
        }
        catch (Exception e) {
            log.error("Error while collecting network metrics", (Throwable)e);
            return Optional.absent();
        }
    }
}

