/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.DependentMetricValueSupplier;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarMemoryDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import lombok.Generated;
import lombok.NonNull;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memory
implements IModule<SigarMemoryDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Memory.class);
    private final DependentMetricValueSupplier dependentMetricValueSupplier;

    @Inject
    Memory(@NonNull DependentMetricValueSupplier dependentMetricValueSupplier) {
        if (dependentMetricValueSupplier == null) {
            throw new NullPointerException("dependentMetricValueSupplier is marked non-null but is null");
        }
        this.dependentMetricValueSupplier = dependentMetricValueSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SigarMemoryDto> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            SigarMemoryDto memory;
            Mem mem = sigar.getMem();
            Swap swap = sigar.getSwap();
            long memTotal = mem.getTotal();
            long memFree = mem.getActualFree();
            long memUsed = mem.getActualUsed();
            long swapTotal = swap.getTotal();
            long swapFree = swap.getFree();
            long swapUsed = swap.getUsed();
            SigarMemoryDto sigarMemoryDto = memory = result.getMemory();
            synchronized (sigarMemoryDto) {
                memory.setMemTotalBytes(memTotal);
                memory.setMemFreeBytes(memFree);
                memory.setMemUsedBytes(memUsed);
                memory.setSwapTotalBytes(swapTotal);
                memory.setSwapFreeBytes(swapFree);
                memory.setSwapUsedBytes(swapUsed);
            }
            this.dependentMetricValueSupplier.setTotalMemoryBytes(memTotal);
            return Optional.of((Object)memory);
        }
        catch (Exception e) {
            log.error("Error while collecting memory metrics", (Throwable)e);
            return Optional.absent();
        }
    }
}

