/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.sigar;

import com.appdynamics.sim.agent.extensions.servers.model.DependentMetricValueSupplier;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.IModule;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarCpuDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarCpuInfoDto;
import com.appdynamics.sim.agent.extensions.servers.model.sigar.SigarRawData;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.HashMap;
import lombok.Generated;
import lombok.NonNull;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cpu
implements IModule<SigarCpuDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Cpu.class);
    private final DependentMetricValueSupplier dependentMetricValueSupplier;

    @Inject
    Cpu(@NonNull DependentMetricValueSupplier dependentMetricValueSupplier) {
        if (dependentMetricValueSupplier == null) {
            throw new NullPointerException("dependentMetricValueSupplier is marked non-null but is null");
        }
        this.dependentMetricValueSupplier = dependentMetricValueSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SigarCpuDto> collectAndUpdate(SigarProxy sigar, SigarRawData result) {
        try {
            CpuPerc cpuPerc = sigar.getCpuPerc();
            double cpuUser = cpuPerc.getUser();
            double cpuSystem = cpuPerc.getSys();
            double cpuNice = cpuPerc.getNice();
            double cpuWait = cpuPerc.getWait();
            double cpuIrq = cpuPerc.getIrq();
            double cpuSoftIrq = cpuPerc.getSoftIrq();
            double cpuIdle = cpuPerc.getIdle();
            double cpuStolen = cpuPerc.getStolen();
            SigarCpuDto cpu = result.getCpu();
            CpuInfo[] cpuInfos = sigar.getCpuInfoList();
            HashMap<String, SigarCpuInfoDto> sigarCpuInfos = new HashMap<String, SigarCpuInfoDto>(cpuInfos.length);
            int i = 0;
            for (CpuInfo cpuInfo : cpuInfos) {
                sigarCpuInfos.put(String.valueOf(i), SigarCpuInfoDto.builder().maxSpeedMhz(cpuInfo.getMhz()).logicalCores(cpuInfo.getTotalCores()).model(cpuInfo.getModel()).vendor(cpuInfo.getVendor()).build());
                ++i;
            }
            SigarCpuDto sigarCpuDto = cpu;
            synchronized (sigarCpuDto) {
                cpu.addCpuUser(cpuUser).addCpuSystem(cpuSystem).addCpuNice(cpuNice).addCpuWait(cpuWait).addCpuIrq(cpuIrq).addCpuSoftIrq(cpuSoftIrq).addCpuIdle(cpuIdle).addCpuStolen(cpuStolen).setCpuInfos(sigarCpuInfos);
            }
            long l = sigarCpuInfos.size();
            this.dependentMetricValueSupplier.setNumCpuLogicalCores(l);
            return Optional.of((Object)cpu);
        }
        catch (Exception e) {
            log.error("Error while collecting cpu metrics", (Throwable)e);
            return Optional.absent();
        }
    }
}

