/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Volume;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxVolumesUtil;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Set;
import lombok.Generated;

@VisibleForAssistedInject
public class NewLinuxVolume
extends Volume<NewLinuxRawData> {
    private NewLinuxRawData.Volume volume;
    private Set<String> validVolumePartitionNames;
    private final boolean calculateUsedPctSameAsDfCommand = Boolean.parseBoolean(System.getProperty("appdynamics.machine.agent.extensions.calcVolumeFreeAndUsedWithDfCommand", "True"));

    @Inject
    @VisibleForTesting
    protected NewLinuxVolume(@Assisted String mountPoint, @Sim MetricsService metricsService, @Sim MachineProperties machineProperties, RawDataFactory factory, RawDataItemUtil dataItemUtil) {
        super(mountPoint, metricsService, machineProperties, factory, dataItemUtil);
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.volume = rawData.getVolumes().get(this.getMountPoint());
        this.validVolumePartitionNames = rawData.getPartitions().keySet();
    }

    @Override
    protected RawDataString getPartitionDisplayName() {
        return NewLinuxVolumesUtil.getBasePartitionName(this.getPartition(), this.getFactory());
    }

    @Override
    protected RawDataString getPartition() {
        if (this.volume.getName().isPresent()) {
            String volumeName = this.volume.getName().get();
            if (this.validVolumePartitionNames.contains(volumeName)) {
                return this.volume.getName();
            }
            return this.getFactory().createString(Optional.absent(), "Could not find matching partition for volume " + volumeName);
        }
        return this.getFactory().createString(Optional.absent(), "No volume name found");
    }

    @Override
    protected RawDataLong getFreeMb() {
        if (this.calculateUsedPctSameAsDfCommand) {
            return this.volume.getFreeSpace();
        }
        return super.getFreeMb();
    }

    @Override
    protected RawDataLong getUsedPctValue() {
        if (this.calculateUsedPctSameAsDfCommand) {
            return this.getDataItemUtil().calculatePercentage(this.getUsedMb(), this.getUsedMb().add(this.getFreeMb()));
        }
        return super.getUsedPctValue();
    }

    @Override
    protected RawDataLong getSizeMb() {
        return this.volume.getTotalSpace();
    }

    @Override
    protected RawDataLong getUsedMb() {
        return this.volume.getUsedSpace();
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxVolume(super=" + super.toString() + ", volume=" + String.valueOf(this.volume) + ", validVolumePartitionNames=" + String.valueOf(this.validVolumePartitionNames) + ", calculateUsedPctSameAsDfCommand=" + this.calculateUsedPctSameAsDfCommand + ")";
    }
}

