/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MetricNameUtil;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.RawDataDeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.util.RawDataRateCalculatorUtil;
import com.appdynamics.sim.common.biz.shared.machines.SimMachineProperties;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.singularity.ee.controller.api.constants.HardwarePerformanceMetricsTemplates;
import java.util.Map;
import lombok.Generated;

@VisibleForAssistedInject
public class NewLinuxPartition
extends Partition<NewLinuxRawData> {
    private static final long BYTES_PER_KBYTE = 1024L;
    private static final String UNKNOWN = "unknown";
    private final RawDataLong rawDataValueTen;
    private final String metricNameCpuTime;
    private final String metricNameServiceTime;
    private final String metricNameQueueTime;
    private final String metricNameQueueTime95thPercentile;
    private final MachineProperties machineProperties;
    private final Provider<ServersMonitorConfig> monitorConfig;
    private final RawDataItemUtil dataItemUtil;
    private final RawDataFactory factory;
    private final boolean calculateFreeSpaceSameAsDfCommand;
    private final RawDataRateCalculatorUtil readsPerSecondCounter;
    private final RawDataRateCalculatorUtil writesPerSecondCounter;
    private final RawDataRateCalculatorUtil readKbPerSecondCounter;
    private final RawDataRateCalculatorUtil writeKbPerSecondCounter;
    private final RawDataDeltaCalculatorUtil readsCounter;
    private final RawDataDeltaCalculatorUtil writeCounter;
    private final RawDataDeltaCalculatorUtil numMillisecondsReadingCounter;
    private final RawDataDeltaCalculatorUtil numMillisecondsWriteCounter;
    private final RawDataDeltaCalculatorUtil queueTimeMillisecondsCounter;
    private final RawDataRateCalculatorUtil numMillisecondsDoingIoCounter;
    private NewLinuxRawData.Partition partitionStats;
    private NewLinuxRawData.Volume volume;
    private String volumeId;
    private RawDataLong currentReadCount;
    private RawDataLong currentWriteCount;
    private RawDataLong currentReadTime;
    private RawDataLong currentWriteTime;
    private RawDataLong currentQueueTime;
    private RawDataLong avgServiceTime;
    private RawDataLong avgQueueTime;

    @Inject
    @VisibleForTesting
    protected NewLinuxPartition(@Assisted String partitionName, @Sim MetricsService metricsService, @Sim MachineProperties machineProperties, Provider<ServersMonitorConfig> monitorConfig, RawDataItemUtil dataItemUtil, RawDataFactory factory) {
        super(partitionName, metricsService, factory);
        this.machineProperties = machineProperties;
        this.dataItemUtil = dataItemUtil;
        this.factory = factory;
        this.calculateFreeSpaceSameAsDfCommand = Boolean.parseBoolean(System.getProperty("appdynamics.machine.agent.extensions.calcVolumeFreeAndUsedWithDfCommand", "True"));
        this.readsPerSecondCounter = this.createRateCalculator();
        this.writesPerSecondCounter = this.createRateCalculator();
        this.readKbPerSecondCounter = this.createRateCalculator();
        this.writeKbPerSecondCounter = this.createRateCalculator();
        this.readsCounter = this.createDeltaCalculator();
        this.writeCounter = this.createDeltaCalculator();
        this.numMillisecondsReadingCounter = this.createDeltaCalculator();
        this.numMillisecondsWriteCounter = this.createDeltaCalculator();
        this.queueTimeMillisecondsCounter = this.createDeltaCalculator();
        this.numMillisecondsDoingIoCounter = this.createRateCalculator();
        this.currentReadCount = this.createRawDataLong();
        this.currentWriteCount = this.createRawDataLong();
        this.currentReadTime = this.createRawDataLong();
        this.currentWriteTime = this.createRawDataLong();
        this.currentQueueTime = this.createRawDataLong();
        this.avgServiceTime = this.createRawDataLong();
        this.avgQueueTime = this.createRawDataLong();
        this.monitorConfig = monitorConfig;
        String normalizedPartitionName = MetricNameUtil.normalizeMetricName(partitionName);
        this.metricNameCpuTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|% CPU Time", (String)normalizedPartitionName);
        this.metricNameServiceTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg Service Time (ms)", (String)normalizedPartitionName);
        this.metricNameQueueTime = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Avg Queue Time (ms)", (String)normalizedPartitionName);
        this.metricNameQueueTime95thPercentile = HardwarePerformanceMetricsTemplates.format((String)"Hardware Resources|Disks|{0}|Queue Time (ms) 95th Percentile", (String)normalizedPartitionName);
        this.rawDataValueTen = factory.createLong(Long.valueOf(10L));
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.partitionStats = rawData.getPartitions().get(this.getPartitionName());
        Map<String, NewLinuxRawData.Volume> volumes = rawData.getVolumes();
        long diskSectorSize = ((ServersMonitorConfig)this.monitorConfig.get()).getDefaultDiskSectorSize();
        if (this.partitionStats.getDiskSectorSize().isPresent() && this.partitionStats.getDiskSectorSize().get() > 0L) {
            diskSectorSize = this.partitionStats.getDiskSectorSize().get();
        }
        double sectorsPerKbyte = 1024.0 / (double)diskSectorSize;
        this.readsPerSecondCounter.calculate(this.partitionStats.getNumReadsCompleted(), this.partitionStats.getTimeStampInSeconds());
        this.writesPerSecondCounter.calculate(this.partitionStats.getNumWritesCompleted(), this.partitionStats.getTimeStampInSeconds());
        if (this.partitionStats.isNfs()) {
            this.readKbPerSecondCounter.calculate(this.dataItemUtil.bytesToKilobytes(this.partitionStats.getReadBytes()), this.partitionStats.getTimeStampInSeconds());
            this.writeKbPerSecondCounter.calculate(this.dataItemUtil.bytesToKilobytes(this.partitionStats.getWriteBytes()), this.partitionStats.getTimeStampInSeconds());
        } else {
            RawDataLong readKbPerSecDataLong = this.partitionStats.getNumSectorsRead().isPresent() ? this.factory.createLong(Long.valueOf(Math.round((double)this.partitionStats.getNumSectorsRead().get().longValue() / sectorsPerKbyte))) : this.factory.createLong(UNKNOWN);
            this.readKbPerSecondCounter.calculate(readKbPerSecDataLong, this.partitionStats.getTimeStampInSeconds());
            RawDataLong writeKbParSecDataLong = this.partitionStats.getNumSectorsWritten().isPresent() ? this.factory.createLong(Long.valueOf(Math.round((double)this.partitionStats.getNumSectorsWritten().get().longValue() / sectorsPerKbyte))) : this.factory.createLong(UNKNOWN);
            this.writeKbPerSecondCounter.calculate(writeKbParSecDataLong, this.partitionStats.getTimeStampInSeconds());
        }
        this.currentReadCount = this.readsCounter.calculate(this.partitionStats.getNumReadsCompleted());
        this.currentWriteCount = this.writeCounter.calculate(this.partitionStats.getNumWritesCompleted());
        this.currentReadTime = this.numMillisecondsReadingCounter.calculate(this.partitionStats.getNumMillisecondsReading());
        this.currentWriteTime = this.numMillisecondsWriteCounter.calculate(this.partitionStats.getNumMillisecondsWriting());
        if (!this.partitionStats.isNfs()) {
            this.calculatePartitionStats();
        } else {
            this.currentQueueTime = this.queueTimeMillisecondsCounter.calculate(this.partitionStats.getQueueTimeMilliseconds());
            if (this.currentReadCount.add(this.currentWriteCount).get() > 0L) {
                this.avgQueueTime = this.currentQueueTime.divide(this.currentReadCount.add(this.currentWriteCount));
                this.avgServiceTime = this.currentReadTime.add(this.currentWriteTime).divide(this.currentReadCount.add(this.currentWriteCount));
            }
        }
        for (Map.Entry<String, NewLinuxRawData.Volume> entry : volumes.entrySet()) {
            NewLinuxRawData.Volume v = entry.getValue();
            if (!v.getName().equals((Object)this.partitionStats.getName())) continue;
            String mountPoint = entry.getKey();
            this.volume = v;
            this.volumeId = mountPoint;
            break;
        }
    }

    @Override
    protected void doReporting(ReportMetricsConfig reportMetricsConfig) {
        super.doReporting(reportMetricsConfig);
        if (reportMetricsConfig.isReportBasicMetrics()) {
            if (!this.partitionStats.isNfs()) {
                this.metricsService.reportMetric(this.metricNameCpuTime, ExtensionMetricAggregatorType.AVERAGE, this.getCPUUtilization());
            }
            this.metricsService.reportMetric(this.metricNameQueueTime, ExtensionMetricAggregatorType.AVERAGE, this.getAvgQueueTime());
            this.metricsService.reportMetric(this.metricNameServiceTime, ExtensionMetricAggregatorType.AVERAGE, this.getAvgServiceTime());
        }
        if (reportMetricsConfig.isReportSimMetrics() && !this.partitionStats.isNfs() && this.partitionStats.getName().isPresent()) {
            this.machineProperties.updateProperty(SimMachineProperties.format((String)"Disk|{0}|Sector Size Bytes", (String)this.partitionStats.getName().get()), this.dataItemUtil.rawDataLongToRawDataString(this.partitionStats.getDiskSectorSize()), Optional.of((Object)UNKNOWN));
        }
        if (reportMetricsConfig.isReportPercentileMetrics()) {
            this.metricsService.reportMetric(this.metricNameQueueTime95thPercentile, ExtensionMetricAggregatorType.PERCENTILE, this.getAvgQueueTime());
        }
    }

    @Override
    public RawDataLong getReadCountPerSec() {
        return this.readsPerSecondCounter.getLastResult();
    }

    @Override
    public RawDataLong getReadKbPerSec() {
        return this.readKbPerSecondCounter.getLastResult();
    }

    @Override
    public RawDataLong getAvgReadTimeMillis() {
        if (this.currentReadTime.isPresent() && this.currentReadCount.isPresent() && this.currentReadTime.get() > 0L && this.currentReadCount.get() > 0L) {
            return this.currentReadTime.divide(this.currentReadCount);
        }
        return RawDataConstants.ZERO_LONG;
    }

    @Override
    public RawDataLong getWriteCountPerSec() {
        return this.writesPerSecondCounter.getLastResult();
    }

    @Override
    public RawDataLong getWriteKbPerSec() {
        return this.writeKbPerSecondCounter.getLastResult();
    }

    @Override
    public RawDataLong getAvgWriteTimeMillis() {
        if (this.currentWriteTime.isPresent() && this.currentWriteCount.isPresent() && this.currentWriteTime.get() > 0L && this.currentWriteCount.get() > 0L) {
            return this.currentWriteTime.divide(this.currentWriteCount);
        }
        return RawDataConstants.ZERO_LONG;
    }

    @Override
    public RawDataLong getUtilization() {
        if (this.partitionStats.isNfs()) {
            return this.factory.createLong(UNKNOWN);
        }
        return this.numMillisecondsDoingIoCounter.getLastResult().divide(this.rawDataValueTen);
    }

    @Override
    public RawDataLong getSpaceAvailableKb() {
        if (this.volume != null) {
            RawDataLong result = this.calculateFreeSpaceSameAsDfCommand ? this.volume.getFreeSpace() : this.volume.getTotalSpace().subtract(this.volume.getUsedSpace());
            return this.dataItemUtil.megabytesToKilobytes(result);
        }
        return RawDataConstants.ZERO_LONG;
    }

    @Override
    public RawDataLong getSpaceUsedKb() {
        if (this.volume != null) {
            return this.dataItemUtil.megabytesToKilobytes(this.volume.getUsedSpace());
        }
        return RawDataConstants.ZERO_LONG;
    }

    public RawDataLong getCPUUtilization() {
        return this.numMillisecondsDoingIoCounter.getLastResult().divide(this.rawDataValueTen);
    }

    public RawDataLong getAvgServiceTime() {
        return this.avgServiceTime;
    }

    public RawDataLong getAvgQueueTime() {
        return this.avgQueueTime;
    }

    private void calculatePartitionStats() {
        this.numMillisecondsDoingIoCounter.calculate(this.partitionStats.getNumMillisecondsDoingIo(), this.partitionStats.getTimeStampInSeconds());
        try {
            this.avgServiceTime = this.currentWriteCount.add(this.currentReadCount).get() > 0L ? this.numMillisecondsDoingIoCounter.getLastResult().divide(this.currentWriteCount.add(this.currentReadCount)) : this.factory.createLong(Long.valueOf(0L));
        }
        catch (Exception e) {
            this.avgServiceTime = this.factory.createLong(Long.valueOf(0L));
        }
        try {
            if (this.currentReadCount.add(this.currentWriteCount).get() > 0L && this.currentReadTime.add(this.currentWriteTime).get() > 0L) {
                RawDataLong avgWaitTime = this.currentWriteTime.add(this.currentReadTime).divide(this.currentWriteCount.add(this.currentReadCount));
                this.avgQueueTime = avgWaitTime.subtract(this.avgServiceTime);
            } else {
                this.avgQueueTime = this.factory.createLong(Long.valueOf(0L));
            }
        }
        catch (Exception e) {
            this.avgQueueTime = this.factory.createLong(Long.valueOf(0L));
        }
    }

    private RawDataDeltaCalculatorUtil createDeltaCalculator() {
        return RawDataDeltaCalculatorUtil.builder().factory(this.factory).build();
    }

    private RawDataRateCalculatorUtil createRateCalculator() {
        return RawDataRateCalculatorUtil.builder().factory(this.factory).build();
    }

    private RawDataLong createRawDataLong() {
        return this.factory.createLong("");
    }

    @Override
    public Optional<String> getVolumeId() {
        return Optional.fromNullable((Object)this.volumeId);
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxPartition(super=" + super.toString() + ", rawDataValueTen=" + String.valueOf(this.rawDataValueTen) + ", metricNameCpuTime=" + this.metricNameCpuTime + ", metricNameServiceTime=" + this.metricNameServiceTime + ", metricNameQueueTime=" + this.metricNameQueueTime + ", metricNameQueueTime95thPercentile=" + this.metricNameQueueTime95thPercentile + ", machineProperties=" + String.valueOf(this.machineProperties) + ", monitorConfig=" + String.valueOf(this.monitorConfig) + ", dataItemUtil=" + String.valueOf(this.dataItemUtil) + ", factory=" + String.valueOf(this.factory) + ", calculateFreeSpaceSameAsDfCommand=" + this.calculateFreeSpaceSameAsDfCommand + ", readsPerSecondCounter=" + String.valueOf(this.readsPerSecondCounter) + ", writesPerSecondCounter=" + String.valueOf(this.writesPerSecondCounter) + ", readKbPerSecondCounter=" + String.valueOf(this.readKbPerSecondCounter) + ", writeKbPerSecondCounter=" + String.valueOf(this.writeKbPerSecondCounter) + ", readsCounter=" + String.valueOf(this.readsCounter) + ", writeCounter=" + String.valueOf(this.writeCounter) + ", numMillisecondsReadingCounter=" + String.valueOf(this.numMillisecondsReadingCounter) + ", numMillisecondsWriteCounter=" + String.valueOf(this.numMillisecondsWriteCounter) + ", queueTimeMillisecondsCounter=" + String.valueOf(this.queueTimeMillisecondsCounter) + ", numMillisecondsDoingIoCounter=" + String.valueOf(this.numMillisecondsDoingIoCounter) + ", partitionStats=" + String.valueOf(this.partitionStats) + ", volume=" + String.valueOf(this.volume) + ", volumeId=" + String.valueOf(this.getVolumeId()) + ", currentReadCount=" + String.valueOf(this.currentReadCount) + ", currentWriteCount=" + String.valueOf(this.currentWriteCount) + ", currentReadTime=" + String.valueOf(this.currentReadTime) + ", currentWriteTime=" + String.valueOf(this.currentWriteTime) + ", currentQueueTime=" + String.valueOf(this.currentQueueTime) + ", avgServiceTime=" + String.valueOf(this.getAvgServiceTime()) + ", avgQueueTime=" + String.valueOf(this.getAvgQueueTime()) + ")";
    }
}

