/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Network;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import io.dropwizard.util.SizeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class NewLinuxNetwork
extends Network<NewLinuxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxNetwork.class);
    private static final long FLAG_UP = 1L;
    private static final String BLANK = "";
    private static final String FULL = "full";
    private static final long U32_MAX = 0xFFFFFFFFL;
    private static final long U16_MAX = 65535L;
    private final DeltaCalculatorUtil incomingBytesCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingBytesCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil incomingPacketsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingPacketsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil incomingPacketErrorsCalculator = new DeltaCalculatorUtil();
    private final DeltaCalculatorUtil outgoingPacketErrorsCalculator = new DeltaCalculatorUtil();
    private final RateCalculatorUtil incomingBytesPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil outgoingBytesPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil incomingPacketsPerSecCalculator = new RateCalculatorUtil();
    private final RateCalculatorUtil outgoingPacketsPerSecCalculator = new RateCalculatorUtil();
    private NewLinuxRawData.NetworkInfoViaSysClassNet networkInfoViaSysClassNet;
    private NewLinuxRawData.NetworkInfoViaIpAddr networkInfoViaIpAddr;
    private NewLinuxRawData.NetworkInfoViaProcNetDev networkInfoViaProcNetDev;
    private Optional<String> ipv4DefaultGatewayOpt;
    private Optional<String> ipv6DefaultGatewayOpt;

    @Inject
    @VisibleForTesting
    NewLinuxNetwork(@Assisted String networkName, MachineProperties machineProperties, MetricsService metricsService) {
        super(networkName, machineProperties, metricsService);
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        String networkName = this.getNetworkName();
        this.networkInfoViaSysClassNet = rawData.getNetworkToSysClassNet().get(networkName);
        this.networkInfoViaIpAddr = rawData.getNetworkToIpAddr().get(networkName);
        this.networkInfoViaProcNetDev = rawData.getNetworkToProcNetDev().get(networkName);
        this.ipv4DefaultGatewayOpt = Optional.fromNullable((Object)rawData.getNetworkToIpv4DefaultGateway().get(networkName));
        this.ipv6DefaultGatewayOpt = Optional.fromNullable((Object)rawData.getNetworkToIpv6DefaultGateway().get(networkName));
        long incomingBytes = this.networkInfoViaProcNetDev.getIncomingBytes();
        long outgoingBytes = this.networkInfoViaProcNetDev.getOutgoingBytes();
        long incomingPackets = this.networkInfoViaProcNetDev.getIncomingPackets();
        long outgoingPackets = this.networkInfoViaProcNetDev.getOutgoingPackets();
        this.incomingBytesCalculator.calculate(incomingBytes);
        this.outgoingBytesCalculator.calculate(outgoingBytes);
        this.incomingPacketsCalculator.calculate(incomingPackets);
        this.outgoingPacketsCalculator.calculate(outgoingPackets);
        this.incomingPacketErrorsCalculator.calculate(this.networkInfoViaProcNetDev.getIncomingPacketErrors());
        this.outgoingPacketErrorsCalculator.calculate(this.networkInfoViaProcNetDev.getOutgoingPacketErrors());
        long timeStamp = this.networkInfoViaProcNetDev.getUtcTimeStamp();
        this.incomingBytesPerSecCalculator.calculate(incomingBytes, timeStamp);
        this.outgoingBytesPerSecCalculator.calculate(outgoingBytes, timeStamp);
        this.incomingPacketsPerSecCalculator.calculate(incomingPackets, timeStamp);
        this.outgoingPacketsPerSecCalculator.calculate(outgoingPackets, timeStamp);
    }

    @Override
    protected String getNetEnabled() {
        try {
            long flags = Integer.decode(this.networkInfoViaSysClassNet.getFlags()).intValue();
            return (flags & 1L) != 0L ? "yes" : "no";
        }
        catch (NumberFormatException e) {
            return "unknown";
        }
    }

    @Override
    protected String getPluggedIn() {
        long carrier = this.networkInfoViaSysClassNet.getCarrier();
        return NewLinuxNetwork.valueToNoYesUnknown(carrier);
    }

    @Override
    protected String getStatus() {
        return this.networkInfoViaSysClassNet.getOperstate().toLowerCase();
    }

    @Override
    protected String getDuplex() {
        return this.networkInfoViaSysClassNet.getDuplex().toLowerCase();
    }

    @Override
    protected String getMtu() {
        long mtu = this.networkInfoViaSysClassNet.getMtu();
        return mtu >= 0L ? String.valueOf(mtu) : "unknown";
    }

    @Override
    protected String getSpeedMb() {
        return String.valueOf(this.getSpeedMegaBits());
    }

    @Override
    protected String getMacAddress() {
        return this.networkInfoViaSysClassNet.getAddress();
    }

    @Override
    protected String getIpv4Addresses() {
        return this.networkInfoViaIpAddr.getIpv4();
    }

    @Override
    protected String getIpv6Addresses() {
        return this.networkInfoViaIpAddr.getIpv6();
    }

    @Override
    protected String getDefaultIpv4Gateways() {
        return (String)this.ipv4DefaultGatewayOpt.or((Object)BLANK);
    }

    @Override
    protected String getDefaultIpv6Gateways() {
        return (String)this.ipv6DefaultGatewayOpt.or((Object)BLANK);
    }

    @Override
    protected long getIncomingKb() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKb() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPackets() {
        return this.incomingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPackets() {
        return this.outgoingPacketsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingPacketErrors() {
        return this.incomingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketErrors() {
        return this.outgoingPacketErrorsCalculator.getLastResult();
    }

    @Override
    protected long getIncomingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.incomingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getOutgoingKbPerSec() {
        return SizeUnit.BYTES.toKilobytes(this.outgoingBytesPerSecCalculator.getLastResult());
    }

    @Override
    protected long getIncomingPacketsPerSec() {
        return this.incomingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected long getOutgoingPacketsPerSec() {
        return this.outgoingPacketsPerSecCalculator.getLastResult();
    }

    @Override
    protected Optional<Long> getUtilizationPct() {
        long maxBits = this.getSpeedMegaBits() * 1000000L;
        if (this.getDuplex().equals(FULL)) {
            maxBits *= 2L;
        }
        if (maxBits == 0L) {
            return Optional.absent();
        }
        long totalBytesPerSec = this.incomingBytesPerSecCalculator.getLastResult() + this.outgoingBytesPerSecCalculator.getLastResult();
        return Optional.of((Object)CalculationUtils.calculatePercentage(CalculationUtils.bytesToBits(totalBytesPerSec), maxBits));
    }

    @VisibleForTesting
    long getSpeedMegaBits() {
        long speed = this.networkInfoViaSysClassNet.getSpeed();
        if (UnknownValueUtil.isUnknownValue(speed) || speed == 65535L || speed == 0xFFFFFFFFL) {
            log.debug("Adjusting speed to unknown");
            speed = 0L;
        }
        return speed;
    }

    private static String valueToNoYesUnknown(long value) {
        if (value == 0L) {
            return "no";
        }
        if (value == 1L) {
            return "yes";
        }
        return "unknown";
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxNetwork(super=" + super.toString() + ", incomingBytesCalculator=" + String.valueOf(this.incomingBytesCalculator) + ", outgoingBytesCalculator=" + String.valueOf(this.outgoingBytesCalculator) + ", incomingPacketsCalculator=" + String.valueOf(this.incomingPacketsCalculator) + ", outgoingPacketsCalculator=" + String.valueOf(this.outgoingPacketsCalculator) + ", incomingPacketErrorsCalculator=" + String.valueOf(this.incomingPacketErrorsCalculator) + ", outgoingPacketErrorsCalculator=" + String.valueOf(this.outgoingPacketErrorsCalculator) + ", incomingBytesPerSecCalculator=" + String.valueOf(this.incomingBytesPerSecCalculator) + ", outgoingBytesPerSecCalculator=" + String.valueOf(this.outgoingBytesPerSecCalculator) + ", incomingPacketsPerSecCalculator=" + String.valueOf(this.incomingPacketsPerSecCalculator) + ", outgoingPacketsPerSecCalculator=" + String.valueOf(this.outgoingPacketsPerSecCalculator) + ", networkInfoViaSysClassNet=" + String.valueOf(this.networkInfoViaSysClassNet) + ", networkInfoViaIpAddr=" + String.valueOf(this.networkInfoViaIpAddr) + ", networkInfoViaProcNetDev=" + String.valueOf(this.networkInfoViaProcNetDev) + ", ipv4DefaultGatewayOpt=" + String.valueOf(this.ipv4DefaultGatewayOpt) + ", ipv6DefaultGatewayOpt=" + String.valueOf(this.ipv6DefaultGatewayOpt) + ")";
    }
}

