/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.ExtensionMetricAggregatorType;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.util.DeltaCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.appdynamics.sim.agent.extensions.servers.util.CalculationUtils;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class NewLinuxCpus
extends Cpus<NewLinuxRawData> {
    private NewLinuxRawData.CpuPerf cpuPerf;
    private final DeltaCalculatorUtil idleTicksCalculator;
    private final DeltaCalculatorUtil totalTicksCalculator;
    private final DeltaCalculatorUtil stolenTicksCalculator;
    private final DeltaCalculatorUtil userTicksCalculator;
    private final DeltaCalculatorUtil systemTicksCalculator;
    private final DeltaCalculatorUtil niceTicksCalculator;
    private final DeltaCalculatorUtil irqTicksCalculator;
    private final DeltaCalculatorUtil softIrqTicksCalculator;
    private final DeltaCalculatorUtil waitTicksCalculator;

    @Inject
    protected NewLinuxCpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<NewLinuxRawData, Cpu<NewLinuxRawData>> cpuFactory, @NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<NewLinuxRawData>> filters, @NonNull Set<Transformer<Cpu<NewLinuxRawData>>> metadataTransformers, Predicate<ToggleableReporter<NewLinuxRawData>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, metricsService, machineProperties, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        this.idleTicksCalculator = new DeltaCalculatorUtil();
        this.totalTicksCalculator = new DeltaCalculatorUtil();
        this.stolenTicksCalculator = new DeltaCalculatorUtil();
        this.userTicksCalculator = new DeltaCalculatorUtil();
        this.systemTicksCalculator = new DeltaCalculatorUtil();
        this.niceTicksCalculator = new DeltaCalculatorUtil();
        this.irqTicksCalculator = new DeltaCalculatorUtil();
        this.softIrqTicksCalculator = new DeltaCalculatorUtil();
        this.waitTicksCalculator = new DeltaCalculatorUtil();
    }

    @Override
    protected Set<String> extractIds(NewLinuxRawData rawData) {
        return Collections.unmodifiableSet(rawData.getCpus().keySet());
    }

    @Override
    protected void doAggregateUpdate(NewLinuxRawData rawData) {
        this.cpuPerf = rawData.getCpuPerfs().get("_Total");
        this.idleTicksCalculator.calculate(this.cpuPerf.getIdleTicks());
        this.totalTicksCalculator.calculate(this.cpuPerf.getTotalTicks());
        this.stolenTicksCalculator.calculate(this.cpuPerf.getStolenTicks());
        this.userTicksCalculator.calculate(this.cpuPerf.getUserTicks());
        this.systemTicksCalculator.calculate(this.cpuPerf.getSystemTicks());
        this.niceTicksCalculator.calculate(this.cpuPerf.getNiceTicks());
        this.irqTicksCalculator.calculate(this.cpuPerf.getIrqTicks());
        this.softIrqTicksCalculator.calculate(this.cpuPerf.getSoftIrqTicks());
        this.waitTicksCalculator.calculate(this.cpuPerf.getWaitTicks());
    }

    @Override
    protected void doAggregateReporting(NewLinuxRawData rawData, Map<String, ? extends Cpu<NewLinuxRawData>> components, ReportMetricsConfig reportMetricsConfig) {
        if (this.firstTime) {
            this.firstTime = false;
            return;
        }
        super.doAggregateReporting(rawData, components, reportMetricsConfig);
        if (reportMetricsConfig.isReportPercentileMetrics()) {
            this.metricsService.reportMetric("Hardware Resources|CPU|IOWait 95th Percentile", ExtensionMetricAggregatorType.PERCENTILE, ((Long)this.getPercentIoWait().get()).longValue());
        }
    }

    @Override
    protected long getPercentIdle() {
        return CalculationUtils.calculatePercentage(this.idleTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult());
    }

    @Override
    protected long getPercentBusy() {
        return 100L - this.getPercentIdle();
    }

    @Override
    protected Optional<Long> getPercentStolen() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.stolenTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentUser() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.userTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentSystem() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.systemTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentNice() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.niceTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentIRQ() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.irqTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentSoftIRQ() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.softIrqTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    protected Optional<Long> getPercentIoWait() {
        return Optional.of((Object)CalculationUtils.calculatePercentage(this.waitTicksCalculator.getLastResult(), this.totalTicksCalculator.getLastResult()));
    }

    @Override
    @Generated
    public String toString() {
        return "NewLinuxCpus(super=" + super.toString() + ", cpuPerf=" + String.valueOf(this.cpuPerf) + ", idleTicksCalculator=" + String.valueOf(this.idleTicksCalculator) + ", totalTicksCalculator=" + String.valueOf(this.totalTicksCalculator) + ", stolenTicksCalculator=" + String.valueOf(this.stolenTicksCalculator) + ", userTicksCalculator=" + String.valueOf(this.userTicksCalculator) + ", systemTicksCalculator=" + String.valueOf(this.systemTicksCalculator) + ", niceTicksCalculator=" + String.valueOf(this.niceTicksCalculator) + ", irqTicksCalculator=" + String.valueOf(this.irqTicksCalculator) + ", softIrqTicksCalculator=" + String.valueOf(this.softIrqTicksCalculator) + ", waitTicksCalculator=" + String.valueOf(this.waitTicksCalculator) + ")";
    }
}

