/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataItemUtil;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataString;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.newlinux.NewLinuxRawData;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLinuxCpu
extends Cpu<NewLinuxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxCpu.class);
    private static final String CPU_SPEED_REGEX = "@[ \t]";
    private static final String SPEED_UNIT_GHZ = "GHz";
    private static final String SPEED_UNIT_MHZ = "MHz";
    private static final String CPU_MAX_SPEED_UNKNOWN = "unknown";
    private static final int MHZ_PER_GHZ = 1000;
    private RawDataFactory factory;
    private NewLinuxRawData.Cpu cpu;

    @Inject
    private NewLinuxCpu(@Assisted String cpuId, @Sim MachineProperties machineProperties, RawDataItemUtil rawDataItemUtil, RawDataFactory factory) {
        super(cpuId, machineProperties, rawDataItemUtil);
        this.factory = factory;
    }

    @Override
    public void update(NewLinuxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.cpu = rawData.getCpus().get(this.getCpuId());
    }

    @Override
    protected RawDataLong getNumLogicalProcessors() {
        return this.cpu.getLogicalProcessorCount();
    }

    @Override
    protected RawDataLong getNumCores() {
        return this.cpu.getCoreCount();
    }

    @Override
    protected RawDataString getCpuVendor() {
        return this.cpu.getVendor();
    }

    @Override
    protected RawDataString getCpuModel() {
        return this.cpu.getModel();
    }

    @Override
    protected RawDataString getCpuMaxSpeedMhz() {
        if (!this.cpu.getModel().isPresent()) {
            return this.factory.createString(Optional.of((Object)CPU_MAX_SPEED_UNKNOWN));
        }
        return this.factory.createString(NewLinuxCpu.extractMaxCpuSpeedMhzFromModel(this.cpu.getModel().get()));
    }

    @Override
    protected RawDataString getCpuCurrentSpeedMhz() {
        return this.cpu.getSpeedMhz();
    }

    @Override
    protected Map<String, RawDataString> getOsSpecificProperties() {
        if (this.cpu.getFlags() != null) {
            return ImmutableMap.of((Object)"CPU|{0}|Flags", (Object)this.cpu.getFlags());
        }
        return Collections.emptyMap();
    }

    @VisibleForTesting
    static Optional<String> extractMaxCpuSpeedMhzFromModel(@NonNull String modelName) {
        if (modelName == null) {
            throw new NullPointerException("modelName is marked non-null but is null");
        }
        if (modelName.isEmpty()) {
            return Optional.of((Object)CPU_MAX_SPEED_UNKNOWN);
        }
        String[] tokens = modelName.split(CPU_SPEED_REGEX);
        if (tokens.length != 2) {
            return Optional.of((Object)CPU_MAX_SPEED_UNKNOWN);
        }
        String maxSpeed = CPU_MAX_SPEED_UNKNOWN;
        try {
            String speed = tokens[1].substring(0, tokens[1].length() - 3).trim();
            if (tokens[1].endsWith(SPEED_UNIT_GHZ)) {
                maxSpeed = String.valueOf(Math.round(Double.parseDouble(speed) * 1000.0));
            } else if (tokens[1].endsWith(SPEED_UNIT_MHZ)) {
                maxSpeed = String.valueOf(Math.round(Double.parseDouble(speed)));
            } else {
                log.debug("Model name does not contain valid unit for cpu speed.");
            }
        }
        catch (Exception e) {
            log.warn("Could not extract max speed from cpu model ", (Throwable)e);
        }
        return Optional.of((Object)maxSpeed);
    }
}

