/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.newlinux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewLinuxCollectorEnvironmentVariableSupplier
implements Supplier<Map<String, String>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NewLinuxCollectorEnvironmentVariableSupplier.class);
    private final BootstrapConfiguration bootstrapConfiguration;
    private final SimAgentRepetitiveLogger repetitiveLogger;

    @Inject
    NewLinuxCollectorEnvironmentVariableSupplier(@NonNull BootstrapConfiguration bootstrapConfiguration, SimAgentRepetitiveLogger repetitiveLogger) {
        if (bootstrapConfiguration == null) {
            throw new NullPointerException("bootstrapConfiguration is marked non-null but is null");
        }
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.repetitiveLogger = repetitiveLogger;
    }

    public Map<String, String> get() {
        boolean dockerEnabled = this.bootstrapConfiguration.getDockerEnabled();
        boolean containerdEnabled = this.bootstrapConfiguration.getContainerdEnabled();
        boolean gpuEnabled = this.bootstrapConfiguration.getGpuEnabled();
        String hostroot = "";
        if (dockerEnabled || containerdEnabled) {
            if (dockerEnabled && containerdEnabled) {
                this.repetitiveLogger.info(log, "Both Docker and Containerd are enabled. Please enable only one of them", new Object[0]);
                return ImmutableMap.builder().put((Object)"APPDYNAMICS_MACHINE_AGENT_GPU_ENABLED", (Object)String.valueOf(gpuEnabled)).build();
            }
            if (dockerEnabled) {
                this.repetitiveLogger.info(log, "Docker is enabled. Metrics will be collected for the physical host machine", new Object[0]);
            } else {
                this.repetitiveLogger.info(log, "Containerd is enabled. Metrics will be collected for the physical host machine", new Object[0]);
            }
            hostroot = this.bootstrapConfiguration.getBindMountOfHostRoot();
        }
        if (gpuEnabled) {
            this.repetitiveLogger.info(log, "GPU monitoring is enabled. GPU metrics will be collected.", new Object[0]);
        }
        return ImmutableMap.builder().put((Object)"APPDYNAMICS_CONTAINERD_ENABLED", (Object)String.valueOf(containerdEnabled)).put((Object)"APPDYNAMICS_DOCKER_ENABLED", (Object)String.valueOf(dockerEnabled)).put((Object)"APPDYNAMICS_DOCKER_MOUNTED_HOST_ROOT", (Object)hostroot).put((Object)"APPDYNAMICS_MACHINE_AGENT_GPU_ENABLED", (Object)String.valueOf(gpuEnabled)).build();
    }
}

