/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataConstants;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.api.util.RateCalculatorUtil;
import com.appdynamics.sim.agent.extensions.servers.Sim;
import com.appdynamics.sim.agent.extensions.servers.config.ReportMetricsConfig;
import com.appdynamics.sim.agent.extensions.servers.model.Partition;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@VisibleForAssistedInject
public class HpUxPartition
extends Partition<HpUxRawData> {
    private HpUxRawData.Partition partition;
    private Set<HpUxRawData.Volume> volumes;
    private HpUxRawData rawData;
    private RateCalculatorUtil readKbPerSecCounter;
    private RateCalculatorUtil writeKbPerSecCounter;
    private String volumeId;
    private final RawDataFactory factory;

    @Inject
    private HpUxPartition(@Assisted String partitionName, @Sim MetricsService metricsService, RawDataFactory factory) {
        super(partitionName, metricsService, factory);
        this.factory = factory;
        this.readKbPerSecCounter = new RateCalculatorUtil();
        this.writeKbPerSecCounter = new RateCalculatorUtil();
    }

    @Override
    public void update(HpUxRawData rawData, ReportMetricsConfig reportMetricsConfig) {
        this.rawData = rawData;
        this.partition = rawData.getPartitions().get(this.getPartitionName());
        this.volumes = new HashSet<HpUxRawData.Volume>(rawData.getVolumes().values());
        this.readKbPerSecCounter.calculate(this.partition.getReadKbPerSec() * this.partition.getTimeStampInSeconds().longValue(), this.partition.getTimeStampInSeconds().longValue());
        this.writeKbPerSecCounter.calculate(this.partition.getWriteKbPerSec() * this.partition.getTimeStampInSeconds().longValue(), this.partition.getTimeStampInSeconds().longValue());
        for (Map.Entry<String, HpUxRawData.Volume> entry : rawData.getVolumes().entrySet()) {
            HpUxRawData.Volume v = entry.getValue();
            if (!v.getName().equalsIgnoreCase(this.getPartitionName())) continue;
            this.volumeId = entry.getKey();
            break;
        }
    }

    @Override
    public RawDataLong getReadCountPerSec() {
        return RawDataConstants.ABSENT_LONG;
    }

    @Override
    public RawDataLong getReadKbPerSec() {
        return this.factory.createLong(Long.valueOf(this.readKbPerSecCounter.getLastResult()));
    }

    @Override
    public RawDataLong getAvgReadTimeMillis() {
        return RawDataConstants.ABSENT_LONG;
    }

    @Override
    public RawDataLong getWriteCountPerSec() {
        return RawDataConstants.ABSENT_LONG;
    }

    @Override
    public RawDataLong getWriteKbPerSec() {
        return this.factory.createLong(Long.valueOf(this.writeKbPerSecCounter.getLastResult()));
    }

    @Override
    public RawDataLong getAvgWriteTimeMillis() {
        return RawDataConstants.ABSENT_LONG;
    }

    @Override
    public RawDataLong getUtilization() {
        return this.factory.createLong(Long.valueOf(this.partition.getIoUtilizationPct()));
    }

    @Override
    public RawDataLong getSpaceAvailableKb() {
        if (this.rawData.getVolumes() == null) {
            return this.factory.createLong(Long.valueOf(0L));
        }
        for (HpUxRawData.Volume volume : this.volumes) {
            if (!this.getPartitionName().equals(volume.getName())) continue;
            return this.factory.createLong(Long.valueOf(volume.getTotalKb() - volume.getUsedKb()));
        }
        return this.factory.createLong(Long.valueOf(0L));
    }

    @Override
    public RawDataLong getSpaceUsedKb() {
        if (this.rawData.getVolumes() == null) {
            return this.factory.createLong(Long.valueOf(0L));
        }
        for (HpUxRawData.Volume volume : this.volumes) {
            if (!this.getPartitionName().equals(volume.getName())) continue;
            return this.factory.createLong(Long.valueOf(volume.getUsedKb()));
        }
        return this.factory.createLong(Long.valueOf(0L));
    }

    @Override
    public Optional<String> getVolumeId() {
        return Optional.fromNullable((Object)this.volumeId);
    }

    @Override
    @Generated
    public String toString() {
        return "HpUxPartition(super=" + super.toString() + ", partition=" + String.valueOf(this.partition) + ", volumes=" + String.valueOf(this.volumes) + ", rawData=" + String.valueOf(this.rawData) + ", readKbPerSecCounter=" + String.valueOf(this.readKbPerSecCounter) + ", writeKbPerSecCounter=" + String.valueOf(this.writeKbPerSecCounter) + ", volumeId=" + String.valueOf(this.getVolumeId()) + ", factory=" + String.valueOf(this.factory) + ")";
    }
}

