/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.agent.sim.configuration.bootstrap.BootstrapConfiguration;
import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataFactory;
import com.appdynamics.sim.agent.extensions.api.rawdata.RawDataLong;
import com.appdynamics.sim.agent.extensions.servers.ProcessProperties;
import com.appdynamics.sim.agent.extensions.servers.config.ServersMonitorConfig;
import com.appdynamics.sim.agent.extensions.servers.model.MonitoredProcessClass;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.sim.agent.extensions.servers.util.NixUtils;
import com.appdynamics.sim.agent.extensions.servers.util.Pair;
import com.appdynamics.sim.agent.extensions.servers.util.UnknownValueUtil;
import com.appdynamics.sim.processes.common.rest.SimProcessDtoState;
import com.appdynamics.sim.processes.common.rest.SimProcessObservationDto;
import com.appdynamics.voltron.utils.annotations.VisibleForAssistedInject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForAssistedInject
public class HpUxMonitoredProcessClass
extends MonitoredProcessClass<HpUxRawData> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HpUxMonitoredProcessClass.class);
    private static final String UNKNOWN_VALUE = "Unknown";
    private long memoryUsedKb;
    private long memoryUsedPercent;
    private long cpuUsedPercent;
    private long numThreads;
    private long virtualMemoryKb;
    private long processCount;
    private long majorFaultsRate;
    private long minorFaultsRate;
    private int numProcessors;
    private final RawDataFactory factory;
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessCpuMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, Pair<RawDataLong, Double>> currentProcessMemoryMetrics = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
    private volatile Map<RawDataLong, SimProcessDtoState> currentProcessStateMetrics = new HashMap<RawDataLong, SimProcessDtoState>();
    private Map<RawDataLong, String> currentProcessCommandLineMap = new HashMap<RawDataLong, String>();

    @Inject
    private HpUxMonitoredProcessClass(@Assisted @NonNull String classId, @NonNull MetricsService metricsService, @NonNull Provider<ServersMonitorConfig> serversMonitorConfig, @NonNull ProcessProperties processProperties, @NonNull RawDataFactory factory, SimAgentRepetitiveLogger repetitiveLogger, BootstrapConfiguration bootstrapConfiguration) {
        super(classId, metricsService, serversMonitorConfig, processProperties, repetitiveLogger, factory);
        if (classId == null) {
            throw new NullPointerException("classId is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (serversMonitorConfig == null) {
            throw new NullPointerException("serversMonitorConfig is marked non-null but is null");
        }
        if (processProperties == null) {
            throw new NullPointerException("processProperties is marked non-null but is null");
        }
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        this.bootstrapConfiguration = bootstrapConfiguration;
        this.factory = factory;
    }

    @Override
    protected void updateMetrics(HpUxRawData rawData, List<SimProcessObservationDto> filteredObservations) {
        this.numProcessors = rawData.getTotalNumLogicalProcessors();
        List allProcsData = rawData.getProcData().get((Object)this.getClassId());
        if (allProcsData.isEmpty() || filteredObservations.isEmpty()) {
            return;
        }
        ImmutableSet.Builder filteredProcessIdSetBuilder = new ImmutableSet.Builder();
        for (SimProcessObservationDto simProcessObservationDto : filteredObservations) {
            filteredProcessIdSetBuilder.add((Object)((int)simProcessObservationDto.getProcessId()));
        }
        ImmutableSet filteredProcessIdSet = filteredProcessIdSetBuilder.build();
        ImmutableMap.Builder pidToCpuTimeMap = new ImmutableMap.Builder();
        this.memoryUsedKb = 0L;
        this.numThreads = 0L;
        this.virtualMemoryKb = 0L;
        double memoryUsedPercentDbl = 0.0;
        double cpuUsedPercentDbl = 0.0;
        for (HpUxRawData.ProcessRawData procData : allProcsData) {
            HpUxRawData.ProcessAll process = procData.getProcess();
            int processId = procData.getProcess().getPid();
            long cpuTimeInSeconds = 0L;
            try {
                cpuTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(NixUtils.getTimeInMilis(process.getCpuTime()));
            }
            catch (IllegalArgumentException ex) {
                this.repetitiveLogger.warn(log, ex.getMessage(), new Object[0]);
            }
            if (!filteredProcessIdSet.contains((Object)processId)) continue;
            this.memoryUsedKb += process.getMemoryUsedKb();
            this.numThreads += process.getThreadCount();
            this.virtualMemoryKb += process.getVirtualMemSizeKb();
            try {
                double d = Double.parseDouble(process.getMemoryPercent());
                memoryUsedPercentDbl += d;
                double cpud = Double.parseDouble(process.getCpuPercent());
                cpuUsedPercentDbl += cpud;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.memoryUsedPercent = Math.round(memoryUsedPercentDbl);
        this.cpuUsedPercent = Math.round(cpuUsedPercentDbl);
        this.processCount = filteredObservations.size();
        this.majorFaultsRate = UnknownValueUtil.getUnknownValue();
        this.minorFaultsRate = UnknownValueUtil.getUnknownValue();
    }

    @Override
    public ImmutableList<SimProcessObservationDto> getAllObservations(HpUxRawData rawData) {
        List allProcData = rawData.getProcData().get((Object)this.getClassId());
        ImmutableList.Builder observationsBuilder = ImmutableList.builder();
        this.updateProcessMetricsMap(allProcData);
        for (HpUxRawData.ProcessRawData processRawData : allProcData) {
            HpUxRawData.ProcessAll process = processRawData.getProcess();
            long elapsedTimeInMillis = 0L;
            try {
                elapsedTimeInMillis = NixUtils.getTimeInMilis(process.getElapsedTime());
            }
            catch (IllegalArgumentException e) {
                this.repetitiveLogger.warn(log, e.getMessage(), new Object[0]);
            }
            SimProcessObservationDto observation = new SimProcessObservationDto(elapsedTimeInMillis, processRawData.getProcClass().getProcessClassId(), processRawData.getProcClass().getProcessClass(), process.getName(), (long)process.getPid(), (long)process.getParentId(), process.getCommandLine(), process.getRealUser(), this.getProcessState(process.getState()), Collections.emptyMap());
            observationsBuilder.add((Object)observation);
        }
        return observationsBuilder.build();
    }

    private void updateProcessMetricsMap(List<HpUxRawData.ProcessRawData> procData) {
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newCpuData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, Pair<RawDataLong, Double>> newMemoryData = new HashMap<RawDataLong, Pair<RawDataLong, Double>>();
        HashMap<RawDataLong, String> newCommandLineMap = new HashMap<RawDataLong, String>();
        HashMap<RawDataLong, SimProcessDtoState> newStateData = new HashMap<RawDataLong, SimProcessDtoState>();
        for (HpUxRawData.ProcessRawData processRawData : procData) {
            HpUxRawData.ProcessAll process = processRawData.getProcess();
            RawDataLong pid = this.factory.createLong(Long.valueOf(process.getPid()));
            RawDataLong cpuUsage = this.factory.createLong(Long.valueOf((long)Double.parseDouble(process.getCpuPercent())));
            RawDataLong memoryUsage = this.factory.createLong(Long.valueOf((long)Double.parseDouble(process.getMemoryPercent())));
            Double alpha = this.getAverageAlpha();
            Double expoMovingMemoryAverageValue = (double)memoryUsage.get().longValue() * 1.0;
            Double expoMovingCpuAverageValue = (double)cpuUsage.get().longValue() * 1.0;
            if (this.currentProcessMemoryMetrics.get(pid) != null) {
                Double oldMemoryUsage = this.currentProcessMemoryMetrics.get(pid).getSecond();
                Double oldCpuUsage = this.currentProcessCpuMetrics.get(pid).getSecond();
                expoMovingMemoryAverageValue = oldMemoryUsage + alpha * ((double)memoryUsage.get().longValue() - oldMemoryUsage);
                expoMovingCpuAverageValue = oldCpuUsage + alpha * ((double)cpuUsage.get().longValue() - oldCpuUsage);
            }
            newCpuData.put(pid, Pair.of(cpuUsage, expoMovingCpuAverageValue));
            newMemoryData.put(pid, Pair.of(memoryUsage, expoMovingMemoryAverageValue));
            newCommandLineMap.put(pid, process.getCommandLine());
            newStateData.put(pid, this.getProcessState(!process.getState().trim().isEmpty() ? process.getState() : UNKNOWN_VALUE));
            this.currentProcessStateMetrics.remove(pid);
        }
        this.currentProcessCpuMetrics = newCpuData;
        this.currentProcessMemoryMetrics = newMemoryData;
        this.currentProcessCommandLineMap = newCommandLineMap;
        this.currentProcessStateMetrics.keySet().stream().forEach(key -> newStateData.put((RawDataLong)key, SimProcessDtoState.TERMINATED));
        this.currentProcessStateMetrics = newStateData;
    }

    @Override
    protected RawDataLong getMemoryUsedKb() {
        return this.factory.createLong(Long.valueOf(this.memoryUsedKb));
    }

    @Override
    protected RawDataLong getMemoryUsedPercent() {
        return this.factory.createLong(Long.valueOf(this.memoryUsedPercent));
    }

    @Override
    protected RawDataLong getNumThreads() {
        return this.factory.createLong(Long.valueOf(this.numThreads));
    }

    @Override
    protected RawDataLong getMajorFaultsRate() {
        return this.factory.createLong(Long.valueOf(this.majorFaultsRate));
    }

    @Override
    protected RawDataLong getMinorFaultsRate() {
        return this.factory.createLong(Long.valueOf(this.minorFaultsRate));
    }

    @Override
    protected RawDataLong getCpuUsedPercent() {
        return this.factory.createLong(Long.valueOf(this.cpuUsedPercent));
    }

    @Override
    protected RawDataLong getVirtualMemoryKb() {
        return this.factory.createLong(Long.valueOf(this.virtualMemoryKb));
    }

    @Override
    protected RawDataLong getProcessCount() {
        return this.factory.createLong(Long.valueOf(this.processCount));
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessCpuMetrics() {
        return this.currentProcessCpuMetrics;
    }

    @Override
    public Map<RawDataLong, Pair<RawDataLong, Double>> getCurrentProcessMemoryMetrics() {
        return this.currentProcessMemoryMetrics;
    }

    @Override
    public Map<RawDataLong, String> getCurrentProcessCommandLineMap() {
        return this.currentProcessCommandLineMap;
    }

    @Override
    public Map<RawDataLong, SimProcessDtoState> getCurrentProcessStateMetrics() {
        return this.currentProcessStateMetrics;
    }

    private SimProcessDtoState getProcessState(String state) {
        switch (state) {
            case "S": 
            case "T": {
                return SimProcessDtoState.SLEEPING;
            }
            case "A": 
            case "I": 
            case "R": 
            case "W": {
                return SimProcessDtoState.RUNNING;
            }
            case "Z": {
                return SimProcessDtoState.ZOMBIE;
            }
        }
        return SimProcessDtoState.UNKNOWN;
    }
}

