/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.sim.agent.extensions.servers.model.hpux;

import com.appdynamics.agent.sim.log.SimAgentRepetitiveLogger;
import com.appdynamics.sim.agent.extensions.api.machines.MachineProperties;
import com.appdynamics.sim.agent.extensions.api.metrics.MetricsService;
import com.appdynamics.sim.agent.extensions.servers.model.ComponentFactory;
import com.appdynamics.sim.agent.extensions.servers.model.Cpu;
import com.appdynamics.sim.agent.extensions.servers.model.Cpus;
import com.appdynamics.sim.agent.extensions.servers.model.ToggleableReporter;
import com.appdynamics.sim.agent.extensions.servers.model.filter.Filters;
import com.appdynamics.sim.agent.extensions.servers.model.hpux.HpUxRawData;
import com.appdynamics.sim.agent.extensions.servers.model.transformer.Transformer;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;

public class HpUxCpus
extends Cpus<HpUxRawData> {
    private HpUxRawData.CpuPerf cpuPerf;

    @Inject
    protected HpUxCpus(@NonNull SimAgentRepetitiveLogger repetitiveLogger, @NonNull ComponentFactory<HpUxRawData, Cpu<HpUxRawData>> cpuFactory, @NonNull MetricsService metricsService, @NonNull MachineProperties machineProperties, @NonNull Filters<Cpu<HpUxRawData>> filters, @NonNull Set<Transformer<Cpu<HpUxRawData>>> metadataTransformers, @NonNull Predicate<ToggleableReporter<HpUxRawData>> isDisabledPredicate) {
        super(repetitiveLogger, cpuFactory, metricsService, machineProperties, filters, metadataTransformers, isDisabledPredicate);
        if (repetitiveLogger == null) {
            throw new NullPointerException("repetitiveLogger is marked non-null but is null");
        }
        if (cpuFactory == null) {
            throw new NullPointerException("cpuFactory is marked non-null but is null");
        }
        if (metricsService == null) {
            throw new NullPointerException("metricsService is marked non-null but is null");
        }
        if (machineProperties == null) {
            throw new NullPointerException("machineProperties is marked non-null but is null");
        }
        if (filters == null) {
            throw new NullPointerException("filters is marked non-null but is null");
        }
        if (metadataTransformers == null) {
            throw new NullPointerException("metadataTransformers is marked non-null but is null");
        }
        if (isDisabledPredicate == null) {
            throw new NullPointerException("isDisabledPredicate is marked non-null but is null");
        }
    }

    @Override
    protected Set<String> extractIds(HpUxRawData rawData) {
        return Collections.unmodifiableSet(rawData.getCpus().keySet());
    }

    @Override
    protected void doAggregateUpdate(HpUxRawData rawData) {
        this.cpuPerf = rawData.getCpuPerfs().get("_Total");
    }

    @Override
    protected long getPercentIdle() {
        return Math.round(this.cpuPerf.getIdlePct());
    }

    @Override
    protected long getPercentBusy() {
        return 100L - this.getPercentIdle();
    }

    @Override
    protected Optional<Long> getPercentStolen() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentUser() {
        return Optional.of((Object)Math.round(this.cpuPerf.getUserPct()));
    }

    @Override
    protected Optional<Long> getPercentSystem() {
        return Optional.of((Object)Math.round(this.cpuPerf.getSystemPct()));
    }

    @Override
    protected Map<String, String> getOsSpecificProperties() {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        return properties.build();
    }

    @Override
    protected Optional<Long> getPercentNice() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentSoftIRQ() {
        return Optional.absent();
    }

    @Override
    protected Optional<Long> getPercentIoWait() {
        return Optional.absent();
    }

    @Override
    @Generated
    public String toString() {
        return "HpUxCpus(super=" + super.toString() + ", cpuPerf=" + String.valueOf(this.cpuPerf) + ")";
    }
}

